<?php
/**
 * TGM PLUGIN ACTIVATION
 *
 * Activates plugins needed by theme
 *
 * @package harmonix
 */

// Activate TGM Class
require_once get_template_directory() . '/inc/apis/class-tgm-plugin-activation.php';

if ( ! function_exists( 'harmonix_register_plugins' ) ) {
	function harmonix_register_plugins() {
		$plugins = array(
			array(
				'name'               => esc_html__( 'WooCommerce', 'harmonix' ), // The plugin name
				'slug'               => 'woocommerce', // The plugin slug (typically the folder name)
				'required'           => true, // If false, the plugin is only 'recommended' instead of required
			),
			array(
				'name'               => esc_html__( 'Tickera', 'harmonix' ), // The plugin name
				'slug'               => 'tickera-event-ticketing-system', // The plugin slug (typically the folder name)
				'required'           => false, // If false, the plugin is only 'recommended' instead of required
			),
			array(
				'name'               => esc_html__( 'Lightweight Accordion', 'harmonix' ), // The plugin name
				'slug'               => 'lightweight-accordion', // The plugin slug (typically the folder name)
				'required'           => false, // If false, the plugin is only 'recommended' instead of required
			),
			array(
				'name'               => esc_html__( 'Safe SVG', 'harmonix' ), // The plugin name
				'slug'               => 'safe-svg', // The plugin slug (typically the folder name)
				'required'           => false, // If false, the plugin is only 'recommended' instead of required
			),
		);

		$config = array(
			'id'           => 'harmonix',                 // Unique ID for hashing notices for multiple instances of TGMPA.
			'default_path' => '',                      // Default absolute path to bundled plugins.
			'menu'         => 'tgmpa-install-plugins', // Menu slug.
			'has_notices'  => true,                    // Show admin notices or not.
			'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
			'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => true,                   // Automatically activate plugins after installation or not.
			'message'      => '',

		);
		tgmpa( $plugins, $config );
	} // function
	add_action( 'tgmpa_register', 'harmonix_register_plugins' );
} // if
