<?php
/**
 * Block Patterns
 *
 * @package harmonix
 * @since 1.0
 */

/**
 * Register Block Pattern Category.
 */

if ( function_exists( 'register_block_pattern_category' ) ) {
	register_block_pattern_category(
		'tc-text',
		array( 'label' => _x( 'Themetick Text', 'Text pattern category', 'harmonix' ) )
);

	register_block_pattern_category(
		'tc-about',
		array( 'label' => _x('Themetick About', 'About pattern category', 'harmonix' ) )
);

	register_block_pattern_category(
'tc-event-listing',
array( 'label' => _x('Themetick Event Listing', 'Speakers pattern category', 'harmonix' ) )
	);


	register_block_pattern_category(
'tc-speakers',
array( 'label' => _x('Themetick Speakers', 'Speakers pattern category', 'harmonix' ) )
	);

	register_block_pattern_category(
		'tc-gallery',
		array( 'label' => _x('Themetick Gallery', 'Gallery pattern category', 'harmonix' ) )
);

	register_block_pattern_category(
		'tc-pricing',
		array( 'label' => _x('Themetick Pricing', 'Pricing pattern category', 'harmonix' ) )
);

register_block_pattern_category(
		'tc-contact',
		array( 'label' => _x( 'Themetick Contact', 'Contact pattern category', 'harmonix' ) )
);

	register_block_pattern_category(
'tc-location',
array( 'label' => _x( 'Themetick Location', 'Location pattern category', 'harmonix' ) )
	);

register_block_pattern_category(
		'tc-testimonial',
		array( 'label' => _x('Themetick Testimonials', 'Testimonials pattern category', 'harmonix' ) )
);

	register_block_pattern_category(
'tc-sponsors',
array( 'label' => _x('Themetick Sponsors', 'Testimonials pattern category', 'harmonix' ) )
	);

	register_block_pattern_category(
'tc-call-to-action',
array( 'label' => _x('Themetick Call To Action', 'Call to action pattern category', 'harmonix' ) )
	);

	register_block_pattern_category(
'tc-schedule',
array( 'label' => _x('Themetick Schedule', 'Call to action pattern category', 'harmonix' ) )
	);



/*

register_block_pattern_category(
		'tc-headers',
		array( 'label' => _x( $theme_name.' headers', 'Headers pattern category', 'harmonix' ) )
);

register_block_pattern_category(
		'tc-call-to-action',
		array( 'label' => _x( $theme_name.' call to action', 'Call to action pattern category', 'harmonix' ) )
);
*/



}


/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {

	// Text
	register_block_pattern(
		'tc/text-1',
		array(
			'title'       => __( 'Two columns of text with offset heading', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-text' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"4.97rem\",\"bottom\":\"5rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:4.97rem;padding-bottom:5rem\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4rem\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\" style=\"padding-bottom:4rem\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-color has-small-font-size\" style=\"color:#6635f4\">Experience the Excitement</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"lineHeight\":\"1\"}},\"fontSize\":\"gigantic\"} -->\r\n<h3 class=\"wp-block-heading has-gigantic-font-size\" style=\"line-height:1\">Music<br>Festival 2024</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"30%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:paragraph -->\r\n<p>This annual event brings together top musicians from around the world to perform in front of a passionate crowd of music lovers.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"4rem\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\r\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"align\":\"full\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}}} -->\r\n<div class=\"wp-block-columns alignfull\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Stellar Lineup</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>This year's lineup features some of the biggest names in the industry, including rock legends, pop sensations, and electronic dance music (EDM) superstars. With more than 20 artists set to perform over the three-day festival, you'll have plenty of opportunities to discover new favorites and enjoy the hits you love.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">A Spectacular Venue</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>Music Festival 2023 will take place at the breathtaking Meadowlands Stadium in New Jersey. This world-class venue is renowned for its incredible acoustics and stunning visuals, making it the perfect place to experience the magic of live music.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"full\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}}} -->\r\n<div class=\"wp-block-columns alignfull\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Festival Highlights</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>In addition to the incredible music lineup, Music Festival 2023 has plenty of other exciting events and activities to keep you entertained throughout the weekend. Some of the festival highlights include:</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:list -->\r\n<ul><!-- wp:list-item -->\r\n<li>Food and beverage vendors offering a wide range of delicious options</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Art installations and other visual experiences</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Interactive games and activities</li>\r\n<!-- /wp:list-item --></ul>\r\n<!-- /wp:list --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Get Your Tickets Now</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>Don't miss your chance to be part of the Music Festival 2023 experience. Tickets are on sale now, and with such an incredible lineup and venue, they're sure to go fast. Whether you're a die-hard fan of one of the headliners or just looking for a fun weekend of music and entertainment, Music Festival 2023 has something for everyone.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
		)
);
	register_block_pattern(
'tc/text-2',
array(
	'title'       => __( '4 blocks of text, one is a heading', 'harmonix' ),
	'viewportWidth' => 1680,
	'categories' => array( 'tc-text' ),
	'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#eaeaea\"},\"spacing\":{\"padding\":{\"top\":\"5rem\",\"bottom\":\"5rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-background\" style=\"background-color:#eaeaea;padding-top:5rem;padding-bottom:5rem\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"33.33%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:paragraph -->\r\n<p>The Future of Technology Conference is a two-day event that explores emerging technologies and their potential impact on society.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"66.66%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\r\n<h3 class=\"wp-block-heading has-large-font-size\">This conference brings together leading experts in the field of technology, policy makers, entrepreneurs, and thought leaders to discuss the latest trends and developments.</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:spacer {\"height\":\"18rem\"} -->\r\n<div style=\"height:18rem\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">What to expect</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>Attendees can expect a diverse program of keynote speeches, panel discussions, and workshops, all focused on the future of technology and its impact on various industries. In addition, there will be networking opportunities and an exhibition space showcasing the latest technology products and services.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Past experience</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>Whether you are an industry professional, an entrepreneur, or simply interested in the latest technology trends, this conference offers a unique opportunity to gain insights from experts in the field and connect with like-minded individuals. Join us at the Future of Technology Conference and be a part of shaping the future!</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
)
	);


	register_block_pattern(
'tc/text-3',
array(
	'title'       => __( 'Heading with two columns of text and buttons', 'harmonix' ),
	'viewportWidth' => 1680,
	'categories' => array( 'tc-text' ),
	'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:columns {\"align\":\"wide\"} -->\r\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"lineHeight\":\"1\"}},\"fontSize\":\"gigantic\"} -->\r\n<h3 class=\"wp-block-heading has-gigantic-font-size\" style=\"line-height:1\">TECH CON 2025</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\",\"left\":\"10%\"},\"padding\":{\"top\":\"5rem\"}}}} -->\r\n<div class=\"wp-block-columns\" style=\"padding-top:5rem\"><!-- wp:column {\"width\":\"30%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:heading {\"level\":3,\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\">Join Us in the Future<br>of Technology</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"70%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:heading {\"level\":4,\"fontSize\":\"medium\"} -->\r\n<h4 class=\"wp-block-heading has-medium-font-size\">We are thrilled to announce TECH CON 2025, a cutting-edge conference dedicated to exploring the latest trends and innovations in technology.</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#00000024\"},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\"}}}} -->\r\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50);background-color:#00000024;color:#00000024\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\",\"left\":\"10%\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"30%\",\"className\":\"l-desktop-only\"} -->\r\n<div class=\"wp-block-column l-desktop-only\" style=\"flex-basis:30%\"></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"70%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}}} -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"50%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:2rem;flex-basis:50%\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Networking and Collaboration</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>At TECH CON, you will have the opportunity to network with like-minded professionals, engage in thought-provoking discussions, and gain valuable insights into the latest tools driving the future of tech.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-outline\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Learn more</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"50%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:2rem;flex-basis:50%\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Interactive</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>This year's conference will focus on the theme \"Join Us in the Future of Technology,\" with a particular emphasis on emerging technologies like artificial intelligence, machine learning, and blockchain.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-outline\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Learn more</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\",\"left\":\"10%\"},\"padding\":{\"top\":\"5rem\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\" style=\"padding-top:5rem\"><!-- wp:column {\"width\":\"30%\",\"className\":\"l-desktop-only\"} -->\r\n<div class=\"wp-block-column l-desktop-only\" style=\"flex-basis:30%\"></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"70%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}}} -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"100%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:100%\"><!-- wp:paragraph -->\r\n<p>For more information and to register,<br>visit our website: <a href=\"#\">www.techcon2023.com</a>.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
)
	);


	register_block_pattern(
'tc/text-4',
array(
	'title'       => __( 'Left heading and three columns of text and buttons with a background image', 'harmonix' ),
	'viewportWidth' => 1680,
	'categories' => array( 'tc-text' ),
	'content'     => "<!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/11/hero-text.jpg\",\"id\":3263,\"dimRatio\":10,\"isDark\":false,\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\"} -->\r\n<div class=\"wp-block-cover alignfull is-light has-background-color has-text-color has-link-color\" style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-10 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3263\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/11/hero-text.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-right:0;padding-left:0\"><!-- wp:columns {\"align\":\"wide\"} -->\r\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"typography\":{\"lineHeight\":\"1.1\"}},\"fontSize\":\"hugee\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-left has-hugee-font-size\" style=\"line-height:1.1\">Digital Dimension Conference.</h2>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:spacer {\"height\":\"40vh\"} -->\r\n<div style=\"height:40vh\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\",\"left\":\"10%\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"30%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"3rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:3rem;flex-basis:30%\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">About DD 2026<br>Conference</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"70%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"50%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:1rem;flex-basis:50%\"><!-- wp:paragraph -->\r\n<p>The Digital Dimension Conference is an annual gathering of 3D artists, designers, animators, and game developers from around the world. The conference is aimed at providing attendees with insights into the latest trends, techniques, and technologies in the 3D industry.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"50%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:paragraph -->\r\n<p>The Digital Dimension Conference is an annual gathering of 3D artists, designers, animators, and game developers from around the world. The conference is aimed at providing attendees with insights into the latest trends, techniques, and technologies in the 3D industry.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:group -->",
)
	);


register_block_pattern(
	'tc/text-5',
	array(
		'title'       => __( 'Large heading with three blocks of text', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-text' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4rem\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\" style=\"padding-bottom:4rem\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-center has-text-color has-small-font-size\" style=\"color:#6635f4\">Join us for the ultimate foodie experience</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"lineHeight\":\"1\"},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"hugee\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-center has-hugee-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--20);line-height:1\">Taste of the World food festival!</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"400px\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"small\"} -->\r\n<p class=\"has-text-align-center has-small-font-size\">Get your tickets now and experience the world on your plate!</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"2%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"color\":{\"background\":\"#f6f6fb\"},\"border\":{\"radius\":\"6px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\"}},\"dimensions\":{\"minHeight\":\"\"}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-background\" style=\"border-radius:6px;background-color:#f6f6fb;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-left has-small-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--50)\">A Celebration of International Cuisine Festival</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}}} -->\r\n<p class=\"has-text-align-left\" style=\"padding-bottom:var(--wp--preset--spacing--30)\">Sample a diverse array of delicious cuisines from around the globe, prepared by renowned chefs and local vendors. Indulge in gourmet dishes, artisanal sweets, and refreshing beverages, all in one place.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"typography\":{\"fontSize\":\"0.75rem\"}},\"className\":\"is-style-outline\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline\" style=\"font-size:0.75rem\"><a class=\"wp-block-button__link wp-element-button\">Learn more</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"color\":{\"background\":\"#f6f6fb\"},\"border\":{\"radius\":\"6px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\"}},\"dimensions\":{\"minHeight\":\"\"}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-background\" style=\"border-radius:6px;background-color:#f6f6fb;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"85%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:85%\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-left has-small-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--50)\">Indulge in the Flavors of FoodieFest: Join Us Now</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}}} -->\r\n<p class=\"has-text-align-left\" style=\"padding-bottom:var(--wp--preset--spacing--30)\">Don't miss out on this culinary adventure, taking place at our outdoor venue in the heart of the city. With live music, entertainment, and activities for all ages, it's the perfect way to spend a weekend.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"typography\":{\"fontSize\":\"0.75rem\"}},\"className\":\"is-style-outline\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline\" style=\"font-size:0.75rem\"><a class=\"wp-block-button__link wp-element-button\">Learn more</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"color\":{\"background\":\"#f6f6fb\"},\"border\":{\"radius\":\"6px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-background\" style=\"border-radius:6px;background-color:#f6f6fb;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"85%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:85%\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-left has-small-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--50)\">Come and Experience the Ultimate Food Adventure</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}}} -->\r\n<p class=\"has-text-align-left\" style=\"padding-bottom:var(--wp--preset--spacing--30)\">Get your tickets now and experience the world on your plate! The festival takes place on June 25-26 at our venue located at 123 Main Street.<br>Purchase your tickets today.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"typography\":{\"fontSize\":\"0.75rem\"}},\"className\":\"is-style-outline\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline\" style=\"font-size:0.75rem\"><a class=\"wp-block-button__link wp-element-button\">Buy ticket now</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
	)
);


		register_block_pattern(
		'tc/text-6',
		array(
			'title'       => __( 'Three blocks of text and buttons and centered heading', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-text' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}},\"color\":{\"background\":\"#0b26ff\"}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-background\" style=\"background-color:#0b26ff;padding-top:6rem;padding-bottom:6rem\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"8rem\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\" style=\"padding-bottom:8rem\"><!-- wp:column {\"textColor\":\"background\"} -->\r\n<div class=\"wp-block-column has-background-color has-text-color\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"textColor\":\"background\",\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-center has-background-color has-text-color has-small-font-size\">A CTA for Environmental Sustainability</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"lineHeight\":\"1\"},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"hugee\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-center has-hugee-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--20);line-height:1\">ElektroTech Summit 2027</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"480px\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"small\"} -->\r\n<p class=\"has-text-align-center has-small-font-size\">Join us for Green Summit 2027, the premier conference for global leaders in environmental sustainability.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}},\"textColor\":\"white\",\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait has-white-color has-text-color\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|60\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"align\":\"center\",\"id\":836,\"width\":\"68px\",\"height\":\"68px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":{\"duotone\":[\"rgb(255, 255, 255)\",\"#CCC\"]}}} -->\r\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/Speaker.svg\" alt=\"\" class=\"wp-image-836\" style=\"width:68px;height:68px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-center has-small-font-size\">Keynote Speakers</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\"} -->\r\n<p class=\"has-text-align-center\">We are excited to announce a lineup of keynote speakers who are at the forefront of the sustainability movement, including Jane Goodall, Bill McKibben, and Greta Thunberg.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">Learn more</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|60\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"align\":\"center\",\"id\":837,\"width\":\"68px\",\"height\":\"68px\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"style\":{\"color\":{\"duotone\":[\"rgb(255, 255, 255)\",\"#CCC\"]}}} -->\r\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/workshop.svg\" alt=\"\" class=\"wp-image-837\" style=\"width:68px;height:68px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-center has-small-font-size\">Interactive Workshops</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\"} -->\r\n<p class=\"has-text-align-center\">At Green Summit 2023, you'll have the opportunity to participate in a variety of interactive workshops that will help you develop the skills and knowledge needed to create a sustainable future.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">Learn more</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|60\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"align\":\"center\",\"id\":838,\"width\":\"68px\",\"height\":\"68px\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"style\":{\"color\":{\"duotone\":[\"rgb(255, 255, 255)\",\"#CCC\"]}}} -->\r\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/netvorking.svg\" alt=\"\" class=\"wp-image-838\" style=\"width:68px;height:68px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-center has-small-font-size\">Networking and Collaboration</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\"} -->\r\n<p class=\"has-text-align-center\">We are excited to announce a lineup of keynote speakers who are at the forefront of the sustainability movement, including Jane Goodall, Bill McKibben, and Greta Thunberg.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">Learn more</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);


		register_block_pattern(
		'tc/text-7',
		array(
			'title'       => __( 'Left heading and text block with two numbers of the right', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-text' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:columns {\"align\":\"wide\"} -->\r\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-color has-small-font-size\" style=\"color:#6635f4\">Global Perspectives 2026</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"65%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:65%\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"lineHeight\":\"1\"}},\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-big-font-size\" style=\"line-height:1\">Global Perspectives on Innovation and Technology</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#00000024\"},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\"}}}} -->\r\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50);background-color:#00000024;color:#00000024\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"9%\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\r\n<p>Our conference will offer a diverse range of sessions and workshops, with a focus on practical applications and real-world solutions. With participants from over 30 countries, you'll have the opportunity to network with a global community of professionals and learn from their unique perspectives and experiences.<br><br>Whether you're interested in cutting-edge technologies such as artificial intelligence and blockchain, or exploring sustainable practices and entrepreneurship strategies, our conference will provide you with the knowledge and tools to drive innovation in your organization. Join us for this exciting event and be a part of the global conversation on innovation and technology!</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\",\"margin\":{\"top\":\"var:preset|spacing|50\"}}}} -->\r\n<div class=\"wp-block-buttons\" style=\"margin-top:var(--wp--preset--spacing--50)\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">BUY TICKET NOW</a></div>\r\n<!-- /wp:button -->\r\n\r\n<!-- wp:button {\"className\":\"is-style-outline\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">VIEW CONFERENCE AGENDA</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:columns {\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"50%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"level\":4,\"fontSize\":\"gigantic\"} -->\r\n<h4 class=\"wp-block-heading has-gigantic-font-size\">+64</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"90%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:90%\"><!-- wp:paragraph -->\r\n<p>Speakers and panelists from diverse backgrounds</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"50%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"level\":4,\"fontSize\":\"gigantic\"} -->\r\n<h4 class=\"wp-block-heading has-gigantic-font-size\">32</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>A Multi-Location Event with 32+ Hands-On Workshops</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);


register_block_pattern(
	'tc/text-8',
	array(
		'title'       => __( 'Left heading and horizontal text blocks', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-text' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|60\"}}},\"className\":\"stack-on-tablet-landscape \"} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top stack-on-tablet-landscape\" style=\"padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"66.6%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:66.6%\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"lineHeight\":\"1\"}},\"fontSize\":\"hugee\"} -->\r\n<h3 class=\"wp-block-heading has-hugee-font-size\" style=\"line-height:1\">A Collective of Proficiency:</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"padding-top:var(--wp--preset--spacing--30)\"><!-- wp:paragraph -->\r\n<p>We've established a dedicated organization centered around technology, aiming to address the most intricate hurdles with utmost efficiency.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy ticket now</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#00000024\"},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\"}}}} -->\r\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50);background-color:#00000024;color:#00000024\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"8%\"},\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}},\"className\":\"stack-on-tablet-landscape \"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-landscape\" style=\"padding-bottom:var(--wp--preset--spacing--30)\"><!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\r\n<h3 class=\"wp-block-heading has-large-font-size\">People</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"55%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:55%\"><!-- wp:paragraph -->\r\n<p>Our organization boasts a team of exceptional individuals, each a seasoned expert in their respective technological domains.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"\"} -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"style\":{\"typography\":{\"textTransform\":\"none\",\"lineHeight\":\"0.9\"}},\"fontSize\":\"big\"} -->\r\n<h4 class=\"wp-block-heading has-big-font-size\" style=\"line-height:0.9;text-transform:none\">+237</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"8%\"},\"padding\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|30\"}},\"border\":{\"top\":{\"color\":\"#00000024\",\"width\":\"1px\"}}},\"className\":\"stack-on-tablet-landscape \"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-landscape\" style=\"border-top-color:#00000024;border-top-width:1px;padding-top:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30)\"><!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\r\n<h3 class=\"wp-block-heading has-large-font-size\">Locations</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"55%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:55%\"><!-- wp:paragraph -->\r\n<p>Our headquarters, nestled in a hub of innovation, provides the heartbeat of our operations.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"\"} -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"style\":{\"typography\":{\"lineHeight\":\"0.9\"}},\"fontSize\":\"big\"} -->\r\n<h4 class=\"wp-block-heading has-big-font-size\" style=\"line-height:0.9\">+6</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"8%\"},\"padding\":{\"top\":\"var:preset|spacing|40\"}},\"border\":{\"top\":{\"color\":\"#00000024\",\"width\":\"1px\"},\"right\":{},\"bottom\":{},\"left\":{}}},\"className\":\"stack-on-tablet-landscape \"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-landscape\" style=\"border-top-color:#00000024;border-top-width:1px;padding-top:var(--wp--preset--spacing--40)\"><!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\r\n<h3 class=\"wp-block-heading has-large-font-size\">Projects</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"55%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:55%\"><!-- wp:paragraph -->\r\n<p>At the core of our organization's endeavors lie a series of remarkable projects that showcase our technological prowess.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"\"} -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"style\":{\"typography\":{\"lineHeight\":\"0.9\"}},\"fontSize\":\"big\"} -->\r\n<h4 class=\"wp-block-heading has-big-font-size\" style=\"line-height:0.9\">+37</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
	)
);



register_block_pattern(
	'tc/text-9',
	array(
		'title'       => __( 'Left heading with button and 4 text blocks on the right', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-text' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"8rem\",\"bottom\":\"8rem\"}},\"color\":{\"background\":\"#f6f6fb\"}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-background\" style=\"background-color:#f6f6fb;padding-top:8rem;padding-bottom:8rem\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"8%\"}}},\"className\":\"stack-on-tablet-landscape \"} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center stack-on-tablet-landscape\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|60\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-bottom:var(--wp--preset--spacing--60);flex-basis:40%\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-color has-small-font-size\" style=\"color:#6635f4\">Why join exibit</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-big-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--20)\">Why you should Join Event</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"70%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}}} -->\r\n<p style=\"padding-bottom:var(--wp--preset--spacing--40)\">Uncover how they are reshaping the business landscape in response to the ever-shifting dynamics of technology, consumer preferences, and industry trends.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">BUY TICKET NOW</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\"}},\"border\":{\"radius\":\"6px\"}},\"backgroundColor\":\"background\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-background-background-color has-background\" style=\"border-radius:6px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":838,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/netvorking.svg\" alt=\"\" class=\"wp-image-838\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"},\"margin\":{\"top\":\"var:preset|spacing|20\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--40)\">Networking</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>Build meaningful connections with industry peers and professionals, fostering collaboration and growth.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\"}},\"border\":{\"radius\":\"6px\"},\"dimensions\":{\"minHeight\":\"\"}},\"backgroundColor\":\"background\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-background-background-color has-background\" style=\"border-radius:6px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":840,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/people.svg\" alt=\"\" class=\"wp-image-840\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"},\"margin\":{\"top\":\"var:preset|spacing|20\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--40)\">New People</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>Opportunities to meet and engage with a diverse array of individuals, expanding your horizons.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\"}},\"border\":{\"radius\":\"6px\"}},\"backgroundColor\":\"background\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-background-background-color has-background\" style=\"border-radius:6px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":836,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/Speaker.svg\" alt=\"\" class=\"wp-image-836\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"},\"margin\":{\"top\":\"var:preset|spacing|20\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--40)\">Great Speakers</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>Immerse yourself in enlightening talks from experts, gaining valuable insights and knowledge.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\"}},\"border\":{\"radius\":\"6px\"},\"dimensions\":{\"minHeight\":\"\"}},\"backgroundColor\":\"background\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-background-background-color has-background\" style=\"border-radius:6px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":841,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/fun.svg\" alt=\"\" class=\"wp-image-841\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"},\"margin\":{\"top\":\"var:preset|spacing|20\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--40)\">Have Fun</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>Delight in a lively and enjoyable atmosphere, engage, and make lasting memories.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
	)
);

		//ABOUT PATTERNS




		register_block_pattern(
		'tc/about-1',
		array(
			'title'       => __( 'Fullwidth image with two columns', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-about' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:heading {\"level\":3,\"align\":\"wide\",\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-text-color has-small-font-size\" style=\"color:#6635f4\">Meet the Team</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\" style=\"padding-bottom:var(--wp--preset--spacing--30)\"><!-- wp:column {\"width\":\"72%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:72%\"><!-- wp:heading {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4%\"}}},\"fontSize\":\"big\"} -->\r\n<h2 class=\"wp-block-heading alignwide has-big-font-size\" style=\"padding-bottom:4%\">Unleashing Creativity: Meet the Team Behind the Conference</h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:image {\"align\":\"wide\",\"id\":3272,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image alignwide size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/about-f.jpg\" alt=\"Alternative text\" class=\"wp-image-3272\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"4%\"},\"blockGap\":{\"left\":\"10%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\" style=\"padding-top:4%\"><!-- wp:column {\"width\":\"33.33%\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"2%\",\"bottom\":\"4rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-right:2%;padding-bottom:4rem;flex-basis:33.33%\"><!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2vw\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"padding-bottom:2vw\">Stay Connected</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":5,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0\"}}},\"fontSize\":\"tiny\"} -->\r\n<h5 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-bottom:0\">For general inquiries</h5>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.3rem\"}}}} -->\r\n<p style=\"margin-top:0.3rem\"><a href=\"mailto:info@yourconference.com\">info@yourconference.com</a></p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:heading {\"level\":5,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0\",\"top\":\"2rem\"}}},\"fontSize\":\"tiny\"} -->\r\n<h5 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-top:2rem;margin-bottom:0\">For sponsorships</h5>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.3rem\"}}}} -->\r\n<p style=\"margin-top:0.3rem\"><a href=\"mailto:sponsorships@conference.com\">sponsorships@conference.com</a></p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#0000001f\"},\"spacing\":{\"margin\":{\"top\":\"2rem\",\"bottom\":\"2rem\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:2rem;margin-bottom:2rem;background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"right\":\"2rem\"}}}} -->\r\n<p style=\"padding-right:2rem\">Connect with us on social media to stay updated on the latest news, speaker announcements, and exciting updates:</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"foreground\",\"iconColorValue\":\"#000000\",\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\"}}},\"className\":\"is-style-logos-only\"} -->\r\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /--></ul>\r\n<!-- /wp:social-links --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"66.66%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}},\"fontSize\":\"large\"} -->\r\n<h3 class=\"wp-block-heading has-large-font-size\" style=\"padding-bottom:2rem\">We are a passionate team of creative visionaries and event organizers dedicated to crafting exceptional Design Conference experiences.</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"5%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\r\n<p>We pride ourselves on delivering a seamless and immersive conference experience for our attendees. From carefully selecting renowned speakers and thought-provoking topics to creating engaging workshops and networking opportunities, we strive to create an environment that sparks creativity.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\r\n<p>Join us on this exciting journey as we continue to push the envelope of what's possible in the world of design. Whether you're a seasoned professional, a budding designer, or simply curious about the power of design, we invite you to be part of our vibrant community and experience the magic.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/about-2',
		array(
			'title'       => __( 'Two columns with text and image', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-about' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"5rem\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\" style=\"padding-bottom:5rem\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-text-color has-small-font-size\" style=\"color:#6635f4\">About me</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-medium-font-size\">I am driven by a deep passion for inspiring and empowering individuals to unlock their full potential. With years of experience and a genuine desire to make a positive impact, I have had the privilege of speaking at various events, conferences, and workshops.</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"color\":{\"text\":\"#6635f4\"},\"spacing\":{\"padding\":{\"bottom\":\"4vw\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-text-color has-small-font-size\" style=\"color:#6635f4;padding-bottom:4vw\">My mission</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"60%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:2rem;flex-basis:60%\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}}} -->\r\n<p style=\"padding-bottom:var(--wp--preset--spacing--40)\">Ignite a spark within each person I encounter, encouraging them to embrace their strengths, overcome challenges, and pursue their dreams with unwavering determination. <br><br>I firmly believe that personal growth and self-discovery are the catalysts for achieving greatness. With a focus on mindset, resilience, and goal-setting, I empower individuals to break free from limiting beliefs and embrace a life of purpose and fulfillment.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>Let's stay connected on social media to continue the conversation and share inspiring content.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"foreground\",\"iconColorValue\":\"#000000\",\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\"}}},\"className\":\"is-style-logos-only\"} -->\r\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /--></ul>\r\n<!-- /wp:social-links -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#0000001f\"},\"spacing\":{\"margin\":{\"top\":\"2vw\",\"bottom\":\"2vw\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:2vw;margin-bottom:2vw;background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>For inquiries, speaking engagements, or collaboration opportunities, please email me at:</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph -->\r\n<p><a href=\"mailto:yourmail@gmail.com\">yourmail@gmail.com</a></p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":3266,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-large has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/about-p-927x1024.jpg\" alt=\"\" class=\"wp-image-3266\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);


		register_block_pattern(
		'tc/about-3',
		array(
			'title'       => __( 'Title with an image in the background and two text columns', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-about' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/11/about-fw.jpg\",\"id\":3268,\"dimRatio\":0,\"contentPosition\":\"center center\",\"isDark\":false,\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4rem\"},\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|60\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\"} -->\r\n<div class=\"wp-block-cover alignfull is-light has-background-color has-text-color has-link-color\" style=\"margin-top:0;margin-bottom:var(--wp--preset--spacing--60);padding-bottom:4rem\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3268\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/11/about-fw.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"45vh\"} -->\r\n<div style=\"height:45vh\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"align\":\"wide\",\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-text-align-left has-small-font-size\">About us</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\"} -->\r\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:heading {\"style\":{\"typography\":{\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0\"}}},\"fontSize\":\"hugee\"} -->\r\n<h2 class=\"wp-block-heading has-hugee-font-size\" style=\"margin-top:0;line-height:1\">Rocking the Stage with Passion and Energy</h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group --></div></div>\r\n<!-- /wp:cover -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\"},\"padding\":{\"top\":\"4rem\",\"bottom\":\"4rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"margin-top:0;padding-top:4rem;padding-bottom:4rem\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"3rem\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\" style=\"padding-bottom:3rem\"><!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"level\":4,\"align\":\"wide\",\"fontSize\":\"medium\"} -->\r\n<h4 class=\"wp-block-heading alignwide has-medium-font-size\">We are a dynamic rock band driven by our love for music</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"\",\"className\":\"l-desktop-only\"} -->\r\n<div class=\"wp-block-column l-desktop-only\"></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\r\n<p>As a band, we pride ourselves on our dedication to delivering unforgettable live experiences. With years of collective musical experience, we have honed our skills and crafted a signature sound that combines powerful riffs, infectious melodies, and heartfelt lyrics. Our goal is to transport our audience into a world where the music speaks to their souls and ignites their inner rock star.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\r\n<p>From small venues to large festivals, we have had the privilege of sharing our music with diverse audiences. The energy and connection we feel on stage is something we strive to share with everyone in attendance. We believe in the power of music to bring people together, to inspire, and to create lasting memories.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:columns {\"style\":{\"spacing\":{\"padding\":{\"top\":\"2rem\"}}}} -->\r\n<div class=\"wp-block-columns\" style=\"padding-top:2rem\"><!-- wp:column {\"width\":\"50%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Connect with us on social media to stay in the loop with all things related to our band:</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"foreground\",\"iconColorValue\":\"#000000\",\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\"}}},\"className\":\"is-style-logos-only\"} -->\r\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /--></ul>\r\n<!-- /wp:social-links --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
		)
		);


	register_block_pattern(
		'tc/about-4',
		array(
		'title'       => __( 'Two columns with image on the left and text on the right side', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-about' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6.3%\",\"bottom\":\"6.3%\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6.3%;padding-bottom:6.3%\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"33.33%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:image {\"id\":3269,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-large has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/about-pl-751x1024.jpg\" alt=\"\" class=\"wp-image-3269\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"style\":{\"typography\":{\"textTransform\":\"none\"}},\"fontSize\":\"gigantic\"} -->\r\n<h2 class=\"wp-block-heading has-gigantic-font-size\" style=\"text-transform:none\">About me</h2>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000026\"},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50);background-color:#00000026;color:#00000026\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-text-color has-small-font-size\" style=\"color:#6635f4\">My story</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--40)\">The act of creating music is a critical part of our existence, as it allows us to communicate and connect with others in ways that transcend words.</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"100%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:100%\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Solo Artist and Songwriter<br>2010 - Present</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">As a solo artist, Emily Summers has been captivating audiences with her powerful vocals and soulful songwriting. She has released multiple successful singles, including chart-topping hits like \"Rhythm of the Heart\" and \"Unbreakable,\" which have garnered attention and praise from both fans and industry professionals.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#0000001f\"},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40);background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Lead Vocalist, The Harmonics<br>2005 - 2010</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">As the lead vocalist of The Harmonics, a popular indie band, Emily played a pivotal role in the band's success. Together, they released three critically acclaimed albums and toured extensively, performing at renowned venues and festivals across the country.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--30)\"><!-- wp:heading {\"level\":4,\"fontSize\":\"tiny\"} -->\r\n<h4 class=\"wp-block-heading has-tiny-font-size\">Follow me on:</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"foreground\",\"iconColorValue\":\"#000000\",\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\"}}},\"className\":\"is-style-logos-only\"} -->\r\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /--></ul>\r\n<!-- /wp:social-links --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
	);


	register_block_pattern(
		'tc/about-5',
		array(
		'title'       => __( 'Large background with two text column and a title', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-about' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/11/about-bl.jpg\",\"id\":3270,\"dimRatio\":0,\"isDark\":false,\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6em\",\"bottom\":\"6em\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\"} -->\r\n<div class=\"wp-block-cover alignfull is-light has-background-color has-text-color has-link-color\" style=\"padding-top:6em;padding-bottom:6em\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3270\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/11/about-bl.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"align\":\"wide\",\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-text-align-left has-text-color has-small-font-size\" style=\"color:#6635f4\">About Me</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4rem\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\" style=\"padding-bottom:4rem\"><!-- wp:column {\"width\":\"65%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:65%\"><!-- wp:heading {\"textColor\":\"background\",\"fontSize\":\"hugee\"} -->\r\n<h2 class=\"wp-block-heading has-background-color has-text-color has-hugee-font-size\">Navigating Life's Journey</h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\"} -->\r\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"65%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:65%\"><!-- wp:columns {\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"100%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:100%\"><!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"8%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\r\n<p>I am an adventurous spirit with a love for exploring the unknown. Growing up, I always had a thirst for knowledge and a desire to push the boundaries of what I thought was possible. As I got older, I channeled that passion into traveling and experiencing new cultures.<br></p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\r\n<p>From trekking through the jungles of Southeast Asia to exploring the ancient ruins of South America, each adventure has left a lasting impression on me.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:spacer {\"height\":\"20vh\"} -->\r\n<div style=\"height:20vh\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"padding\":{\"top\":\"3.13rem\"}}}} -->\r\n<div class=\"wp-block-columns\" style=\"padding-top:3.13rem\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.45rem\"}}},\"fontSize\":\"tiny\"} -->\r\n<h4 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-bottom:0.45rem\">Send me an email:</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0px\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}}} -->\r\n<p class=\"has-link-color\" style=\"margin-top:0px\"><a href=\"mailto:yourmail@gmail.com\">yourmail@gmail.com</a></p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.63rem\"}}},\"fontSize\":\"tiny\"} -->\r\n<h4 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-bottom:0.63rem\">Follow me on:</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"background\",\"iconColorValue\":\"#fff\",\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|20\"}}},\"className\":\"is-style-logos-only\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\r\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"spotify\"} /--></ul>\r\n<!-- /wp:social-links --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"25%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:25%\"></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:group -->",
		)
	);


		register_block_pattern(
		'tc/event-listing-1',
		array(
			'title'       => __( 'Image on the left and event title on the right', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-event-listing' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|70\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":1336,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/event-moto.jpg\" alt=\"\" class=\"wp-image-1336\" style=\"border-radius:8px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"72%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:72%\"><!-- wp:heading {\"fontSize\":\"large\"} -->\r\n<h2 class=\"wp-block-heading has-large-font-size\">RevolutionX Motocross Mayhem</h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Date: August 15-18<br>Location: DirtRush Park, Arizona, USA</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"78%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:78%\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|20\"}}}} -->\r\n<p style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--20)\">Brace yourself for an adrenaline-fueled extravaganza at the RevolutionX Motocross Mayhem! Experience the heart-pounding action as fearless motocross riders from around the globe converge at DirtRush Park.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-outline\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/event-listing-2',
		array(
			'title'       => __( 'List of events with zig-zag pattern', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-event-listing' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|10\"}}},\"fontSize\":\"hugee\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-center has-hugee-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--10)\">Upcoming Festivals</h2>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|60\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"520px\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:paragraph {\"align\":\"center\"} -->\r\n<p class=\"has-text-align-center\">Step into a realm where culinary traditions from every corner of the globe converge, creating a tapestry of tastes that's as rich and vibrant as our world itself.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:media-text {\"align\":\"full\",\"mediaId\":1350,\"mediaLink\":\"https://themetick.com/patterns/event-listing/food1/\",\"mediaType\":\"image\",\"imageFill\":true,\"style\":{\"color\":{\"background\":\"#f9f9fe\"}}} -->\r\n<div class=\"wp-block-media-text alignfull is-stacked-on-mobile is-image-fill has-background\" style=\"background-color:#f9f9fe\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(https://themetick.com/wp-content/uploads/2023/08/food1-1024x991.jpg);background-position:50% 50%\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/food1-1024x991.jpg\" alt=\"\" class=\"wp-image-1350 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--70);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--70);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:heading {\"fontSize\":\"large\"} -->\r\n<h2 class=\"wp-block-heading has-large-font-size\">Taste of Tropics Festival</h2>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Type of Cuisine: Caribbean and Tropical<br>Date: August 15-18<br>Location: Miami Beach, Florida</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|20\"}}}} -->\r\n<p style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--20)\">Immerse yourself in the vibrant colors, flavors, and rhythms of the Caribbean at the Taste of Tropics Festival. From jerk chicken to exotic fruit cocktails, indulge in a feast of tropical delights while swaying to the rhythm of live reggae and calypso bands.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-outline\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div></div>\r\n<!-- /wp:media-text -->\r\n\r\n<!-- wp:media-text {\"align\":\"full\",\"mediaPosition\":\"right\",\"mediaId\":1362,\"mediaLink\":\"https://themetick.com/patterns/event-listing/food2/\",\"mediaType\":\"image\",\"imageFill\":true,\"style\":{\"color\":{\"background\":\"#e8e8eb\"},\"spacing\":{\"margin\":{\"top\":\"0\"}}}} -->\r\n<div class=\"wp-block-media-text alignfull has-media-on-the-right is-stacked-on-mobile is-image-fill has-background\" style=\"background-color:#e8e8eb;margin-top:0\"><div class=\"wp-block-media-text__content\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--70);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--70);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:heading {\"fontSize\":\"large\"} -->\r\n<h2 class=\"wp-block-heading has-large-font-size\">Sushi Fusion Fiesta</h2>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Type of Cuisine: Japanese Fusion<br>Date: October 5-7<br>Location: Los Angeles, California</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|20\"}}}} -->\r\n<p style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--20)\">Description: Savor the artistry of Japanese cuisine with a modern twist at the Sushi Fusion Fiesta. This festival showcases the creative fusion of traditional sushi with international flavors, from spicy tuna tacos to teriyaki sliders.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-outline\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div><figure class=\"wp-block-media-text__media\" style=\"background-image:url(https://themetick.com/wp-content/uploads/2023/08/food2-1024x964.jpg);background-position:50% 50%\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/food2-1024x964.jpg\" alt=\"\" class=\"wp-image-1362 size-full\"/></figure></div>\r\n<!-- /wp:media-text --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/event-listing-3',
		array(
			'title'       => __( 'Three column event listing', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-event-listing' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:heading {\"level\":5,\"align\":\"wide\",\"style\":{\"color\":{\"text\":\"#6635f4\"},\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|10\"}}},\"fontSize\":\"small\"} -->\r\n<h5 class=\"wp-block-heading alignwide has-text-color has-small-font-size\" style=\"color:#6635f4;margin-bottom:var(--wp--preset--spacing--10)\">Cross-Country Cycling Showcase</h5>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":4,\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|10\"},\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}},\"fontSize\":\"hugee\"} -->\r\n<h4 class=\"wp-block-heading alignwide has-hugee-font-size\" style=\"margin-top:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--40)\">Upcoming Events</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"1rem\",\"bottom\":\"3rem\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\" style=\"padding-top:1rem;padding-bottom:3rem\"><!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\r\n<p>Join us as we embark on a journey to unravel the limitless possibilities and transformative impact of AI in various domains.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|50\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:image {\"id\":1377,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/bike-f1.jpg\" alt=\"\" class=\"wp-image-1377\" style=\"border-radius:8px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|30\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:var(--wp--preset--spacing--30)\">Mountain Majesty XC Challenge</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Date: August 14-15<br>Location: Aspen, Colorado, USA</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|10\"}}}} -->\r\n<p style=\"padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--10)\">Conquer the rugged trails and breathtaking landscapes of Aspen at the Mountain Majesty XC Challenge.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-outline\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:image {\"id\":1378,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/bike-f2.jpg\" alt=\"\" class=\"wp-image-1378\" style=\"border-radius:8px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|30\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:var(--wp--preset--spacing--30)\">Alpine Trails XC Expedition</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Date: September 25-26<br>Location: Chamonix, France</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|10\"}}}} -->\r\n<p style=\"padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--10)\">Traverse through charming villages, along crystal-clear rivers, and up mountain passes while soaking in the stunning vistas.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-outline\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:image {\"id\":1379,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"8px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/bike-f3.jpg\" alt=\"\" class=\"wp-image-1379\" style=\"border-radius:8px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|30\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:var(--wp--preset--spacing--30)\">Cascade Summit XC Rally</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Date: April 17-19<br>Location: Bend, Oregon, USA</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|10\"}}}} -->\r\n<p style=\"padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--10)\">Join fellow cycling enthusiasts at the Cascade Summit XC Rally for an unforgettable cross-country experience in the landscapes of Bend.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-outline\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);


		register_block_pattern(
		'tc/event-listing-4',
		array(
			'title'       => __( 'Big event title with background image', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-event-listing' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/08/eteck.jpg\",\"id\":1381,\"dimRatio\":40,\"focalPoint\":{\"x\":0.4,\"y\":0.5},\"minHeight\":100,\"minHeightUnit\":\"vh\",\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}}}} -->\r\n<div class=\"wp-block-cover alignfull\" style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);min-height:100vh\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-40 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-1381\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/08/eteck.jpg\" style=\"object-position:40% 50%\" data-object-fit=\"cover\" data-object-position=\"40% 50%\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"},\"padding\":{\"bottom\":\"40vh\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\" style=\"padding-bottom:40vh\"><!-- wp:column {\"width\":\"70%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"3rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:3rem;flex-basis:70%\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"fontSize\":\"hugee\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-left has-hugee-font-size\">ElektroTech<br>Con. 2024</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">Buy Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-link-color has-small-font-size\"><a href=\"#\">View Con. Agenda</a></h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"30%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-color has-small-font-size\" style=\"color:#6635f4\">Greenfield, USD</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":4,\"fontSize\":\"medium\"} -->\r\n<h4 class=\"wp-block-heading has-medium-font-size\">Shaping the Future of Electrical Technology and Innovation</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>This dynamic event brings together industry leaders, researchers, and enthusiasts to explore the latest advancements and trends in electrical engineering.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:heading {\"level\":5,\"align\":\"wide\",\"style\":{\"color\":{\"text\":\"#ffffff4f\"}},\"fontSize\":\"tiny\"} -->\r\n<h5 class=\"wp-block-heading alignwide has-text-color has-tiny-font-size\" style=\"color:#ffffff4f\"><a href=\"#\">SCROLL TO FIND OUT MORE</a></h5>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/event-listing-5',
		array(
			'title'       => __( 'Three column event listing with image backgrounds ', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-event-listing' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:heading {\"level\":5,\"align\":\"wide\",\"style\":{\"color\":{\"text\":\"#6635f4\"},\"spacing\":{\"margin\":{\"bottom\":\"0\"}}},\"fontSize\":\"small\"} -->\r\n<h5 class=\"wp-block-heading alignwide has-text-color has-small-font-size\" style=\"color:#6635f4;margin-bottom:0\">Upcoming Events 2024/2025</h5>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":4,\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|10\"},\"padding\":{\"bottom\":\"0\"}}},\"fontSize\":\"gigantic\"} -->\r\n<h4 class=\"wp-block-heading alignwide has-gigantic-font-size\" style=\"margin-top:var(--wp--preset--spacing--10);padding-bottom:0\">Inspire innovation.</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|50\"},\"blockGap\":{\"left\":\"var:preset|spacing|60\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\" style=\"padding-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--50)\"><!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\r\n<p>Join us as we embark on a journey to unravel the limitless possibilities and transformative impact of AI in various domains.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"\"} -->\r\n<div class=\"wp-block-column\"><!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-outline\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">view all events</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|30\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/11/eve-ai3.jpg\",\"id\":3314,\"dimRatio\":0,\"minHeight\":35,\"minHeightUnit\":\"vw\",\"contentPosition\":\"bottom left\",\"isDark\":false,\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"className\":\"has-rounded-edges\"} -->\r\n<div class=\"wp-block-cover is-light has-custom-content-position is-position-bottom-left has-rounded-edges has-background-color has-text-color has-link-color\" style=\"padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);min-height:35vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3314\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/11/eve-ai3.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"20vh\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:20vh\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"1rem\"}}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-left has-medium-font-size\" style=\"margin-bottom:1rem\">Conference on<br>Artificial Intelligence</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Location: Futuria City<br>Time: November 15-17, 2023</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"style\":{\"typography\":{\"fontSize\":\"12px\"}}} -->\r\n<div class=\"wp-block-button has-custom-font-size\" style=\"font-size:12px\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">Buy Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/11/eve-ai2.jpg\",\"id\":3316,\"dimRatio\":0,\"minHeight\":35,\"minHeightUnit\":\"vw\",\"contentPosition\":\"bottom left\",\"isDark\":false,\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"className\":\"has-rounded-edges\"} -->\r\n<div class=\"wp-block-cover is-light has-custom-content-position is-position-bottom-left has-rounded-edges has-background-color has-text-color has-link-color\" style=\"padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);min-height:35vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3316\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/11/eve-ai2.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"20vh\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:20vh\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"1rem\"},\"padding\":{\"right\":\"2rem\"}}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-left has-medium-font-size\" style=\"margin-bottom:1rem;padding-right:2rem\">Symposium on<br>Ethical AI - SEAI</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Location: Tranquil Haven Resort<br>Time: April 8-10, 2023</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"style\":{\"typography\":{\"fontSize\":\"12px\"}}} -->\r\n<div class=\"wp-block-button has-custom-font-size\" style=\"font-size:12px\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">Buy Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/11/eve-ai1.jpg\",\"id\":3317,\"dimRatio\":0,\"minHeight\":35,\"minHeightUnit\":\"vw\",\"contentPosition\":\"bottom left\",\"isDark\":false,\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"className\":\"has-rounded-edges\"} -->\r\n<div class=\"wp-block-cover is-light has-custom-content-position is-position-bottom-left has-rounded-edges has-background-color has-text-color has-link-color\" style=\"padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);min-height:35vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3317\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/11/eve-ai1.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"20vh\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:20vh\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"1rem\",\"right\":\"2rem\"}}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-left has-medium-font-size\" style=\"margin-right:2rem;margin-bottom:1rem\">Future of AI <br>Summit - FAIS</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Location: Technopolis Expo<br>Time: June 20-22, 2023</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"style\":{\"typography\":{\"fontSize\":\"12px\"}}} -->\r\n<div class=\"wp-block-button has-custom-font-size\" style=\"font-size:12px\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">Buy Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/event-listing-6',
		array(
			'title'       => __( 'Large title event on the left with event info on the right', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-event-listing' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/08/jazz-n2.jpg\",\"id\":1396,\"dimRatio\":40,\"align\":\"full\"} -->\r\n<div class=\"wp-block-cover alignfull\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-40 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-1396\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/08/jazz-n2.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer {\"height\":\"8vw\"} -->\r\n<div style=\"height:8vw\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center stack-on-tablet-portrait\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"60%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"3rem\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-bottom:3rem;flex-basis:60%\"><!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"gigantic\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-left has-gigantic-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--20)\">BlueNotes<br>Festival</h2>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"60%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:paragraph -->\r\n<p>Join us for the ultimate jazz experience at BlueNotes Festivalt! This three-day event will bring together some of the biggest names in the industry, along with emerging talents from around the world.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:heading {\"level\":5,\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}},\"spacing\":{\"padding\":{\"top\":\"1rem\"}}},\"fontSize\":\"small\"} -->\r\n<h5 class=\"wp-block-heading has-link-color has-small-font-size\" style=\"padding-top:1rem\"><a href=\"#\">View map</a></h5>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:group {\"style\":{\"border\":{\"radius\":\"20px\"},\"spacing\":{\"padding\":{\"top\":\"3rem\",\"bottom\":\"3rem\",\"right\":\"3rem\",\"left\":\"3rem\"}}},\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-foreground-color has-background-background-color has-text-color has-background\" style=\"border-radius:20px;padding-top:3rem;padding-right:3rem;padding-bottom:3rem;padding-left:3rem\"><!-- wp:heading {\"level\":3,\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-medium-font-size\">Date &amp; Time</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:separator {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"3rem\"}},\"color\":{\"background\":\"#ffffff1f\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-bottom:3rem;background-color:#ffffff1f;color:#ffffff1f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"padding-bottom:1rem\">Date: August 20-22, 2023<br>Location: Harmony Hall, New Orleans</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>Hosted at the iconic Harmony Hall in the heart of New Orleans, Jazz Connect promises to be a celebration of music, culture, and community. Don't miss out on this unforgettable experience!</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"},\"style\":{\"spacing\":{\"margin\":{\"top\":\"3rem\"}}}} -->\r\n<div class=\"wp-block-buttons\" style=\"margin-top:3rem\"><!-- wp:button {\"fontSize\":\"small\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-small-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy Ticket</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:spacer {\"height\":\"8vw\"} -->\r\n<div style=\"height:8vw\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/event-listing-7',
		array(
			'title'       => __( 'Two large event columns with image backgrounds', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-event-listing' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--60)\"><!-- wp:heading {\"level\":3,\"align\":\"wide\",\"fontSize\":\"hugee\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-hugee-font-size\">Upcoming Festivals</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-bottom:var(--wp--preset--spacing--50)\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"60%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:paragraph -->\r\n<p>This annual event brings together top musicians from around the world to perform in front of a passionate crowd of music lovers.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-fill\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-fill has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">VIEW ALL Festivals</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:columns {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"},\"blockGap\":{\"top\":\"0\",\"left\":\"0\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignfull stack-on-tablet-portrait\" style=\"padding-right:0;padding-left:0\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/08/rock1.jpg\",\"id\":1418,\"dimRatio\":20,\"minHeight\":50,\"minHeightUnit\":\"vw\",\"contentPosition\":\"top left\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\",\"left\":\"var:preset|spacing|60\",\"right\":\"var:preset|spacing|60\"}}}} -->\r\n<div class=\"wp-block-cover has-custom-content-position is-position-top-left\" style=\"padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60);min-height:50vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-20 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-1418\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/08/rock1.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"48vh\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:48vh\"><!-- wp:paragraph {\"align\":\"left\",\"placeholder\":\"Write title\u2026\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"textTransform\":\"uppercase\"},\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|10\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-text-align-left has-tiny-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--10);font-style:normal;font-weight:600;text-transform:uppercase\"><span data-metadata=\"<!--(figmeta)eyJmaWxlS2V5IjoidTI2UHl0b2NFckRSdmJYYkVKdmJWUSIsInBhc3RlSUQiOjE1OTA0MDMyMCwiZGF0YVR5cGUiOiJzY2VuZSJ9Cg==(/figmeta)-->\"></span><span data-buffer=\"<!--(figma)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(/figma)-->\"></span>SEPTEMBER 15, 2023 \u2013 SET TIME: 9:30 PM</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\"}}},\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\" style=\"margin-top:0\">Ember Stone</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"85%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:var(--wp--preset--spacing--40);flex-basis:85%\"><!-- wp:paragraph -->\r\n<p>Dynamic vocals and commanding stage presence, E.S. is a force to be reckoned with. Powerful voice can captivate audiences and his emotionally charged performances leave a lasting impact.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"className\":\"is-style-button-impact is-style-fill\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-button-impact is-style-fill has-tiny-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">BUY TICKETS</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/08/rock2.jpg\",\"id\":1419,\"dimRatio\":20,\"minHeight\":50,\"minHeightUnit\":\"vw\",\"contentPosition\":\"top left\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\",\"left\":\"var:preset|spacing|60\",\"right\":\"var:preset|spacing|60\"}}}} -->\r\n<div class=\"wp-block-cover has-custom-content-position is-position-top-left\" style=\"padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--60);min-height:50vw\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-20 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-1419\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/08/rock2.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"48vh\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:48vh\"><!-- wp:paragraph {\"align\":\"left\",\"placeholder\":\"Write title\u2026\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|10\"}},\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-text-align-left has-tiny-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--10);font-style:normal;font-weight:600;text-transform:none\"><span data-metadata=\"<!--(figmeta)eyJmaWxlS2V5IjoidTI2UHl0b2NFckRSdmJYYkVKdmJWUSIsInBhc3RlSUQiOjE1OTA0MDMyMCwiZGF0YVR5cGUiOiJzY2VuZSJ9Cg==(/figmeta)-->\"></span><span data-buffer=\"<!--(figma)ZmlnLWtpd2keAAAAuzoAALWdeZhsSVXgI25m1vLqLb3vNIvsm73T7ORyqzLfy63zZlZ1t9hJVuWtV8nLykzyZr3Xr90QERERERERERERERERERERERERERERERER0WEch3Ecx2EYR+d3IuLevFnvNTP/TH9fvzhx4sSJiBMnTpw4EXnr33UtjKLe6bB9fhIqddnJRqXeDdr5VlvxX71R8rvFcr6+4QdkdSfwW6m8Z6j9egk4E1Q26vkqUDZo31P1AXIG6Aa+8FoytIZzNzhVaXZbfrWRl5rL9Ua7sn5PNyg3OtVSt9PcaOVLUn/Fgd1Soy751Tjf8tdbflAGdSQo+nW/C7pZ7t7V8Vv3gFxLI1t+syrIo6XK+jrpsWK14tfb3UKL1ov5QPp2PNW3k41Oi3H40rMTQbvl52u2hPwlLm9HfGn+/kGEEO4GVtKEzu/sIExQUJW6jbppWJnMVqvSljHo+rgfNvd6UQhZkaK2aQmiWmPTgHprMOoPRqdbB0OhqTfq9/qtBgWqUTLlwsHO1sMp9EGpUqPYqTEqQF3M1zfzAZC30Wp0mgCZ9Va+JnTZQqNR9fP1bqPpt/LtSqMOMrfpF9uNFtCSjJN0uVoxbFf8arXSDARcbUHEtJt5PdLyNzrVfKvbbFTv2TBM1miqXvJLiHtOd7Tt3y1dOhZUK0VBHA/uqRUaoiMnKnUaqxssUq0UT4moLg3K+abf3aq0y11X97Jio16Hp+ng5UXRx0K1UTxF7oqtSmnD6NaV8KrJSK+q+aVKHuDqcmWjXOV/Kb4mgIEd7LUO7CLsVjUvjV63lQ/KlW6blsldv5lvVfIF0/8b2g54iAG6ReRB7saYxGn2Qxme0deHBXu9Sbg1mO21w/tndopuDO7q5Fs+pYraTpqaTtYaRom8NrxEXug92UySLTW2pMPZiwk218y38tUqCwgdr3VbbpxLi+iqvy7YZb++0S3lGULeNL4ieZZKRzKrklmvGK5HDNyolnyR9Vqb5ePf26hIL482W37JX0ctSt1mq1H0A1GwY8jNr0r58VgBu0HF9fFEgqp1qu1K0yAvqeXrnXy1W6k3O9K3S8v+3XmrQZcVy/5my4CXN6nm0Fc0GLYFZZalZ1c1qx1p/up8q9XYiod5jc3Fsrg26NRq9KV7slM3Mw7uOqNE1wdN3y+Wu4VOgTkEcUOl3vZlzbPOG638huAeUhiGo36NlSbdyQdBt11mJjbE5mAVWzVj6XQp3zrlC2vPDVIUKiPLh9VRwJCQzRYb1UaSyxmlNHWWAta/gcyCo0apgUKTX7FV4uzqXFmPBI31dtfwILdWzrdKSc5YOL/l21V1zL+7iJzsyI+XzWyfCPLtTrLwLzGtAFxa7SCqRlBpSxOXNXuDkdPelaCBboNUaFSpwrTQmnQVjE5Qkhp5YHEABYWmioUAl0lwEDmlz1ZqVsw5rN7JCsDSJktIjNxyZZ/NKNjpDUMrfXaTlt8uGsGvV2ScGn01rbWt3mb83d1wx/U4W8FctNhL8iwgClWp1WjOs3q9gfFiJusl7EhHOugV8sVTi6iMrN+isdFLDTSqgnKAVp0mdpNUVxtbBqALbduHAI2odov5pmhmdp5jQbWKxq7nhGkp3BlPe7PBeESd2HrTMvOLXIE1w62c8ufa5lXDnmwH7elgn1xcB97dsu9mXtcP9rfDaWc0mEXwbeVlqKpZuduvBgCaXrMjCqVXHI+i2XQ+w8vMPHgl5WZIupaXDc2jH07smaDIfgiQXYdjqWtr5FzGUC8Fs+n4TJgfDk6PqJAwU5h5JhZANzptB3qWuNiboJHxeBiuUQ2d2EvPLmiRiwwiY7P+XZ1KlU0TQwcy63RKTJjdsnOID+XDgCaopfResDy39t2bya+k8reQX03lbyV/JJW/jfxaKn87+aOp/B3kjxUrrWK69eN2tCfHA5FMDS+gBVYV/E1fRqDjgXuF8XgY9kaNSRgrSLZTtysVMVJNti5gHXQK2GYDe3ebBWz01Qi/PJ4OHhiPZr0h1Z1lTM0tumyk4J3ssOmuV0wP57U3w+lswNITXKNJUapqodFuN2pAXm18EIXFg2k0niIftoU8to8CVWw1AlZapQWs/Xt8WXqoHjkPl9E01cwzFGxhERUnn8XSk+RIipUq0FJNLKpUWWaK8TaBVpL5M9nVTRb7eFobTKfSgWQVmVkn1QbAAmEZ2dHaosJeqRftWXviFdmFQam5gmtjc+x6yDbrG6DUyaYvqQ42JfGaJfEdM/79k/F0dngNZfBRMOlsfm6hqBiBh2La1zEiWbJetXd+fDDbmA76lknWLquUxOcd9Owqy8zrNHuzWTgdUQRVpWlWCDba2Gpt5vNgNm6F0eABWCciMt0xkkn6oRPIk2rt6cFox6mfV6oE4uYIT4XLy24KoIPZ+WEYhG7sTF0raDj72MY5JtFFtMvqCn46rka9KBtLpu3XmmywxkfPxmwQ5ixMJHnBfgOo490Cw9HbOWOnMRlTGQN9L9I1PdBslDiTBrbURq9p7gLpWpF6BZRMTAxwxlQojg/o0NTVW3qweojdTU4m32nLzpVNscoZVicPotlg9zzZB+XSzBf9LqbAHhUyNl/w21vWMUBK8AnsLBqDC5KzQlC51++2G1gZI6AFBErHJFdqTZxuclICjZVGcxwNZHLZT0C5jqt8AbF37PHEkG1NxTaz13BsyTdBK5fa4rSI3PRBHXM7PAYNyYglS7N2klfiqcMUWL9LjpnkdadlJq7AhkyaKVYbxmPN4md3Y6ebfK7TxJ/1u8bZ77Y69XbFHG+WWGWling3RgGWK3Rt2ku1fBzHn+VvuKv8Oq13pSpbE3lda3C8xTUF9ixsCzLUKosLBpy1BTgTQpazOeO5L0GFl2wcY060ZoQrJdxJ0lXKTvn3xNWOkN1s2CPRGrAdR9nM5dEkz4ojf6w97Y3spNkxXMeWykGg3WUPYHOV0UKmWKtM4qYPqNc5I5N65lzSXW81krNAJoWK94JsCmetfi6FScz+UrMTlC3OMVueY2JeK3OUZbU6RyScjshJ1+Icp7U5JuZ0dI6ynI7NEQmn47ajTBNEMbMTC8iY3yULWMvy0gVcwvUy05LDOqaXp3ExzyvSSMvyyjQq4XgVBqxS7EoZuavxDgk05OvYNbPoruEg0MBfnGOu9XsRa9TO+HFiE8VOoVKkQAnrOKNx2lNZT4yP9bmpIYsoKcoK3QImZ+su4Jas3U7yy0GzZY3+ygaWi001Qaw60gRxxEJmCbBarf6vLSLbW2Igjh5CljkEgT4W7EzHw2FpMLW2gk67VfQNTDwSNibY1sXQzGS9h33M1Cyk3L+7yW5nrWYRDuI2mZze6LDPaC8iXkNjwMtKD8f4Pgb0iuMhzoXOTtWq0qf5x9vmn0yPf7LW/6Dy/eT0ef7xWqCgniPO8U9mj3+yhlMwG0+osCOwep7SE2eHIfBqvdl0cL/SS/s33URe7990M4m3f9MtJJn9mwWZ3b9ZkLn9mwW51OxNsbmVUT+knnf6YNBX96WYrinPHggoPNsbHoTU0QfmcHCD8taRUr23Hyqd2e3tD4bnodeR7MYAHkxm0c50MJmRywjtZm866FHlYD+cDnbWB6cPpoiW/dcdghVqx3wCaGIHJuQHbJpZrBpMejso9UJdggm4BGLETF4TpXDnxoswWJfJlQGmOWAqCQ8YGI8JdTbzm65d7E0ilHlehfVnDpCapBtnvKbPYU66ngHRTXLihBMmFDAHisFuAC6l+Ddjuae7hZPOv/jq+EcApj+BETKTk1BV0Gmz1DRuvzHw62FvZgT8t7rJGY8iVbylaUhcL7xiMxB8RnpDajpImnNhwiVCMOKsLjdapTrpSn69JeWrpboxRkfqnZp0aQ2XWkJlR9kRZUjHSjY9Lr426QmOpJJeks8b9/7Sok0v43wj6eWBzV/R2jSRjStlYZJeFWyZ0OzVxWBL0muYHMFfWyyaGN11gfWbri9XTPD1BuehPKTRqkv/bhShkD6U/U2m8mGltjnFPny9mpdxPKK20ZIN/JsCdI30kZwXpP1HrePekj66bNPHlG27j23b/OPusunjmzZ9gpyBSJ9YXS9I/kmNpkmf3Gqb9Jubtv5NzVN1kdPNVcwH6S2k0s9bW+2q5G8jlfzt+UJrk/SOfGFT8k8hlX7fuWn5PHWTDpE+rVDdkvl5OqnQPYNU6J6ZP1WWcTyreNKc7Z5dXDcL4TnFpsnni52W0BXY6iVfxLhJWlq3/H3Cc9KfddJbSDdIbyUt06y0VyEV/ifLdjy0tiH9qZYbJ0Vv8FGNB1Kv4EiQNk42n3InafNk807hc9fJ5lNvIm2dbN50G2lQPVmTem3CsULfYVeTedkU94V0i1T6cXftVE3w99SrxvG6t9451Sb9FjYA6ddzSQPSb91E4KT3NYO24Lukgn9e61RL8r1WsyzpdqtTkHnfCXBxSftt24+wXTenj12mSebv9CbBLtK9TVs+2LTjfv7mKaMvZzZb7RbpkPQW0v0gwPIqNSKV/Jj0VtIJ6W2kLyC9nXRKegdpRPoU0hmpyOmA9KmkZ4MAm63UOVLhdz+p8DtPKvweIBV+30Yq/L6dVPh9B6nw+05S4fddpMLvhToIbhGG362Lm6aHLxJAWH6PAMLzxQII0+8VQLi+RABh+30CCN+XCiCMv18A4fwyANPVHxBAOL9cAOH8gwII51cIIJx/SADh/EoBhPMPCyCcXyWAcP4RAYTzqwFMn39UAOH8GgGE848JIJxfK4Bw/nEBhPPrBBDOPyGAcH69AML5JwUQzm8AuFU4/5QAwvmNAgjnnxZAOL9JAOH8MwII5zcLIJx/VgDh/BYBhPPPCSCc3wpwm3D+eQGE89sEEM6/IIBwfrsAwvkXBRDO7xBAOP+SAML5nQII518WQDi/C+B24fwrAgjndwsgnH9VAOH8HgGE868JIJzfK4Bw/nUBhPP7BBDOvyGAcH4/wB3C+TcFEM4fEEA4/5YAwvmDAgjn3xZAOH9IAOH8OwII5w8LIJx/VwDh/BGApwjn3xNAOH9UAOH8+wII548JIJz/QADh/HEBhPMfCiCcPyGAcP4jAYTzJwHuFM5/LIBw/pQAwvlPBBDOnxZAOP+pAML5MwII5z8TQDh/VgDh/OcCCOfPARgT9RcCCOfPCyCc/1IA4fwFAYTzXwkgnL8ogHD+awGE85cEEM5/I4Bw/rI+HPnBtZqxXavblI5dLE98ylpvMhEnR3u70/G+uGWzMf96heF4W2m9fX4WRiqjbchJeRluAvckPxKPDP+r35v1DO2yymwO+uFYeV5ME93amQ6FaH0w5GRbFG8y338+UQalV2bSKfy8aK/XH5+LAL29wek9zuh7+H14kv1w1hsMgbIhY4nEycCjPMsZPiSWBLw0C/dN8NEWLZ8dbHP23BF4xdwJ2GbdfbHyjvz/bXIHj2naY2yranV7KjxHtEzuiOmM8q4yE3CJ0jsiCPU85Y3Fw5yJA545O4gG23hbWmVJ3FXOcZWL8MQjtauX4D2KdsfTfbWnlgdmNl6s1YqB2nu4zyPpOqjV3ggkh4qKFAnmEovB5cMjZdqW1aXk07cWl6kjFrM3Phj2i9K/Wm8Egv5cNR1zOqEy3VyLpArA0V0jW0PppvSlWh2byEjXTRHWWh0P98fPHxRpoUk4GRkv6xNnjZK8RKvLCP2eHow4wUjLW4P+jIGpyxew5VDkCPqKHWkJB1Z9KaOuFOe0xlyVUD7l5c6E59VI6V2w1cEorsTsCqY0OB3SuwynB3LWpX1AZSWzZQlz3A2Qg/nAjtPL9Lgpb/dO07AWsC5SQ4/jlWMi0Lbxy3f2euLmh9MICp3kTEOVkgzZiwRunA2nBELDdo/5Va/0dGZooqMmWLbNrHN9M6T3ERuNzp0enp/sRewweqmfXMFE7C96eZtj35kXHIxlYb5B60ssm006AAk9XtllMIl0XqH16m5vONwmDrZOQaRG+sgeijilsTOF8f1webXWa+SA/sHTR2dJSJVT6dSd2nLqmMOH/US+x4fj0xJ+NyTtcTEee2N3NwpnWBa1qk/sD+KYW1Lv0n1y8Letv0bry/ocl86G/arpxFc9fXk51UPlZbeJ4PUj1edYaC2KO0Nm9mI6XOQc0a6EMWoxrxTNB8JZmdUVw5lBtNkbwoplt2/rnkKZllWu4KZDeStYAntewiCeM2qKaknZPQAZAZKRZSWXj3ZgRW4ZwzGehtXUhRh2YncwjWaJrKQtOpTOL23I5CtveWe8v99jCAVrX+cH5m1ldYpBM4ZdxGu0iPYvZN7rn3UWaunC1bhcSpQLuz0lKoC8MNwJc9kHnLaxLM66+5YC6xCZGXStN2WSnKTT3bJhB6OEUlMy9XB2bgy5Gw/C2Uf6DxD/4J9kVBeuFNmouEFAJlomPlL3aR2c398eDx37yGRol/3LwjGTSBh4BBPEdAb0PVxHNJhfpi5mi6aaPdDz0AQ4TMDhlHHwRVYb4UgMPhJybY3TnPVBFK4z5xuyyTKO8yMTMtBsjIPd3cZoeL6F1M/2hoY6U7J6XtnfP5jJ6Iw9tny9Rb5k3Hr28hGrqRXuQnMG5cTKxIUshADbTOvjg0kF8cfrQvfiOm/XQoNUKw9ebARWedByYxjpLOL9v1AE4ezBiQK0UiQkjYELCQmhlt7q7mAYnrLjikwhLHBA3BjLPXwJIjvCssm8uLmKcIh1NvZOcsMB+/D0vExoexwcbEtEaBsyQagXYkRZSpPxiGVpW1o+GO0O5UpKbhbSLFcGUScuClFxtWq7XYzr13oRC8tOWWYnxlquenKwPRxEezCThqW77XE77O1X592TRrzDjWQquGmyShuMWnQgmMmw57omrBq7wTl6ivY4YlFRfImFLixq0cX5bt7y/8SZhd8bBqkZiatY1vYRA+bReDVXSE/YoY1XY8w/yzkzxfAdiAuUnbs3OZLEvVmKJtOw14diOdobn0PWOGaFEAn2Ze1BvtIWv8eYvcpoV7xL096m0v0Duyyp7DXxUcZSUArPDnbiq9E4HisHdnN9q4uEUExQyTM4QrQSyiPPypSKrdjVYe27ysXiVtc46fpQI2xLkuEsguI6+8VoGHqlz3wMdgcYYDSXWpbnR9hkGsiQDbvpLHlbGKiV5J5NEZWPQ/ha4KTEk1wcyM8QR2YcMWXWZRPinEPE9NxS1zsmWLHsOlDAHTiN1ZCtEH3GJNIbWklGLVdZRMXt9ZNcELjHEPoCBnYMSU2CMZVSN36qcyF5HkVjexIt87ztBG24fAJRzlHFWKHqPVxwI0NDpXL1/CaxQBPuVNxRuLdGOtgyAUhP0i6xVUOQcZcV5rIv6+PXy7EIzkynmB4o4pdfEKigtWECoQStmrDtNm/tbt4GwrM1Aw4CLO+I00R0sLtLHJxlPxBX1XSNlbWDnzaT3WCmvlNlorOnxVYYB5LpJ8uRSzT7s6wEco2DmbgM4k9SjpliNtiaZeMgvwzF+ni6w7qVNxnYnjMR6BU2nfx2NB4ezEK39WKodtKD+rRWR1yPNzdck8qrrHfrvu/uF/LVrfw9AYCuGg9SrukxxzMZxx3Ybvxe5WGHk5WbGR3sB6x55iFSOFtunXNCiiw2kFWAn3H6AMs2dTm8GPrFNK5MxOBNR+pOtbqBNWf+jZ9NIzphFW8dmSZ2CYJzWALkbd6WrihszIJHZP0FrBPuRiBgWzovoXOri/KohYQ4e6txSjCee6WZ8dfX7euULFHJRkugnHuOsIQVwuIbfql9yrZlrWy8AbvNKd7ahIA5YpAy5/Q+EoyrEjEX8bIn78k02SJ3G4TZQ88RFQijsjI3DIFL9O5W2WcplivVUrex3rXFBPa5XrQPZRkhy/QeVyIVvfx0J+kF3i9CzI9OI0XOv9jfVNYbcN09bcWmOmNNfhWfmroH0wE91P1BNBn2zhs1XhPfxmSN1tL/5vCAI5trbWIySJJq+D2cl6hwxg60acpa4bDHUWLPVshODNJW2OfEzFoCZB2ZqQbESS+Fw5CTB0qYrR0MZwNpPZyuD8Jhf9NOBRO0w1JA9iiDTl+TcTfGAMXnq/XkIJ/SD/cEQCwtiefMacZaT6BsbEBziWldSrj5o/5E/GjGHDpQ9izaxPOZxDO9zc2YbfafWEFJZQCW9LApteh6itwuPKpBYmlFzAGQlHP9VimVuNnkuhYLZxSXSHiMsnfw8QsGW7U2sJ2jmQikcPkadna+5BJq5hxLg8rSjF8tNLasoWD15J0ctPNkauOzoduOx8P+KTO7uM2o/nqi1l6KtjwgjjE9XyF8QpVofIBNM8Lqi7BsvnjIk2GXDYdjjneiL0w+vTuDuoxsNdrbnTc1pMwppxzIznTMKTG7NeifDll1jB698DhwmLo06fcHHAhlANnZAK2b9fYnlWh85x0ErGGNgZ1CKJwZlBCH/bzEITI7+CtxJisFCNkYHa/kyy8KEJLaKnMVV2jkWyI+jUU4Y0ky+WqzLCF9uRVn/fpA2rxldS/LvYB5YIICPAYWIzufU9RCh6VPqhcI7AB0ZDLq5Z4yT+05/Y1YQt6XY1tqzkw2mnH7ZK8XhWpJeQawyDsmWK/4evb5KpPKWoKnzKT7R5TxdyzqzpGVdk5Si3rqIGpa/1eOAizVd2h8RRzxifQY2g94w7lGmL7/m1YvTCOdmoDUP+5sxm9Zu8uqWlY3O9C2Fw6iYLw7c6YhkCIafacmXDMedSZ9psl15JfBrQ+Gw5jmJ8nbHTXG/DRCBGozPvVFTRzeZEsL3f+t2OoD/4JmlBcx+V/WHHVSRfP940uaGPyhPeCD3vj5OLfBAUrOxE5DY0CMVRNOf856PVsbj0fDAXGt4fm4hc9jsfc4SEqgzY4J6dxHLMihU0MzBW+KC8QazNE/F6Odn5AUvDUpMC7+vODn4wJxFebot8XoVH/wWmw3KP91HRlkH6SQMEfq425aBWcJ45I/TJVIhwX3iRTOdkqwf5TCSo8E98mUS9nsse5ZF1r/tr5oDwsJKb38kFEKlGYDzERp9dd0O87iVjFHs/ObsqE1pn0UQf2dp78az7XZMueT/V6tHoCbwS6uiW8DSiqkD57fni7YhL9Vke+06MQ2pnTtfZpIYWToFxX1lfogPl3CPd3Im4mRYmk7D1L85fgAi5hkcX8mzptp/jPxvmwvTpml+VkkVryFQf15TBcmu/Ealxs2kltcrPSvcy4i1FK4G6mPevpl7N4pNKKM1Ic8/QOeG6AM+M1avWCetUZApkIiKkGCl8Ppd2BL5KjKOcwWmAH80GLTeVyE0yOJ+kXqI55+OYc3Qu35aVg42GayxNn45eTMG8jBmesr/TW9gOIs/QGtv25MrHFZ36TVOM7YLk7iClXZ0FRO/baJSzv3+MoYtsQVjG/v9LQ32RP7y6a9qq46hLKEJxNs/ExlVV19GGdJT81YRnluOdKvrR+rHnYRtK3QTko2UXoJ+KnHq4dfgLTEHcEX2UzUVeoRMWyLNiWbijBeo75pEWPJttix4xAqHZvnbPFzRUJ1thli/I+LYVv0rYadTPqrtHp8nLFl9wmpCUyNOO/t749HVTlEHnBCZ2a/a6EU9+D+2UEPp3dO8ULWSkJSGrDAQukyO1Wa6rvTVHb7EtGkSV6UJsF2yOUG6O9JowPcDFbPveF0TNGL00V195bIvmOacGN+YaGbbjXlXuXCUoKMxmlQMy7XU8VFeWd0lnubFC7Zne7n2p2NFWMTMx9yGW0okyX+MSh6jMeGtq9jwYrrQb6Je488DSOt/jhGV5EP+T/BI76/yizLKfKv2ORM71hOzov54iLKeAqv8NTfeDJLHTyzqjmvxv1Y5jp3Nj7NYabfGDXa6/hnSCpS367/MMETik0XfEIn9wbqpRmuVsUKCK+XZdSnzeo04hAUwS6tX2yaLgz6g3mjP2ZwbXspIqhnqNcy0Kjc67fa1TZlDPXNqePzkgOtej6N8NoZY2SWLWTRT59fCa440BY8g5pJ2Gw1ydjCZ0YYEM4Ma5Ja1LOJQST3hdzpuIwtfE4fdcNCMbsj7miOpbKWIL+P00rfLpHUokoCVqKGDVhQdtkCwhKtC854US/z1G+m9uKGHQvDuvwCpK26gVFIn0O58ZvnLUk5Mp6Cu7ZbVdel85akblHGTqmHqYekspbgLotB99Uj1I1Jxha2bN789uWR6qHznC0OdnEf5l7Fo+dZW36vrWBRQvGYNMLSfEto/JdIfVDrJzjYlnTngim6kMkth1CWcFfa3QjH++EMX/kLWt+aRlia07blGClUty2iLN2e3PmwOlHL8aQa7mIM51JHxD+s0wQtEfQhilfNKQrj2Wy8fxEuP3KY5mKMXj0nmpcMZM+boOwsUHTuRw/TtMds7pTOSV6jZR/HoWVNRph2Ro34zUr7MTnX5bcPBc5e5G2PxY1gfGXjMoD7KYezvU3Qb3RoGWKC/GmHNGNKsG9yWCYXXxxFlyXzFoekKau0DPvnHM42laDf6tDSVIL8eYc0TSXYtzlsYObXorGaaaH8grfHxmT3+EQmM3WjuuFieKsazUh+OyFGRhUUlttlbOHzTV7GhV2nD2fSeUsyNKhmry87BCT76bwloUFQRWYC02MWqVpX9xvkyQP7W5SyOm/ytrSkPqlNtpx02zGkgT+2RZho457MCz5lC4gG4KCdVH9is9bHIP9pm2+yibG7B4MHpNZJ9bcLaNN+hfhFRJf+zhalO26LSuo/uKK9wbDvqm5Mx/K8+iu2xHXLTCHY/7iAtUoA+u8t2rAx/INwuItw/sHi422aKqqqfpCDEMgW/uU0Cu+Vqb+fSf8hizY/jqmr37E512c3U7T0YY8begYdqn/IqN+VrTnOfGShhukFOsKxYaaa6s+4xApG6PZGb5+11JvKAvushwK52xo5yhq3+wdkQdqLk0AikUnBy+cFBdo5PbdzmL4f1HNWxgP4kFY/nsK1qcUt0OtSqNL8QugndNhLfpBwt3p9iqqJCxBOz4aBCbrS6V/lWGACYBQa+pZ6Twolv/FZU7827ytxKbn9+ajmmMdiiS9P2hSptvqNVFNtIkvjA5nl96cpaz0y/G9s0m9qMnFJagQfkOAJUVuTZ5dlaoc9uRP4YKqBwDzXCVCyWd488REj80fzrlbmrCP1NU9/aV5kpgIJmeCYelFG/U9tA7HiQaNm+uMuL9E3fBwbrf2q1n8Ry0YO7vBQ/6wJbSY4n8M0mP82x1QZqTlzc/ajKMGb2my97MP/fY6lvsX9yxxXROuYLNPViAL9v+dl4mglEc6va/XvmhPzoY8aHFX/1WI7zLxb9qvqfyBhc3a8yG382zSxqQct3mSZIVL1j1p9yhuhzofeCLxVU7QDnmuKnTNVtqsDCWp/0VPf4w3xOVHBs4PwnKF9ZUa9xjOdc64kDqpWr4td4CJDZ8FFyb7yE3iU/XDcRBm2WTTqVZ56u6zT/Ylh94qM+kXvnAl7ylsEDsb40CH81A+n0EX7Y9hlaltkyQ6Vm/PZNIx/K/taT/2IKy/2djie5GEYIXP1Yk+92pVURpODWXJ18RlP/aQrkJ2ZQD1r5w0OUx6fxfAYTXiNp34GA7Jl8AHm+owImOH9rKOthbNeXwb0WU+9xOH8syIJHHT9fQ7TZKfH2p+vhaMDa4C/4Onv98xstcbnYisZsZuqd1s09uVgf7RQ8qu2hApWNyIkqt5jkZZ8S3YOg/41Ym+sKY5w/uhgf130jzPNlzz1v+w6pqBEt+OCL3vqu4lsYEAR9hED2J3vWT3ze9cRGsWoj89ztrggc2sNoj+SfoipOHEB0hIXQxPAi1WlYe8OL70Qa8n9iIVXYflMzXMYVsI1ixhLVt0fMJ7qgASSa0lczhbXZrK6MC5nMCIQXJ/OW5LGNiqw8AvxR6tHHsZZ0rvRDLQg7YTgnDzqQqwlv4cDZZ/Aq/lJNe2pJ6snHkJZwudZIQQcZMFFRLT0kxZRlo41QnDDTEIku9/T1JMXMZZsm1WHQZdgY0SAS39zKm8pduxDJ9EB9UatbppnbXl/V4xIjVMSIQUzh0qr6AKkJWYtmrbH68yBVnJ4jbOW4KwdSwGpW72I60N9TqJQGJPPa/0yjeSMbooWUPYKHZndb/7jtXvVT2GxxKMO9sfj2R6iYVLf6Og4P0fcFW2rt2jbYluEE3G1LAAMf8kRMlHM046JxyNT9Vz1LtgmOHoPk1/h5uZ+Ypri20zDUWkgFk2eSrzbcUnMyd9popw9d5H5Fa1+J7bJNqon6KqZgU1nkXPqw3pEXaIvZI3x/5RWv2tidsNDzy4+ptVH4gLZ5GYwjgno5e/FZXPpVkSKjEQIPq7xAC6gyM8fN3xSq983BCiHuaa6T/2pkUWP/XBKzF/k6K4lxG/Ps/GZCRD7/3nr5hXhSZPITebjpPrLOQO5NRAOD8LgC/pMeJ6wzOnTSPYlGS41zo7xWnwxoc29KSE65P03WnoqFp3D/14h3B1P8W6I+sgA79P/yUWXq2xZER6p/s96xnRLFEckr77iqf/ChNDRvQaxZ9YpHWWXHGMXCWkB05HvZceLZnN386VeuL8d9g2Dl2eI6xCg2quF/YF9rvqpDPFblIJ5llmme06T2MF+1IsG+5Mhp4L4nVKzNwqHMtzXe70dRmLiK+V2rSrL46sZ9Q5PwjgtLI76x4z6pRRRtbdNLHZNvdM7KyRgTPNfyqh3JZgiVudgn5GJyzZhG1O/kpTJSahwPmCjouTNnnp/UiI4CiP15Yx+bxqLz/serX49QbVCDqLoslHGz2TU+5IS6Yq5aeCSIaN+I8G3meVRHVNBx7+QYIOd8QTKv8/ov/ZwM0b9XqzF0rd3eur3HDreUwX9Ho+o+/6AYLEQBoiYM/g/ZdTvsyunbtUQ7cc8JodtHhf8JZ76A3YzHHQ23l25I/haRv2pZ1WAiTLaUumz5nEEdmR5t2x8cG5n/jWjPsf8Gqw9p6ypv/D64x1ClUQk07y/nlF/CW9i5owvfQkccWTXX/KiIQsrD9uzYXsv3A+rg+1TLLM1Nt1NSuYukpfpYccnZBmO3mc4vepYft/K1TyBABlkpiZYYUYf1aq8/OG2VTXznUDuX3W7sSHf6BB8N0Z6NfsJgkyn7qCsI5NsN8HmzNfj1hutLXshvGTyhXzxlEMsG4R5ibCCp4Ffk/KUvCWEwVl2wB7OiUljGGSxzxHpHxH0puYazRaicowsCy5IVbHY3CBq2Go2v2TbLTnruuAGeviiLBpOIXIHiwUyNgnQSz3FEJ3yNFM4HaCLr/e0Xiz0KTkPqzNmhuYPQzadEpecXs55vBEeh0p9imCSEZfb3pLSn7MpGlm/ybqwFG/yVGZzAaNuqFWCoGJ+FquKjZZ8fqmVL1U6AXktnyTbaMmH+OS7EJbKmyMr9ZJvHoplAvOmqLsVf44kG7SZ0lStnEU08yX5Ekn8Vk++WZfC2pcny4vI+NXJyiI6eZayulkJKoWqKNcRedBkvpZGZm2Lu3H5qerR5CMpx5LPsElTphPdw2M+vkhjWr+A6MScyPbj4rwuuYDs4uwuLTRaJRDSYCLCyxzS1Uzwlzu8aTHBXuGwtoEEfaX58Ea93ZWfavutdsWX9q6yoiw2OvKOJzVLV9cq9W4st2tq+buTzLVSkgjyOilKctfHKiWmPtkH5sr7lpTypkl8ytHgREfBsqrYFhI1FmpQ9ymvLVkOJRhFjiBpmz5v522086B0PkTS2KAPu/mLJFbdYhXZqSFPsX3HBWwdjQ/BnGUEErPj5c320nQNQJZi9S5YXVDuUzhnM3EF0jNLWuEsZ7ZFeQFjnp2q+COKjll6L5s39t6ksVS5T+G8MUGy1cYtxXTY2VHPbKx6Jg2/GwoORdjEejwhmRnhHI5JbITv91T27HhGfIXMBzyV2z+IBjsm90FPLVnW7YTc0zOBq+HoNAFIbJYl2Iw5eDhnM9wNDOu8tJawxACP2S1L0rmITs3acKtFkHpcbM4vtLk0V15uRH+toYNVP9ylHsr0wHh/exCuux8C1e1QMzvp6vWk4ocZXvrNXa54cTqVnRsilTZEWh7ltiolbGU3MJ/Q7NINZrNSL/utSrsrDzO7gXx6wRZkFlqY38wz9ngIrBDZMz7GxCwQl2TUK3ZyR3ZcnNFRqN5wM66RYR+bX22uqSwX5fPqFambM9P+cWYvPfLlyVQedeCLGl6R+oSnVhaaN3j2JDnXWpjFLG6yzbxK2yetNocSLVRuS5vyfNv8gN2IkETHj6cRF2arXvS78qIZxGLt5qG+oScsg9Fpl13TeuD8ZHne77Cf9LRXSaEXmcBjJn36lKfkAIGovgFxWyiZjUat2ajbXVHRX3wf+Tqh9Fdbt8KXUwcbov36kPuokDIvy0m1DLvrl1AL+3zRy7cx1mW/hIZAIh9RCrr2I75SzM7bwZRLS5003r32WwxIqYz7EpRqtzr1Yr7tA2rz8Uv3AM+z1eaGYOEFq4U3OVShOQblQk91q2qZLZOT6SBWkQSirGiW80X38wIV+OJDtM20zudXPjjnxJExyG7gV9lATanzJoFydFUk5by0dGNcC+BZj6dyAEO1PbxBA9D1GRqJBwbohpiuJ51k2Uwcyo0mXWcAhRnG51g/gx3DM2u5E1TwdC4yTXO5bnCUsnLa9r6dNbDMzeIuSFYL299CHFRd0r6n6QfFVsV8D0IVmzJB2n0mwSsGsmFnTuY38wlNVg51pLmTgZHnkvHG7hLUcvOedtkgVzbEhV4NDPpIsFUxDtfaqYa8tQQ62uoEgjlWyJsPfhzHnZdPeplFd6IiXi0hEj8V18OQ2WeXcWEJDYkLseokxhLmCTzIp8Ye9LUYEzNxSGRiTZmsUK+NpahyQBbGyssOAdEyuG0fDDFCZgL+HpM34KzEyV8kHT8jkoeuYf2A0/SUXLYwr6CyxjMyq0J16vOMTtxX9tVu1X6XI2P7MLIetLc6BDRs/hEjcJF22Y3kuW5ypusNOUaof/LUan8R9c8oziJKxIgl+Bf2l/743IjTpzyj4piDCc6pHEoWIYBwtHN+jl0SmSDb6cxFoXJqWZ5zTiPT6cZulXIUbqVkDy+Lo9GLHZA+aSk1A1Q5owHIQDkZxTLRidRijGcckLs6DWNBMmU/TzFQNriYNFT8kT1VNd/s0C3z6RvvMJlni5Ut1ovFTlqY4Jr9Nh4kyr87gec/SBLKODDl5Qayn2lmi8pfR3dsQaRemNGLT+kjJhavTn7nvQ+xs3IIOJdw9g0Xb3kwb6ENmosuVCNBLdxooatJQepCK8N+0p4HpPCfLohH5YgTogFSQVwc4nrUW9qXo3mZkCco8stJ3zady9w2fhpzzcDfze5bHI+IWMCkN8ybXsjW2HMQQuAI6wjMeTHhlzckyrtu3g3xdViPiHOOa0PKzaM3x6RHuXDvmJ3TSO/tgFKjvOj9nfwISO62KDdsWvITmhhjbyNXJD7A0doERVD6xLXZVqsXhj+PzBtkA+cKLHX5uWb7u87Vk5SrVX2U9TPtWQK34rbVsZmRcSxxI5Lji7hNsWnqsxl1wkyYE+arPXUJ7FzzLVqf2eBM3GMuKrCLo850WBnVw3OcOkBdtsha/aunLl9EmdXN7F1hGgvODCbtsYgY+V6ZoArn8/vGqV5VVyFCO+cR1fTVSXauI//m6WsOddVKIdXXaw8RVGJVPxsmrpnEI69LlCqg33LR0DQXlMQu3E5LhDD1ZHf+AxBcCrdKSlwS7oQYqVP+PfGPCbDmp+o4DBxk68QfqlVjg/TdhcbdXXwwYK8Z3EaSYftrF8tyCCaXPTVfeyYGI5typHIatTZY19aLWQ5lOm1fxnnegfkZhXncyoR7NUYnffSyJq/3bT7sy71qpQ+pl6AK5xNkZpdw3injTWZ9tisb/PWOOu7RdKdjIG82mDHZVJjF37OwBdlzcv/GLOb2zAUd0FIojNr0lfLlhL6yjy0r9yL5VdbKLiuBeU7jVifT8Vn0T24bjnBPdHqAAsiOQX4NkaSm5Cgz5y5VvcxBPBY5qTGbgYuICQqvG8LFEVeRH2stueX1Vg7MSHQ8RHEH4o5kFhvOXnQ0uYuMZmmRcstJ6bA4YpmtbNIduTNgAnd6o7O9SMLyoXsIhemecC0zdN1GiT2TL4Wi8Ca8aCttWG3I1uSzysLKhgmfqLQtN0yr452eGc+28lLogM2H1WK/0NA/zLE45CJYaTmpc3admBVD/eDQKjRX7tC726LESHltJhRlxiW15lFp8zNnINeC3hvPosl45rJexJnGwfGqSyrbecuNbc5RfSMGzKhd8pXYKIxHrizrqhUwkROOaLMKgUkt2yxGBOp+IDsxC26bjTDYIfYqZw2ac60TUc3gKya2J/ETWO/zwLJq+Ry7TWxat+U1H/5ak9rbnPjjHwUtj9lvTGNvyCg9Cs8lGe+CPpakjxmgeDRgGMsgKlvKyqgenjs0BAbVTzr3xgxngvj4OBOzLfdMwnW5MkcT+XCdy0WSM63ow83G3QsW+NC7KOaTQmfNr5vU2zIqJ4u7aDXUy0SL6ucU1k2Sec9bR7Vc3vjFQVzjUG2sZx9H4hvWX5R903RJZeSrdRXOoWbG8sQwLcihsFartG3GW6yK7TQ3xPRhYrgwMHnJcxrZy8tJDKf7CRuZTCBCJO4lP+tgeUYLktHDXjSLlcNyV29i8i9EB7DhTujtGcxxin0W9WTRJfwz24v6EqtshYODfGHFiwx9skgTqdhfaKGRFzYtPbpIR4OkR46p60Sk3olnu9BJYzuIuM2tEDceMbd1kaVlib4uUSmRF6HPjF6mjHiA/SUqARGmFWOLwDGM2Ly2zXub4sDOwwbiVYqTxsU2UbaKbAO6zGXwbDvszZhS1qkvcRET4lAFotFJTnfYOGhUOuTdENEyfUacGMGEKT31nO9A2I5rMvU8lqLYd+sS5sRoG+P+KlbdPv0M1aszajlRWi50V8bbNHSWcaplvdoP2VDCuuV5hDXLMjYWOFKvyeg1K+LY6kbqtRn5NNCijYzU6zL6GE1N6e2aOm7mLKYp2wXLSjixgG9exE5S/T5xFB1JzL4kksX0XTohN1caosoZfdlOapbenVGXn12Yj/fgG7I8t6bEMZDdlfKhr3XctIDZRom0uiplOmITFKk34xvOmGBnMt6SUddINkik+NaMujaZlLw5lARM1HW7XGFGjVEbYldXq+v3kvl/b0bdECBhAgS9yd5dB6EJSUfOORSrgQBwCicsUxaNIFyXkhF5envIBJqAg1tOKIhtrBVaOUJkdcJ6G9I7F4JeGUTNHjMliqRn4Fvhfo846ei0jSQzJXhC4E02MwOSSV1WWRoqiO+Wc1HoZY7kzGcLhUGe/QBsG2rGsj8xlZcjUB351glOWG0exmYJzrtABZk5iGhcKgCh2t+YM3tPMBtPcLZgkeyeboR6YeGgyZQVpuNefweexPcXincWxfZBbMqMpqbqQ9i7ScxYfYSD6iTW12YabUP+6sMsthqMGYryHipUsp7TTXmorQHMtaWbVPVKT2cRhVv1kXpfRufM9KoXab0kUKEXsUKsEb1R4uG9oVury72dHRpQWbUSSZgkSKKRq3G+LR15ljoS54tj+j2y6OeoNfNLbTqVU0cN6NSJc57Jrif++nHbcLN3foggQZyIFpRYLl3en9GXpIaW6OsHMurSXThturDCsrrMcK+gBWg9RvJ842AWDfqhP9oZYmc4hoplZmovN4RNhIodvU9dMYiKHJ1ZxUMM+rAz6o+DGWJVH8voqwyqFaZQV2/Hsx6pj2b0NdNwxy7YIHzBQciKd0GzZXWtaaeAX7WzZ+M463TYDv06U+ZzSiTeJ3J7qaeun4yJRZ0f7eSN2hDBUzckP33k1iI0jqF8nuoheEGz8/IWpmLvIqp0iRE8tDTY3S3uHcjxai0lNQyytnv7UvJ5hTrFKAr23rgZRhRZC7v5ztlcJTKmlImihaUd4R7lzU9LkGl7D+kJiiaWtznti/jRhfIA4zvd2TtPE3plciFu9WLE8fiOTC6OX5PxxerCnRpDiEcIS2vBRMUZo5NDpD7O7i3ZgrQnZNltgZqmhfoih9zkYtilVvyIyMyU8tyX6UtdEvOnOFT895p0QloSJfU4sQKX7YFKT+NCw+eTWIV0wMEg1Ypc1/j5OszUerWRb5PqoC3fiAfy8tWK+Wt2NqAPIF8YafmB+8tWuZq5jlhKX4stx420QvskaN7Y0jduLGnDcs2luS7FXPMjG4lmE3iQW6o15e0yYy6HD0n8sRdJMC1rfA2Lf57KhfdPppgedN+iPo/523d3S+qL4m64N0AW8y7Csn5SJQkyqUvlRUNyNeL+PJDNyt8Gkb8LYf9+ho1Vm+sa97fKShWZSaCsf1cnXxVJ5+oNro4kR2aJyyL542dGZMtJpsvdSkyystGSP2PYMgXkV9P5NOER+0HvNSPio7RCcswKv7IuvTlOrbr9+zAn6G+3xmV1t9ponDK3X5fMh46ehUkmkcPncHPn6Pz09IGET0yAKtG7WixdE7dhpuzlATRz3YSG7c/gI/UFApxxgegRLropkdCc7oMwivVpqtPuorZ9hr0vrhpwJcYio/ZA7I4eWYvDVr1wk5rQC5NNaYdga3If/5VDfbEEPqXi/ezDH02F+dkUzcLIzNs2mQi5Li42uDVCruae1ETA7F0GR6fFxyWeecIxf62R2TCrIytc5OZZaHLm0zkmS24pMH/I0eWWTQMus8KEN8zHg1btTRf3ylhWHDwncrZNLddT8uZQVeO4f77F3WVVqmn5O1hWub16fpMkk3cf08qW5aO/ufIt/LtUvpV/l8u38e9KWT70u1q+g3+PlOWcIP1fSy4djq43uIcQ6BgriRUTAB4XmhNlwV6CwSG5dOHO4jJzyXx5R/69oubXO6RXVuXL51eVBHd1qc2/15RE5a9dr2x0DI/rgIr5phvA9TV7X3IDy5DkIXLZf6Mvb5IeKmIyRulhQQ1BAzxcevUI7iqEzzfdxT+PLK1L7UflCwXp5qPdld9jWtLyY1sygMe5JwSPlz90Q/oE+ROapE9kfZE8KbB/OPPJp+w37zEeJDcFRkA3y2BuEcStMrjb3Afeby+Y77vfUSjJzDwlaJpVf6fpwlO3TPK0ZqXYtgN+etDotMzXWJ5Rqcl4nsnJTUb4rGq+YP4E2rPjvwb5nEKn3TZyydt7W6CC9N/dGaGw7XjySsBWhr5oVx6TA7ze6LQtrw0itdghM5PlGjTSLfmLZ9WS/Xbdyaq/Ye/HT4llbMmjVvW8WN3qNvp7W74p10PxV+1uLOTlrwsCFQkvNKs+007TIvOSWz+V+row8N0g190Eb6Cp8ok1y6fM0dVClcDPt8yfQziZvtI+Nlf3h7IndWr1RFe/qSQf+o+t/SNLFXkh1jB9eHRp/uG1x8SCeqLUxMICPslOwJOdOG+SFG2Sft7M9i69uAWrLK3ejsanv+f3lJb584l3ksSMnwosvE2vntaWZwUAz2qzwRaMbuWT6dTFsl88RVAd2JPPgrm/pJrhIlk0KkunO64nuRhO1VmKcWKSRLzLyeyvxPNs21yNKY5w100832LXzB/6Eeh40KzUk36doNckl5KgxEYZLxNtsq1e3m75vrQKfAXzXWhY/JUyAtKrRH4WdbV0kPQaSW2b15qexMK6jiaEHPB6YUt6g6SO1UNEauzJgIU8lxBCd6rakNmq1vKtuzqmRs2+0QBCz2pmPA1DXarkLXEzge6yimW7d9TeXgBdsmDCHja3RA93U/KIEivP4R7l15plbKu0+Nh134TSHof9sgv78Swfv2X+9MgTKvWAbtha3xyvtltFn83DAjJ3BLE9ezo2hsmxDxGegaUhxhpnn0lNEfezZXykz4n9zZZoGlps/mZjEGduIdOOM7eS6cSZ28hsxpnbyRhVlcwdZO6WjOnjPYnlv1f2EDt13zLfYZ4r69ctbbLfKtOY/CHg+9gX7R8g7tYOPf3mojzqF+WXOebbN+ZDUibSYH2LkC1bNvR/YUNPF/ng2crN11llI98VPAcrE0+sjfHqB5zjDx+7MkVxKpvunTcBfvvNRTX/5iIZXSKiIv7QInEGM5g3f57vIp9qJOcVL/ruXGWchVTmEWl7/kextAEEIyUgvP8DoRAAAI2YeXRVVZbG972ZCGRiNIy+MIk0IJN0wLyb2xZZqK0iQ1lWL4cHVqoLlgSXBERb5TDkBUQxpZSyENtHKSCKtK1CIwS4oEgBooiiAQFDRCxKQXA2ltq/fd7L8/7VXVke93e/PZ59hnt5juNKhuSZB997zMlfLAd+db9jGgpmDh1x3V3V02+tuGP0+FmTb5hccdWsydePk/bS4Ziz0ukoXaW7ZGY6Iq5kOlmjp986c1plVbVkO63miEiu5Kngz4oi2eqKOGIzSYlkulnXTfr3ysiQ/8u+vcJC5051dK1jT3W8sqq68o6qSbdFxlbddlfkV5OqZk2aIdny/4dZ4lBA3D1rYzkUkZ81o/L26sppkyvviAy5dEBk6OChwyIDIxMqqyMTp0yrHBUZOWrY4Mh118ga52f+Chk/F3acLxKJMIeeTr/5zc39nYvHT588vXq6TKicNuXy6bf9TpLP46dPm1Q1ME32d/7BXJm1VTf/NP/uew5mUe685iOfu7WzPp+cIZnzxYzLIblkSXZf/qMpVm9VEoG9T0ypOI47r258ZVjjoAkiNN+dX9flhrDGRWOuECfDXfDZidywJgNNMEqjLaj7261hTaZqiJbpLhj+1MawJguNBOJkuTWf5XYNa7JVU6HRarxZV4Y1OWg0WrZbU3fwjrCmFRofnxy3pum6lWFNbvY9Ij+K08qtGf7tS2FNa3xMb3Fy3Zr428fCmjYpTWs3/tmhjLAmT6Od0DzxDs/lhTX5qiFPGzfu/dQxrClIRctz47//tH9YU5jS4FPXUB7WFKU0+W58066JYU3blIYKml6cEta0S1VQ4MZbZ88Ia9pn3yvmTuszfLkJazqkfMSN33hmUVjTUfPYHRKPX54Iazqh0VXIcOPrr9oQ1lygGvYBeRo+3RvWFKfy4CM3vxPWdE75FLrxfo2nw5ouWnVf3Tvx8Y9/FdZ0xUf3juPWbrusdVjTDY3WVuTWHny4Q1jTnWhygdZW+/tnOoc1PVK1tXVrm8f1CGsuJJr2mmh1f+kX1kRS0fLd2t7HB4Y1JSmfPLd208TSsKZnSkMFV++7PKzplarAdWubqseENb3VhzOXycG+ZEJY0wcNPch1nOQVIunbQ1wusQEZHTZ/PG9ZycM3dus98sIl3x3bfOBkdSI3U7Je4N7jttB7LVNypJVIvlMwx+Ha6yt6Geix1wOuR1kPrR5PPYh65PRw6THSA6NHQw+Bbnfd2LqFdbPqttQNqFtNN5VuH90ouiV08XWZdUF16XSRdDm08dpibaa2TRukrdBJyxzHOM5cR+Y5Mt+RBY7UOBJ3pNaRhY4scmSVw3zF3esMkX1O5n5H3sTKlcdcJ9thfqrMlTYtN2Xyzl/cVDzGXvuLSrpcn5+8+7vM4Ybu7vaQC6WvQ4NUHR4Z+j9eX45cJI850k0KnM5zobrO7rB+TB8ZIDW8trLbLcoWR/wTnkjUy0iC8YzjnpjJEPIBYIYnwUGkgQj2AmqxqGcsgTDPo10K+SjECgi5G/A041rGeiV6AjZhIZ74u5TYHhVDQFkeleAjJaZGxf8aAhnJLk8SsbblIo9HJdFFiZ1RaexVLiaTOP2V6EewIVjc4EnjcAh/AZpSLFZaiYVWqsQnnkSGQCTccgkuZrQul0h3iMZ2aIvKrQyk3LXTBxAM4OcS/QhEIYS8A9EJ89eoUgvyN6LpDpGwkj4stkDkP7xkyeYW8l+AxTjyt4OQ0VjkYYFMzlKBg8U1BG/WPvwGly/IMBX5qRL34nKShweQxyGC5WgPQzyPyzsQZh9gL2QTcjtE8B3gZZqSUS7+agjTBrAMspBZxiEi7Uk5ldRI8VKEFBK0APlulMbo1O9nTShOBkD458mwsMymlthlFLYDEKkX/ykrSbvQAjE3IY1a9AcsxUWQZcSQdVGRZYxqxjklitgGvdEiJeaxHQfxEKMgBSbKw0hGHwgzGpDP+C3jB/WtAhzDrwb5lhKPAHZQsha0A8LfZIEEu5ANEOYdwDksjiDzCaqLrHvTSrK94ogjwubAnGIUcFC1AGQLSKsaomo9FmoEO8cCa7SYotIgrRpRjnXQzCoeYqIKZCXAhmwBaRUA64QuggZQ0NgFoEZpkFYB5EkXh2A9rguIoZP6BWwGWNVm5qzdALDMnvg7IUwTD3t5OM14H0LOYXESEinfpIiYbiYsEq3ZturS2JbExIh1gtCg1GWzIMnLlNOAP4B2Iw20dDUGsAyHLRD/W8INgghob2PfcklwLE1niASxfQ6OSqMlKfBZTrUIXoFQFz/BDIhhHobQoLTAZlF5E/2R7TYRNSiwxcwMg7SKYrAuZoaWAjTayawr+wWkVQDZpDvHONbVFTM7BYIPAcM9mBJr50qsPAUMhfKHze4USLkTKN0iGWUpAG009oQA+AOoTRpYN+44RSS5Ngys0YAQsIFSxvJmJp4+TfL/DGt6toAS2nZQAU0FsAs2WCDBTkppgDAHsNXXxPvI0xABD/5XWCDFZdkU6MJIA4oiCPM2REcqeBWiWAmC0lERsiCpj/mlAX8AnV8a6KzUGEBJ2y3QbSsyDCL4nEttcLnEhJD9IRpbsXS9sMi3mweLtmgZASORmSKCL5hFHvJDZhHLwXc/9X3P2AEhJ9FSp0/RwUseL4lkt7Rvz5HY1vYVtSkww2D0irAqvXUCLZK7QmPKlxDmCCCHcYK4PUgQfAIYQXCVv24h7oTAwl8IIUd5WMrDWygeh9BF0BJSpZD3mhZwLaa6cP7OFJCD5ApwMudhqCbBa9C8BJFgzv4azzZElkJEOtEEQw+RopVYUEjSAuR2ihftjs9siCVBGefsXQB/dr78fagX0S9LRXQAudksAPHPUsMlEJJNERcTjMi+vj6lEw9aCNL/idwKpAk3SH+/EpRrNrE/tP5nIYIvqWyFJ/4HyKVMVe8hswggPVtACfm2AwIqARBlqwUi+zzxdytxGOJNiEbGUQj/EzTcdVY2txDU62PRmEetPi4JfWdqjAsggno0uo/XWEnesSHAH0B7kgYj9MD651p0KwBPeVTJXvMViH5INF6WAmqTMsbtKob/GhPUDivgD8N5IdBYiErWRiXmpECkG0DLTHsB5E96+s0/87BGk66I6pcD4IwtEQeH7C0gYefzO6ZuwThPG8LSxkj8MeM++qj3AF+FEpxlJBhnIfR9A7Db1z+lxEeYH2d8AfEmhM+BNduoO4MNuAYiwT7z/0gqpJmSIrRQtTBtINRFAj4gzhNnNlvTNAFOlknAokgRW1M4tPpF4j9qJcR9FohMQMb4RDH9AA+UiclGDiaG7GHiSxgJxlElbgd0RPsHMo3xOF9lNGsM+cWH7cvDtYwCJW6COItZNfIQvn4cUI+/5q9X4mkLxKxHvg0hrwA+4RNF92MOMczrBOtCt/ZAXAoh+yHG8oCU6SkiiNM2LPxHIMwuNAnIrRBrIWQjLi/y8CzyfyCC/wTUQzxkJRYzLRBzM+RGCHMFMV6AoMGGLcw/WjjEpZBnucoEVo6W4afgQL2Ybsg/b4VwAa224cssB2zDtK5MTNY2NH8vY4W3wkbRqumNgHlbdal4ayqhx6C0PinXleGrwOZLJpYH+SVLYtzgcgDWAjLyzxPs0uBFVKaOeazziPkUYAe9eJ5xAEKvCzZp8tB/BhGgNd/zoNK+owCNvKOCLVx7bZXYgIavdm2fdIWQJyF6sOuWWEnQ2RYk26cvFanAtxME/QkKIEx/z75HVAY/eJRazCL/QH4FwpUnC6Pi2+iv8Q+cfhCsemKwEuMBpfiyWkgICgLwlUvQoUqcJu8ALL6h9IgSeiHyWlUZZKUIacbqJ+ZwmrTmO0AD4yzkbgg9gcFG5nEIuQoC1r5igg1Yzfdo6k2AdOMPROWJLJYjkUVn9DNVgSzD0YIbPb1pxEQgfBLLXqb3N+Q9UYgjgDfKmCryHMdOl0fPIR9qKinvLgtEJiLNKIhBgCvK+McZsogYcoq+3c7YwtipxB8B2WirOU8jSStXQEyDULmMChVQalLj/4wmHpWYLo+9D/VePY1vXwjTgU5eAvEvLKT+W9IQyGjPqRCJyzMWiNlMiy6F8PcTcBgWR3EZCCGfehK7CIuvIXSbiF5QrErAYkRaQWingm9YTCSFCbf4HoI8RK0KzHFqteBLcryOdHAyNC2WS6SAErV4w0aNdSDSy1jpu0fWe7qVxF+FRTcIswJf9qct3lZSY4GYmVjYTTeJGJ2xmADRXokKCLaliRJLd5B+j+imsfI4FSqg1KRGqhmXoZkIYS/CSxlXQvSAMON5aMXDLUj94pFpgPfp9X3IPUosBNRDPGwlO+JJCyRYi7Q348uAU6zkFuLkElR2AiKMXSgqILRTMpVyVT7kSY3+joFG/13A+6rWAop53ALxn8HsCIS/AXCCQFuQZyA0sv89D0j7SajA5NHQehTtIMxGlrSYlj8Lof3zKVcb6j9oJRb3WiBSSQy1kGtYHVyM50lMO2wGE0M7jAyyy9meg5luNhoFhn0ij3IT2ON8iJ86/gmC6fpDIcyviVpK/sVW0q7/ssD+FpNQCzlF1AG4fI1LCUSETRcQ1EqdlAKdpfk7Mz2t08ZUDmOOq7wBEbzPw3YsmL6v7w3zPA9k8lklJCVXhIA2NdXwRIoyrwKs9au4y39bIGY3Jvra8Y8DNpDtDPIZCG5Euz4xvTruhxBOhszAQuXVLURnzPUsNem++BbtI3TuY2QpRPAugF8Zgq1Io5fLaoDeJfxigmQaUyywe1siWEg7wOwy3k/sr97EsD9KxBk3M/TnD8ljSdpipbLCY/dfRKW66yxgyAhGEYRUAM7jdwvyPXztXcZW1r2BhHjSAjHrkGoRvALAJQiQbYkR7Ab0ZwWRRqdtwUxILEwthL+JHizFYi1yOYS2jb4n93lL/wFyiXCtrMR1I6SCYC5ARpOuBaRVAGuvP6HZrzwLeHuIPIFZGqRVI8pllf2+vxt2LlOxYCtjNeOUEm8x0Ryqbs3I0UIHWiByOUMtzPUAXKzUGBbQaGvxhzIIXOSFLTYGMhkUkMyiFjatuqicG9WK7gF9QT4FRnfLGk6T3mT66gp4wUsbetFaiUEWiCFf0uI3lKguyGQMgP8RJBYcEQhc9PWrMZAQBAXYLEkL0qqLSmJIs74spRhif5TtU2IBZpMtEL8WeRYieII0OYznGH0IZHRzjKbC7cgqCP91inmAgZTVHiun4K8pjfzI2OlJTG8SPQMx7hhd18BeOuu5dLjn9cMzsNfSctJwT/lLrCTGXAvEVCHVwvwboBjialJqDCknBkH144ZvGiy4wRK0S6Wv7VIQ6NyxMO9BiIdmDw//Cqn/5jK/xeJlCLIE6yEC0spaHh6yEpcnLNCPf32hYfEiMV6C2MzYogSz1Jeh7GboGph9aA7z8AbypEdjqCE4gkaB+QvjA4iNEPIuZqsISMfMoxDBJh4Wol2NYo4SSwFUx4WtkuhXW2B/aTMGgl8d+UkUYhf7abkSdYDnIKYi7Q8Fw7FogED651NEoDfYLAj9ttR/YPGK5kXE5uwDYfKIPghiJHKYEpU0t5TmLrGSuZABoBn0ewOCDLGBuPwV2Qsi+BZfFllYE7H/Os0E/MgEVR7zaAwg2EVBCuRp3vmYBjUQ8gNRxzLOMLor8SHgPcrdg3xQNyhrIK2Yx5+QMT17twM4jKaXldwMxWHA5pb/BQ==(/figma)-->\"></span>SEPTEMBER 15, 2023 \u2013 SET TIME: 8:00 PM</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\"}}},\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\" style=\"margin-top:0\">Midnight Riders</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"85%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:var(--wp--preset--spacing--40);flex-basis:85%\"><!-- wp:paragraph -->\r\n<p>The Midnight Riders are a guitar-driven powerhouse duo that will blow you away with their electrifying performances. Their high-energy rock anthems and blistering solos will leave you breathless.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"className\":\"is-style-button-impact\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-button-impact has-tiny-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">BUY TICKETS</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/tc-gallery-1',
		array(
			'title'       => __( 'Four column gallery with images together', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-gallery' ),
			'content'     => "<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\",\"left\":\"0\",\"right\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--70);padding-right:0;padding-bottom:var(--wp--preset--spacing--70);padding-left:0\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-center has-small-font-size\">TECH CON 2025</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"780px\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"big\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-center has-big-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--20)\">Captivating Moments from Our Conferences</h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|60\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"620px\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:paragraph {\"align\":\"center\"} -->\r\n<p class=\"has-text-align-center\">Explore a collection of captivating photographs that capture the essence of our gatherings, showcasing the vibrant discussions, engaging workshops, and memorable moments.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:columns {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"},\"blockGap\":{\"left\":\"0\"}}}} -->\r\n<div class=\"wp-block-columns alignfull\" style=\"padding-right:0;padding-left:0\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":1693,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-con3.jpg\" alt=\"\" class=\"wp-image-1693\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":1695,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-con4.jpg\" alt=\"\" class=\"wp-image-1695\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":1696,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-con2.jpg\" alt=\"\" class=\"wp-image-1696\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":1694,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-con1.jpg\" alt=\"\" class=\"wp-image-1694\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/tc-gallery-2',
		array(
			'title'       => __( 'Gallery with multiple columns', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-gallery' ),
			'content'     => "<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\",\"left\":\"0\",\"right\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-top:var(--wp--preset--spacing--70);padding-right:0;padding-bottom:var(--wp--preset--spacing--70);padding-left:0\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-left has-text-color has-small-font-size\" style=\"color:#6635f4\">Music Festival 2024</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\",\"contentSize\":\"780px\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-group alignwide\"><!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"big\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-left has-big-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--20)\">Relive the Magic of Our Musical Events</h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|60\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"620px\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:paragraph {\"align\":\"left\"} -->\r\n<p class=\"has-text-align-left\">Step into a world of rhythm and melodies as you browse through our musical event gallery.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:gallery {\"columns\":3,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"align\":\"wide\"} -->\r\n<figure class=\"wp-block-gallery alignwide has-nested-images columns-3 is-cropped\"><!-- wp:image {\"id\":1715,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-event4.jpg\" alt=\"\" class=\"wp-image-1715\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1714,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-event2.jpg\" alt=\"\" class=\"wp-image-1714\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1705,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-event3.jpg\" alt=\"\" class=\"wp-image-1705\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1706,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-event.jpg\" alt=\"\" class=\"wp-image-1706\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1796,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-event5.jpg\" alt=\"\" class=\"wp-image-1796\"/></figure>\r\n<!-- /wp:image --></figure>\r\n<!-- /wp:gallery --></div>\r\n<!-- /wp:group -->",
		)
		);


		register_block_pattern(
		'tc/tc-gallery-3',
		array(
			'title'       => __( 'Four column gallery with section background', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-gallery' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/08/gallery-festival1.jpg\",\"id\":1830,\"dimRatio\":60,\"align\":\"full\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-cover alignfull\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-60 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-1830\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-festival1.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|60\"}}},\"textColor\":\"background\",\"layout\":{\"type\":\"constrained\",\"contentSize\":\"730px\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-group alignwide has-background-color has-text-color\" style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"big\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-left has-big-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--20)\">Vibrant Festival Experience</h2>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"align\":\"left\"} -->\r\n<p class=\"has-text-align-left\">Immerse yourself in a vibrant tapestry of music, art, and community at our festival. Explore diverse experiences that ignite the senses and create lasting memories.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:gallery {\"columns\":4,\"linkTo\":\"none\",\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|60\",\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<figure class=\"wp-block-gallery alignwide has-nested-images columns-4 is-cropped\" style=\"padding-top:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:image {\"id\":1831,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-festival2.jpg\" alt=\"\" class=\"wp-image-1831\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1832,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-festival3.jpg\" alt=\"\" class=\"wp-image-1832\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1833,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-festival4.jpg\" alt=\"\" class=\"wp-image-1833\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1834,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/gallery-festival5.jpg\" alt=\"\" class=\"wp-image-1834\"/></figure>\r\n<!-- /wp:image --></figure>\r\n<!-- /wp:gallery --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:group -->",
		)
		);


		register_block_pattern(
		'tc/speakers-1',
		array(
			'title'       => __( 'Title on the left side with speakers on the right', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-speakers' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"40%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:var(--wp--preset--spacing--50);flex-basis:40%\"><!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"padding\":{\"top\":\"6.3%\"}},\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-color has-small-font-size\" style=\"color:#6635f4;padding-top:6.3%\">Speaker line up</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-big-font-size\">Inspiring Talks and Insights</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<p style=\"margin-top:var(--wp--preset--spacing--40)\">Discover Knowledge and Insights from Our Dynamic and Engaging Speakers Who are Experts in Leadership Strategies, Tech Innovation, Diversity &amp; Inclusion Advocacy, and Financial Planning.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"\"} -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|60\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:1rem\"><!-- wp:image {\"id\":1359,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/themetick/wp-content/uploads/sites/12/2023/05/s-sarah.jpg\" alt=\"\" class=\"wp-image-1359\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|10\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--10)\">Sarah Johnson</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|10\"}}},\"fontSize\":\"calc(10.03px + 0.1vw)\"} -->\r\n<p class=\"has-calc-10-03-px-0-1-vw-font-size\" style=\"margin-top:var(--wp--preset--spacing--10)\">Diversity and Inclusion Advocate</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:1rem\"><!-- wp:image {\"id\":3279,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/team-two.jpg\" alt=\"\" class=\"wp-image-3279\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|10\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--10)\">Michael Brown</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|10\"}}},\"fontSize\":\"calc(10.03px + 0.1vw)\"} -->\r\n<p class=\"has-calc-10-03-px-0-1-vw-font-size\" style=\"margin-top:var(--wp--preset--spacing--10)\">Expert in Leadership and Management</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:1rem\"><!-- wp:image {\"id\":3280,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/team-tree.jpg\" alt=\"\" class=\"wp-image-3280\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|10\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--10)\">David Rodriguez</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|10\"}}},\"fontSize\":\"calc(10.03px + 0.1vw)\"} -->\r\n<p class=\"has-calc-10-03-px-0-1-vw-font-size\" style=\"margin-top:var(--wp--preset--spacing--10)\">Financial Expert</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:1rem\"><!-- wp:image {\"id\":3282,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/team-four.jpg\" alt=\"\" class=\"wp-image-3282\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|10\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--10)\">Karen Lee</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|10\"}}},\"fontSize\":\"calc(10.03px + 0.1vw)\"} -->\r\n<p class=\"has-calc-10-03-px-0-1-vw-font-size\" style=\"margin-top:var(--wp--preset--spacing--10)\">Tech Innovator and Entrepreneur</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);


		register_block_pattern(
		'tc/speakers-2',
		array(
			'title'       => __( 'Zig-zag pattern with speaker image, name and description', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-speakers' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:heading {\"level\":4,\"align\":\"wide\",\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading alignwide has-text-color has-small-font-size\" style=\"color:#6635f4\">Speaker line up</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|70\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\r\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"align\":\"full\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}}} -->\r\n<div class=\"wp-block-columns alignfull\"><!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:image {\"id\":3283,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/speaker-m.jpg\" alt=\"\" class=\"wp-image-3283\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"5%\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-right:5%\"><!-- wp:heading {\"level\":3,\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-big-font-size\">David Rodriguez</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Expert in Leadership and Management</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"8%\",\"top\":\"8%\"}}}} -->\r\n<p style=\"padding-top:8%;padding-bottom:8%\">David Rodriguez is an experienced leadership and management consultant with over 20 years of experience in the industry. He is passionate about helping businesses and organizations develop effective leadership strategies and manage change.<br><br>John is a dynamic and engaging speaker who has presented at numerous conferences and events, sharing his knowledge and insights on leadership and management.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000026\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#00000026;color:#00000026\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"verticalAlignment\":\"center\",\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center stack-on-tablet-portrait\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\"><a href=\"mailto:yourmail@gmail.com\">yourmail@gmail.com</a></p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"foreground\",\"iconColorValue\":\"#000000\",\"size\":\"has-normal-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\"}}},\"className\":\"is-style-logos-only\"} -->\r\n<ul class=\"wp-block-social-links has-normal-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /--></ul>\r\n<!-- /wp:social-links --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"full\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"},\"padding\":{\"top\":\"2rem\"}}}} -->\r\n<div class=\"wp-block-columns alignfull\" style=\"padding-top:2rem\"><!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"5%\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-right:5%\"><!-- wp:heading {\"level\":3,\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-big-font-size\">Sarah Johnson</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Diversity and Inclusion Advocate</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"top\":\"8%\",\"bottom\":\"8%\"}}}} -->\r\n<p style=\"padding-top:8%;padding-bottom:8%\">Sarah Johnson is a diversity and inclusion advocate with over 15 years of experience in the field. She is passionate about promoting diversity and inclusion in the workplace and helping organizations create inclusive and welcoming environments for all employees.<br><br>Sarah is a dynamic and engaging speaker who has presented at various diversity and inclusion conferences and events, sharing her insights and strategies for promoting diversity and inclusion in the workplace.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000026\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#00000026;color:#00000026\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\"><a href=\"mailto:yourmail@gmail.com\">yourmail@gmail.com</a></p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"foreground\",\"iconColorValue\":\"#000000\",\"size\":\"has-normal-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\"}}},\"className\":\"is-style-logos-only\"} -->\r\n<ul class=\"wp-block-social-links has-normal-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /--></ul>\r\n<!-- /wp:social-links --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:image {\"id\":3284,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/speaker-w.jpg\" alt=\"\" class=\"wp-image-3284\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
		)
		);


		register_block_pattern(
		'tc/speakers-3',
		array(
			'title'       => __( 'Three blocks of speakers and centered title', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-speakers' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-center has-text-color has-small-font-size\" style=\"color:#6635f4\">Speaker line up</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|50\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"720px\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"margin-bottom:var(--wp--preset--spacing--50)\"><!-- wp:heading {\"textAlign\":\"center\",\"fontSize\":\"large\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-center has-large-font-size\">Inspiring Talks and Insights from Our Expert Speakers</h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"0%\"}}}} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top\"><!-- wp:column {\"verticalAlignment\":\"top\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|40\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:image {\"align\":\"center\",\"id\":924,\"width\":\"300px\",\"height\":\"330px\",\"scale\":\"contain\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"200%\"}},\"className\":\"is-style-default\"} -->\r\n<figure class=\"wp-block-image aligncenter size-full is-resized has-custom-border is-style-default\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/Group-2.png\" alt=\"\" class=\"wp-image-924\" style=\"border-radius:200%;object-fit:contain;width:300px;height:330px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\",\"padding\":{\"bottom\":\"0\",\"top\":\"var:preset|spacing|20\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--20);padding-bottom:0\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-center has-medium-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--20)\">Isabella Rodriguez</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-text-align-center has-tiny-font-size\">TV PRESENTER</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\"} -->\r\n<p class=\"has-text-align-center\">Her culinary expertise lies in creating unforgettable Latin American culinary experiences that celebrate the richness and diversity of the region\u2019s cuisine.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"foreground\",\"iconColorValue\":\"#000000\",\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\"}}},\"className\":\"is-style-logos-only\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /--></ul>\r\n<!-- /wp:social-links --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"top\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|40\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:image {\"id\":925,\"width\":\"310px\",\"height\":\"330px\",\"scale\":\"contain\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100%\"}},\"className\":\"is-style-rounded\"} -->\r\n<figure class=\"wp-block-image size-full is-resized has-custom-border is-style-rounded\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/Group-3.png\" alt=\"\" class=\"wp-image-925\" style=\"border-radius:100%;object-fit:contain;width:310px;height:330px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\",\"padding\":{\"bottom\":\"0\",\"top\":\"var:preset|spacing|20\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--20);padding-bottom:0\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-center has-medium-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--20)\">Malik Thompson</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-text-align-center has-tiny-font-size\">CHEF &amp; AUTHOR</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\"} -->\r\n<p class=\"has-text-align-center\">On Saturday, prepare to be enchanted by the soulful creations of Chef Malik Thompson. Hailing from the Southern United States, Chef Malik is a master of soul food.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"foreground\",\"iconColorValue\":\"#000000\",\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\"}}},\"className\":\"is-style-logos-only\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /--></ul>\r\n<!-- /wp:social-links --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"top\",\"style\":{\"border\":{\"right\":{\"width\":\"0px\",\"style\":\"none\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"border-right-style:none;border-right-width:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|40\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:image {\"id\":926,\"width\":\"300px\",\"height\":\"320px\",\"scale\":\"contain\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100%\"}},\"className\":\"is-style-rounded\"} -->\r\n<figure class=\"wp-block-image size-full is-resized has-custom-border is-style-rounded\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/Group-4.png\" alt=\"\" class=\"wp-image-926\" style=\"border-radius:100%;object-fit:contain;width:300px;height:320px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\",\"padding\":{\"bottom\":\"0\",\"top\":\"var:preset|spacing|20\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--20);padding-bottom:0\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-center has-medium-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--20)\">Mei Ling Chen</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-text-align-center has-tiny-font-size\">BAKE OFF FINALIST</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\"} -->\r\n<p class=\"has-text-align-center\">Sunday brings us the talent of Chef Mei Ling Chen, an esteemed Chinese-American chef renowned for his expertise in authentic Chinese cuisine.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"foreground\",\"iconColorValue\":\"#000000\",\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\"}}},\"className\":\"is-style-logos-only\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /--></ul>\r\n<!-- /wp:social-links --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);



		register_block_pattern(
		'tc/speakers-4',
		array(
			'title'       => __( 'Three column image and description lineup', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-speakers' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"backgroundColor\":\"foreground\",\"textColor\":\"background\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-background-color has-foreground-background-color has-text-color has-background has-link-color\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"20%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:20%\"><!-- wp:heading {\"level\":3,\"style\":{\"color\":{\"text\":\"#683de5\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-text-color has-small-font-size\" style=\"color:#683de5\">Meet our band<br>members:</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"\"} -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\">We are a rock band that blends modern and classic elements of rock music.</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"top\":\"1rem\"}}}} -->\r\n<p style=\"padding-top:1rem\">We are dedicated to creating music that speaks to the human experience and inspires our fans to live life to the fullest. Whether you're looking for hard-hitting rock anthems or soulful ballads, our music has something for everyone.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\"},\"blockGap\":{\"left\":\"var:preset|spacing|30\"}}}} -->\r\n<div class=\"wp-block-columns\" style=\"padding-top:var(--wp--preset--spacing--50)\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"},\"blockGap\":\"var:preset|spacing|20\"}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:2rem\"><!-- wp:image {\"id\":3285,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/rock-one.jpg\" alt=\"\" class=\"wp-image-3285\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"typography\":{\"textTransform\":\"uppercase\"}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"text-transform:uppercase\">Mike Thompson</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|10\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--10)\">Lead Guitarist</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"},\"blockGap\":\"var:preset|spacing|20\"}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:2rem\"><!-- wp:image {\"id\":3286,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/rock-two.jpg\" alt=\"\" class=\"wp-image-3286\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"typography\":{\"textTransform\":\"uppercase\"}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"text-transform:uppercase\">Emily Johnson</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|10\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--10)\">Lead Vocaliast</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"},\"blockGap\":\"var:preset|spacing|20\"}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:2rem\"><!-- wp:image {\"id\":3287,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/rock-three.jpg\" alt=\"\" class=\"wp-image-3287\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"typography\":{\"textTransform\":\"uppercase\"}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"text-transform:uppercase\">Mark Davis</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|10\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--10)\">Drummer</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/speakers-5',
		array(
			'title'       => __( 'Four blocks of speaker images and names', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-speakers' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:heading {\"level\":3,\"align\":\"wide\",\"textColor\":\"background\",\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-background-color has-text-color has-small-font-size\">Beats in Motion 2024</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"align\":\"wide\",\"fontSize\":\"hugee\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-hugee-font-size\">Festival Lineup</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\"}} -->\r\n<div class=\"wp-block-group alignwide\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"60%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:paragraph -->\r\n<p>This annual event brings together top musicians from around the world to perform in front of a passionate crowd of music lovers.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-fill\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-fill has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">VIEW ALL ARTISTS</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"6.13rem\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\" style=\"margin-top:6.13rem\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"},\"blockGap\":\"var:preset|spacing|10\"}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:2rem\"><!-- wp:image {\"id\":963,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/main3.jpeg\" alt=\"\" class=\"wp-image-963\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|10\"}},\"typography\":{\"textTransform\":\"uppercase\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"padding-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--10);text-transform:uppercase\"><a href=\"#\">The Sonic Explorers</a></h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"font-style:normal;font-weight:500\">Friday August 5th - 9:00 PM <strong>Main Stage</strong></p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"},\"blockGap\":\"var:preset|spacing|10\"}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:2rem\"><!-- wp:image {\"id\":964,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/main6.jpeg\" alt=\"\" class=\"wp-image-964\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|10\"}},\"typography\":{\"textTransform\":\"uppercase\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"padding-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--10);text-transform:uppercase\"><a href=\"#\">Electric Horizon</a></h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"font-style:normal;font-weight:500\">Saturday August 6th - 8:30 PM <strong>Rock Stage</strong></p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"},\"blockGap\":\"var:preset|spacing|10\"}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:2rem\"><!-- wp:image {\"id\":965,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/main5.jpeg\" alt=\"\" class=\"wp-image-965\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|10\"}},\"typography\":{\"textTransform\":\"uppercase\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"padding-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--10);text-transform:uppercase\"><a href=\"#\">Midnight Mirage</a></h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.5rem\"}},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:0.5rem;font-style:normal;font-weight:500\">Sunday August 7th - 10:00 PM <strong>Alternative Stage</strong></p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"},\"blockGap\":\"var:preset|spacing|10\"}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:2rem\"><!-- wp:image {\"id\":966,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/main4.jpeg\" alt=\"\" class=\"wp-image-966\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|10\"}},\"typography\":{\"textTransform\":\"uppercase\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"padding-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--10);text-transform:uppercase\"><a href=\"#\">Solar Groove Collective</a></h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.5rem\"}},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:0.5rem;font-style:normal;font-weight:500\">Saturday August 6th - 7:00 PM <strong>Indie Stage</strong></p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/speakers-6',
		array(
			'title'       => __( 'Three featured artists with large title and background image', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-speakers' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"lineHeight\":\"1\"},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"hugee\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-center has-hugee-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--20);line-height:1\">Incredible speakers</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|60\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"500px\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:paragraph {\"align\":\"center\"} -->\r\n<p class=\"has-text-align-center\">Our speakers are experts in their respective fields, and their knowledge is infused with passion and expertise. </p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/11/speaker-one.jpg\",\"id\":3288,\"dimRatio\":0,\"minHeightUnit\":\"vw\",\"contentPosition\":\"top left\",\"isDark\":false,\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"className\":\"has-rounded-edges\"} -->\r\n<div class=\"wp-block-cover is-light has-custom-content-position is-position-top-left has-rounded-edges has-background-color has-text-color has-link-color\" style=\"padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3288\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/11/speaker-one.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"40vh\"},\"blockGap\":\"var:preset|spacing|20\"}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:40vh\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"1rem\"}}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-left has-medium-font-size\" style=\"margin-bottom:1rem\">Max Collins</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"font-style:normal;font-weight:500\">Award-winning graphic designer</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"background\",\"iconColorValue\":\"#fff\",\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\"}}},\"className\":\"is-style-logos-only\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\r\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /--></ul>\r\n<!-- /wp:social-links --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/11/speaker-two.jpg\",\"id\":3289,\"dimRatio\":0,\"minHeightUnit\":\"vw\",\"contentPosition\":\"top left\",\"isDark\":false,\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"className\":\"has-rounded-edges\"} -->\r\n<div class=\"wp-block-cover is-light has-custom-content-position is-position-top-left has-rounded-edges has-background-color has-text-color has-link-color\" style=\"padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3289\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/11/speaker-two.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"40vh\"},\"blockGap\":\"var:preset|spacing|20\"}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:40vh\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"1rem\"}}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-left has-medium-font-size\" style=\"margin-bottom:1rem\">Jake Thompson</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"font-style:normal;font-weight:500\">Product designer and entrepreneur</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"background\",\"iconColorValue\":\"#fff\",\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\"}}},\"className\":\"is-style-logos-only\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\r\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /--></ul>\r\n<!-- /wp:social-links --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/11/speaker-tr.jpg\",\"id\":3290,\"dimRatio\":0,\"minHeightUnit\":\"vw\",\"contentPosition\":\"top left\",\"isDark\":false,\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"className\":\"has-rounded-edges\"} -->\r\n<div class=\"wp-block-cover is-light has-custom-content-position is-position-top-left has-rounded-edges has-background-color has-text-color has-link-color\" style=\"padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3290\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/11/speaker-tr.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"40vh\"},\"blockGap\":\"var:preset|spacing|20\"}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:40vh\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"1rem\"}}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-left has-medium-font-size\" style=\"margin-bottom:1rem\">Olivia Martinez</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"font-style:normal;font-weight:500\">UX designer and design strategist</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"background\",\"iconColorValue\":\"#fff\",\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\"}}},\"className\":\"is-style-logos-only\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\r\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /--></ul>\r\n<!-- /wp:social-links --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
		)
		);


	register_block_pattern(
		'tc/pricing-1',
		array(
		'title'       => __( 'Three columns pricing with large title', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-pricing' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-center has-text-color has-small-font-size\" style=\"color:#6635f4\">Simple Pricing</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"0\",\"right\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"550px\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-top:0;padding-right:0;padding-bottom:var(--wp--preset--spacing--50);padding-left:0\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|50\"}}},\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-center has-big-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--50)\">Ticket Options and Pricing</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\"} -->\r\n<p class=\"has-text-align-center\">Choose the ticket that best fits your needs and budget! We offer a variety of ticket options for our festival, including Early Bird, Standard, and VIP tickets.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\",\"top\":\"var:preset|spacing|40\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignfull are-vertically-aligned-center stack-on-tablet-portrait\" style=\"padding-top:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30)\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\"}},\"color\":{\"background\":\"#eaeaea\"},\"border\":{\"radius\":\"6px\"}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-background\" style=\"border-radius:6px;background-color:#eaeaea;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"6vw\"}}},\"fontSize\":\"large\"} -->\r\n<h3 class=\"wp-block-heading has-large-font-size\" style=\"padding-bottom:6vw\">Early Bird</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|10\"}}},\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--10)\">$ 94</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.5rem\"}},\"color\":{\"text\":\"#00000075\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-text-color has-tiny-font-size\" style=\"color:#00000075;margin-top:0.5rem\">Discounted price</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#0000001f\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:list {\"style\":{\"typography\":{\"lineHeight\":\"1.8\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"},\"spacing\":{\"padding\":{\"bottom\":\"3rem\"}}},\"className\":\"is-style-bullet-checked\",\"fontSize\":\"tiny\"} -->\r\n<ul style=\"padding-bottom:3rem;font-style:normal;font-weight:600;line-height:1.8\" class=\"is-style-bullet-checked has-tiny-font-size\"><!-- wp:list-item -->\r\n<li>Discounted price for purchasing early</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Early entry to the festival</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Access to exclusive areas or activities</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Free festival t-shirt</li>\r\n<!-- /wp:list-item --></ul>\r\n<!-- /wp:list -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"small\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-small-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy Ticket</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"textColor\":\"white\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center has-white-color has-text-color\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\"}},\"color\":{\"background\":\"#1c1c24\"},\"border\":{\"radius\":\"6px\"}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-background\" style=\"border-radius:6px;background-color:#1c1c24;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"6vw\"}}},\"fontSize\":\"large\"} -->\r\n<h3 class=\"wp-block-heading has-large-font-size\" style=\"padding-bottom:6vw\">Standard Ticket</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|10\"}}},\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--10)\">$ 156</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.5rem\"}},\"color\":{\"text\":\"#ffffff78\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-text-color has-tiny-font-size\" style=\"color:#ffffff78;margin-top:0.5rem\">Premium experience</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#ffffff1f\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#ffffff1f;color:#ffffff1f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:list {\"style\":{\"typography\":{\"lineHeight\":\"1.8\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"},\"spacing\":{\"padding\":{\"bottom\":\"3rem\"}}},\"className\":\"is-style-bullet-checked\",\"fontSize\":\"tiny\"} -->\r\n<ul style=\"padding-bottom:3rem;font-style:normal;font-weight:600;line-height:1.8\" class=\"is-style-bullet-checked has-tiny-font-size\"><!-- wp:list-item -->\r\n<li>Discounted price for purchasing early</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Early entry to the festival</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Access to exclusive areas or activities</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Free festival t-shirt</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Festival merchandise</li>\r\n<!-- /wp:list-item --></ul>\r\n<!-- /wp:list -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"fontSize\":\"tiny\"} -->\r\n<h5 class=\"wp-block-heading has-text-align-center has-tiny-font-size\">MOST POPULAR</h5>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"color\":{\"background\":\"#6635f4\"}},\"fontSize\":\"small\",\"fontFamily\":\"dm-sans\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-dm-sans-font-family has-small-font-size\"><a class=\"wp-block-button__link has-background wp-element-button\" style=\"background-color:#6635f4\">Buy Ticket</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\",\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\"}},\"color\":{\"background\":\"#6635f4\"},\"border\":{\"radius\":\"6px\"}},\"textColor\":\"white\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-white-color has-text-color has-background\" style=\"border-radius:6px;background-color:#6635f4;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"6vw\"}}},\"fontSize\":\"large\"} -->\r\n<h3 class=\"wp-block-heading has-large-font-size\" style=\"padding-bottom:6vw\">VIP Ticket</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|10\"}}},\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--10)\">$ 268</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.5rem\"}},\"color\":{\"text\":\"#ffffff78\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-text-color has-tiny-font-size\" style=\"color:#ffffff78;margin-top:0.5rem\">Discounted price</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#ffffff1f\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#ffffff1f;color:#ffffff1f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:list {\"style\":{\"typography\":{\"lineHeight\":\"1.8\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"},\"spacing\":{\"padding\":{\"bottom\":\"3rem\"}}},\"className\":\"is-style-bullet-checked\",\"fontSize\":\"tiny\"} -->\r\n<ul style=\"padding-bottom:3rem;font-style:normal;font-weight:600;line-height:1.8\" class=\"is-style-bullet-checked has-tiny-font-size\"><!-- wp:list-item -->\r\n<li>Access to exclusive areas or activities</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Free festival t-shirt</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Festival merchandise</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>VIP lounges, areas with premium seating</li>\r\n<!-- /wp:list-item --></ul>\r\n<!-- /wp:list -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"small\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-small-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy Ticket</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4rem\",\"top\":\"4rem\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"450px\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:4rem;padding-bottom:4rem\"><!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-text-align-center has-tiny-font-size\">We're so confident you'll have an amazing time at our festival that we offer a <strong>100% money back</strong> guarantee for all ticket purchases. If you're not completely satisfied with your festival experience, we'll make it right.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
		)
	);


	register_block_pattern(
		'tc/pricing-2',
		array(
		'title'       => __( 'Two columns pricing with large title', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-pricing' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}},\"color\":{\"background\":\"#1c1c24\"}},\"textColor\":\"background\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-background-color has-text-color has-background\" style=\"background-color:#1c1c24;padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:heading {\"level\":3,\"align\":\"wide\",\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-text-color has-small-font-size\" style=\"color:#6635f4\">Simple Pricing</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"verticalAlignment\":\"bottom\",\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4rem\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-bottom stack-on-tablet-portrait\" style=\"padding-bottom:4rem\"><!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-bottom\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:heading {\"level\":3,\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-big-font-size\">Ticket Options and Pricing</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-bottom\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"right\":\"10%\"}}}} -->\r\n<p style=\"padding-right:10%\">Choose the ticket that best fits your needs and budget! We offer a variety of ticket options for our festival, including Early Bird, Standard, and VIP tickets.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"color\":{\"background\":\"#eaeaea\"},\"border\":{\"radius\":\"6px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\"}}},\"textColor\":\"foreground\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-foreground-color has-text-color has-background\" style=\"border-radius:6px;background-color:#eaeaea;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}},\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\" style=\"padding-bottom:2rem\">Standard Ticket</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\",\"verticalAlignment\":\"bottom\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\">$ 156</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#00000078\"}}} -->\r\n<p class=\"has-text-color\" style=\"color:#00000078\">Premium experience</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#0000001c\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#0000001c;color:#0000001c\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:list {\"style\":{\"spacing\":{\"padding\":{\"top\":\"1rem\",\"bottom\":\"2rem\"}},\"typography\":{\"lineHeight\":\"1.8\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"className\":\"is-style-bullet-checked\",\"fontSize\":\"tiny\"} -->\r\n<ul style=\"padding-top:1rem;padding-bottom:2rem;font-style:normal;font-weight:600;line-height:1.8\" class=\"is-style-bullet-checked has-tiny-font-size\"><!-- wp:list-item -->\r\n<li>Discounted price for purchasing early</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Early entry to the festival</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Access to exclusive areas or activities</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Free festival t-shirt</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Festival merchandise</li>\r\n<!-- /wp:list-item --></ul>\r\n<!-- /wp:list -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"small\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-small-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy Ticket</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"color\":{\"background\":\"#0b26ff\"},\"border\":{\"radius\":\"6px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\"}}},\"textColor\":\"white\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-white-color has-text-color has-background\" style=\"border-radius:6px;background-color:#0b26ff;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}},\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\" style=\"padding-bottom:2rem\">VIP Ticket</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\",\"verticalAlignment\":\"bottom\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\">$ 268</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#ffffff78\"}}} -->\r\n<p class=\"has-text-color\" style=\"color:#ffffff78\">Access to VIP areas</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#ffffff4d\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#ffffff4d;color:#ffffff4d\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:list {\"style\":{\"spacing\":{\"padding\":{\"top\":\"1rem\",\"bottom\":\"2rem\"}},\"typography\":{\"lineHeight\":\"1.8\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"className\":\"is-style-bullet-checked\",\"fontSize\":\"tiny\"} -->\r\n<ul style=\"padding-top:1rem;padding-bottom:2rem;font-style:normal;font-weight:600;line-height:1.8\" class=\"is-style-bullet-checked has-tiny-font-size\"><!-- wp:list-item -->\r\n<li>Early entry to the festival</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Access to exclusive areas or activities</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Free festival t-shirt</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Festival merchandise</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>VIP lounges, areas with premium seating</li>\r\n<!-- /wp:list-item --></ul>\r\n<!-- /wp:list -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"small\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-small-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy Ticket</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"3rem\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\" style=\"padding-top:3rem\"><!-- wp:column {\"width\":\"38%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:38%\"><!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">We're so confident you'll have an amazing time at our festival that we offer a <strong>100% money back</strong> guarantee for all ticket purchases. If you're not completely satisfied with your festival experience, we'll make it right.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
	);

	register_block_pattern(
		'tc/pricing-3',
		array(
		'title'       => __( 'Horizontal pricing with large title', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-pricing' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:heading {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}}} -->\r\n<h2 class=\"wp-block-heading alignwide\" style=\"padding-bottom:var(--wp--preset--spacing--40)\">Pricing Plans</h2>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"border\":{\"color\":\"#00000012\",\"width\":\"1px\",\"radius\":\"6px\"}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignwide has-border-color\" style=\"border-color:#00000012;border-width:1px;border-radius:6px\"><!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|70\"},\"padding\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top\" style=\"padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"60%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:60%\"><!-- wp:columns {\"className\":\"stack-on-tablet-landscape\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-landscape\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|40\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"center\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":1016,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/door_back_FILL0_wght400_GRAD0_opsz48.svg\" alt=\"\" class=\"wp-image-1016\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\r\n<h3 class=\"wp-block-heading has-large-font-size\">Bronze</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\r\n<p>Access to exclusive areas or activities. Free festival t-shirt.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"top\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|50\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\",\"verticalAlignment\":\"center\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\">$37</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:buttons {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-buttons has-custom-font-size has-tiny-font-size\"><!-- wp:button {\"className\":\"is-style-outline\"} -->\r\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Buy now</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"border\":{\"color\":\"#00000012\",\"width\":\"1px\",\"radius\":\"6px\"}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignwide has-border-color\" style=\"border-color:#00000012;border-width:1px;border-radius:6px\"><!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|70\"},\"padding\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top\" style=\"padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"60%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:60%\"><!-- wp:columns {\"className\":\"stack-on-tablet-landscape\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-landscape\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|40\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"center\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":1032,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/door_sliding_FILL0_wght400_GRAD0_opsz48.svg\" alt=\"\" class=\"wp-image-1032\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\r\n<h3 class=\"wp-block-heading has-large-font-size\">Gold</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\r\n<p>Access to exclusive areas or activities. Free festival t-shirt. Festival merchandise</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"top\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|50\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\",\"verticalAlignment\":\"center\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\">$68</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:buttons {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-buttons has-custom-font-size has-tiny-font-size\"><!-- wp:button {\"className\":\"is-style-outline\"} -->\r\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Buy now</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"border\":{\"color\":\"#00000012\",\"width\":\"1px\",\"radius\":\"6px\"}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignwide has-border-color\" style=\"border-color:#00000012;border-width:1px;border-radius:6px\"><!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|70\"},\"padding\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top\" style=\"padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"60%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:60%\"><!-- wp:columns {\"className\":\"stack-on-tablet-landscape\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-landscape\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|40\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"center\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":1033,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/balcony_FILL0_wght400_GRAD0_opsz48.svg\" alt=\"\" class=\"wp-image-1033\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\r\n<h3 class=\"wp-block-heading has-large-font-size\">Platinum</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\r\n<p>Free festival t-shirt. Festival merchandise. VIP lounges, areas with premium seating</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"top\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|50\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\",\"verticalAlignment\":\"center\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\">$142</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:buttons {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-buttons has-custom-font-size has-tiny-font-size\"><!-- wp:button {\"className\":\"is-style-outline\"} -->\r\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Buy now</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
		)
	);


	register_block_pattern(
		'tc/pricing-4',
		array(
		'title'       => __( 'Title and text on the left with pricing plan on the right side', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-pricing' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/11/pricing-h.jpg\",\"id\":3323,\"dimRatio\":0,\"minHeight\":100,\"minHeightUnit\":\"vh\",\"isDark\":false,\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"4rem\",\"bottom\":\"4rem\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\"} -->\r\n<div class=\"wp-block-cover alignfull is-light has-background-color has-text-color has-link-color\" style=\"padding-top:4rem;padding-bottom:4rem;min-height:100vh\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3323\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/11/pricing-h.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center stack-on-tablet-portrait\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.6%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.6%\"><!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-left has-text-color has-small-font-size\" style=\"color:#6635f4\">Experience the Excitement</h2>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"style\":{\"typography\":{\"lineHeight\":\"1\"},\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}},\"fontSize\":\"gigantic\"} -->\r\n<h2 class=\"wp-block-heading has-gigantic-font-size\" style=\"padding-bottom:2rem;line-height:1\">Ocean Vibes Festival</h2>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"60%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:4rem;flex-basis:60%\"><!-- wp:paragraph -->\r\n<p>This annual event brings together top musicians from around the world to perform in front of a passionate crowd of music lovers.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:heading {\"level\":5,\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"fontSize\":\"tiny\"} -->\r\n<h5 class=\"wp-block-heading has-link-color has-tiny-font-size\"><a href=\"#\">Find us on map</a></h5>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"33.3%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:33.3%\"><!-- wp:group {\"style\":{\"border\":{\"radius\":\"6px\"},\"color\":{\"background\":\"#fffeff\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\",\"right\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\"}}},\"textColor\":\"foreground\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-foreground-color has-text-color has-background\" style=\"border-radius:6px;background-color:#fffeff;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"6vw\"}}},\"fontSize\":\"large\"} -->\r\n<h3 class=\"wp-block-heading has-large-font-size\" style=\"padding-bottom:6vw\">Early Bird</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\">$ 94</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#0000003b\"}},\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-text-color has-large-font-size\" style=\"color:#0000003b\"><s>$ 124</s></h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.5rem\"}},\"color\":{\"text\":\"#00000075\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-text-color has-tiny-font-size\" style=\"color:#00000075;margin-top:0.5rem\">Discounted price</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#0000001f\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:list {\"style\":{\"typography\":{\"lineHeight\":\"1.8\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"},\"spacing\":{\"padding\":{\"bottom\":\"3rem\"}}},\"className\":\"is-style-bullet-checked\",\"fontSize\":\"tiny\"} -->\r\n<ul style=\"padding-bottom:3rem;font-style:normal;font-weight:600;line-height:1.8\" class=\"is-style-bullet-checked has-tiny-font-size\"><!-- wp:list-item -->\r\n<li>Discounted price for purchasing early</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Early entry to the festival</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Access to exclusive areas or activities</li>\r\n<!-- /wp:list-item -->\r\n\r\n<!-- wp:list-item -->\r\n<li>Free festival t-shirt</li>\r\n<!-- /wp:list-item --></ul>\r\n<!-- /wp:list -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"small\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-small-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy Ticket</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"8%\",\"left\":\"8%\",\"top\":\"2rem\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-text-align-center has-tiny-font-size\" style=\"padding-top:2rem;padding-right:8%;padding-left:8%\">We're so confident you'll have an amazing time at our festival that we offer a <strong>100% money back</strong> guarantee for all ticket purchases.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:group -->",
		)
	);


	register_block_pattern(
		'tc/contact-1',
		array(
		'title'       => __( 'Image on the left with contact info on the right', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-contact' ),
		'content'     => "<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"40%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:var(--wp--preset--spacing--40);flex-basis:40%\"><!-- wp:image {\"id\":1610,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-large has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/Contact-2col-894x1024.jpg\" alt=\"\" class=\"wp-image-1610\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"\"} -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}},\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-big-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--40)\">Need Answers?<br>Get in Touch. We'll Respond Shortly</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"60%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\"}}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--50)\">If you have any questions or concerns about purchasing tickets, please feel free to contact us using the information provided below.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"},\"padding\":{\"bottom\":\"1rem\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\" style=\"padding-bottom:1rem\"><!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\r\n<p>Address: 123 Main Street,<br>Anytown USA</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"60%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:paragraph -->\r\n<p>Phone: +1 (123) 456-7890<br>Email: info@example.com</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"},\"padding\":{\"bottom\":\"3rem\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\" style=\"padding-bottom:3rem\"><!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|10\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--10)\">Send me an email:</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.5rem\"}}}} -->\r\n<p style=\"margin-top:0.5rem\"><a href=\"mailto:yourmail@gmail.com\">yourmail@gmail.com</a></p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"60%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|10\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--10)\">Follow Me :</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.5rem\"}}}} -->\r\n<p style=\"margin-top:0.5rem\"><a href=\"#\">Twitter</a><br><a href=\"#\">Facebook</a><br><a href=\"#\">Instagram</a></p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
	);


	register_block_pattern(
		'tc/contact-2',
		array(
		'title'       => __( 'Large contact info block with an image on the right', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-contact' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#1c1c24\"},\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"layout\":{\"type\":\"default\"}} -->\r\n<div class=\"wp-block-group alignfull has-background-color has-text-color has-background has-link-color\" style=\"background-color:#1c1c24;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:media-text {\"align\":\"full\",\"mediaPosition\":\"right\",\"mediaId\":3274,\"mediaLink\":\"https://themetick.com/patterns/contact/contact-f/\",\"mediaType\":\"image\",\"mediaWidth\":35,\"imageFill\":true} -->\r\n<div class=\"wp-block-media-text alignfull has-media-on-the-right is-stacked-on-mobile is-image-fill\" style=\"grid-template-columns:auto 35%\"><div class=\"wp-block-media-text__content\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"4rem\",\"bottom\":\"8rem\",\"right\":\"4rem\",\"left\":\"2rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:4rem;padding-right:4rem;padding-bottom:8rem;padding-left:2rem\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"8rem\"}}},\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-big-font-size\" style=\"padding-bottom:8rem\">Got Questions?<br>We're here to help.</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Sales enquiries</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"20%\"}}},\"className\":\"stack-on-tablet-landscape\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-landscape\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\r\n<p>If you are interested in our products or services and would like to make a purchase.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\r\n<p>Phone: +1 (123) 456-7890<br>Email: <a href=\"mailto:info@example.com\">info@example.com</a></p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#ffffff1f\"},\"spacing\":{\"margin\":{\"top\":\"2rem\",\"bottom\":\"2rem\"}}},\"className\":\"is-style-wide\"} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"margin-top:2rem;margin-bottom:2rem;background-color:#ffffff1f;color:#ffffff1f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Press enquiries</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"20%\"}}},\"className\":\"stack-on-tablet-landscape\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-landscape\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\r\n<p>If you are a member of the press and would like to request an interview.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\r\n<p>Phone: +1 (123) 456-7890<br>Email: <a href=\"mailto:info@example.com\">info@example.com</a></p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#ffffff1f\"},\"spacing\":{\"margin\":{\"top\":\"2rem\",\"bottom\":\"2rem\"}}},\"className\":\"is-style-wide\"} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"margin-top:2rem;margin-bottom:2rem;background-color:#ffffff1f;color:#ffffff1f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"20%\"}}}} -->\r\n<div class=\"wp-block-columns\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Other enquiries</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\r\n<p><a href=\"mailto:info@example.com\">info@example.com</a></p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group --></div><figure class=\"wp-block-media-text__media\" style=\"background-image:url(https://themetick.com/wp-content/uploads/2023/11/contact-f-626x1024.jpg);background-position:50% 50%\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/contact-f-626x1024.jpg\" alt=\"\" class=\"wp-image-3274 size-full\"/></figure></div>\r\n<!-- /wp:media-text --></div>\r\n<!-- /wp:group -->",
		)
	);

	register_block_pattern(
		'tc/contact-3',
		array(
		'title'       => __( 'Large left title and with call to action buttons and contact info on the right', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-contact' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"8rem\",\"bottom\":\"8rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:8rem;padding-bottom:8rem\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"60%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:4rem;flex-basis:60%\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#6635f4\"},\"typography\":{\"textTransform\":\"none\"}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-color has-small-font-size\" style=\"color:#6635f4;text-transform:none\">Greetings!</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"typography\":{\"letterSpacing\":\"-0.05rem\"}},\"fontSize\":\"big\"} -->\r\n<h4 class=\"wp-block-heading has-big-font-size\" style=\"letter-spacing:-0.05rem\">We will strive to respond to your message as soon as possible.</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#0000001f\"},\"spacing\":{\"margin\":{\"top\":\"3rem\",\"bottom\":\"2rem\"}}},\"className\":\"is-style-wide\"} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"margin-top:3rem;margin-bottom:2rem;background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}}} -->\r\n<p style=\"padding-bottom:1rem\">If you have any questions or concerns, please don't hesitate to contact us. Our team is here to help and we'll get back to you as soon as possible.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:buttons {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|10\"}}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">CONTACT US</a></div>\r\n<!-- /wp:button -->\r\n\r\n<!-- wp:button {\"className\":\"is-style-outline\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">JOIN OUR TEAM</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:group {\"style\":{\"color\":{\"background\":\"#121212\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}},\"border\":{\"radius\":\"6px\"},\"spacing\":{\"padding\":{\"top\":\"2.5rem\",\"right\":\"2.5rem\",\"bottom\":\"2.5rem\",\"left\":\"2.5rem\"}}},\"textColor\":\"background\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-background-color has-text-color has-background has-link-color\" style=\"border-radius:6px;background-color:#121212;padding-top:2.5rem;padding-right:2.5rem;padding-bottom:2.5rem;padding-left:2.5rem\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Contact me</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"background\",\"iconColorValue\":\"#fff\",\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0.5rem\",\"left\":\"0.5rem\"}}},\"className\":\"is-style-logos-only\"} -->\r\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"linkedin\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /--></ul>\r\n<!-- /wp:social-links --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#ffffff30\"},\"spacing\":{\"margin\":{\"top\":\"2em\",\"bottom\":\"2em\"}}},\"className\":\"is-style-wide\"} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"margin-top:2em;margin-bottom:2em;background-color:#ffffff30;color:#ffffff30\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:0;margin-bottom:0\">Email</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.5rem\"}}}} -->\r\n<p style=\"margin-top:0.5rem\">info@example.com</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#ffffff30\"},\"spacing\":{\"margin\":{\"top\":\"2em\",\"bottom\":\"2em\"}}},\"className\":\"is-style-wide\"} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"margin-top:2em;margin-bottom:2em;background-color:#ffffff30;color:#ffffff30\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:0;margin-bottom:0\">Phone</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.5rem\"}}}} -->\r\n<p style=\"margin-top:0.5rem\">+1 (123) 456-7890</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#ffffff30\"},\"spacing\":{\"margin\":{\"top\":\"2em\",\"bottom\":\"2em\"}}},\"className\":\"is-style-wide\"} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"margin-top:2em;margin-bottom:2em;background-color:#ffffff30;color:#ffffff30\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--20)\">Address</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.5rem\"}}}} -->\r\n<p style=\"margin-top:0.5rem\">Address: 123 Main Street,<br>Anytown USA</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
	);


		register_block_pattern(
		'tc/contact-4',
		array(
			'title'       => __( 'Section with a background, large title and some text', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-contact' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/11/contact-ni-scaled.jpg\",\"id\":3276,\"dimRatio\":80,\"customOverlayColor\":\"#1c1c24\",\"align\":\"wide\"} -->\r\n<div class=\"wp-block-cover alignwide\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-80 has-background-dim\" style=\"background-color:#1c1c24\"></span><img class=\"wp-block-cover__image-background wp-image-3276\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/11/contact-ni-scaled.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"},\"padding\":{\"top\":\"3em\",\"bottom\":\"3em\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait has-background-color has-text-color has-link-color\" style=\"padding-top:3em;padding-bottom:3em\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"55%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:55%\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Contact Us</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"90%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:90%\"><!-- wp:heading {\"level\":3,\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}},\"spacing\":{\"padding\":{\"bottom\":\"12rem\"}}},\"textColor\":\"background\",\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-background-color has-text-color has-link-color has-big-font-size\" style=\"padding-bottom:12rem\">We'd love to hear from you</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Contact me</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:social-links {\"iconColor\":\"background\",\"iconColorValue\":\"#fff\",\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0.5rem\",\"left\":\"0.5rem\"}}},\"className\":\"is-style-logos-only\"} -->\r\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"linkedin\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /-->\r\n\r\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /--></ul>\r\n<!-- /wp:social-links --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"\",\"textColor\":\"background\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center has-background-color has-text-color\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:paragraph -->\r\n<p>If you have any questions or concerns, please don't hesitate to contact us. Our team is here to help and we'll get back to you as soon as possible.<br><br>You can contact us Monday through Friday from 8 AM to 6 PM PST.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"top\":\"2rem\"}}}} -->\r\n<p style=\"padding-top:2rem\">Phone: +1 (123) 456-7890<br>Email: <a href=\"mailto:info@example.com\">info@example.com</a></p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:group -->",
		)
		);



		register_block_pattern(
		'tc/location-1',
		array(
			'title'       => __( 'Two columns with fullwidth map under it', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-location' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"60%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":3,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-text-color has-small-font-size\" style=\"color:#6635f4\">VENUE</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"fontSize\":\"hugee\"} -->\r\n<h3 class=\"wp-block-heading has-hugee-font-size\">Location</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"90%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:90%\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}}} -->\r\n<p style=\"padding-bottom:2rem\">We're proud to partner with some of the best companies in the industry to bring you an unforgettable festival experience. Our partners share our commitment to excellence and help us provide top-quality services and amenities to our attendees.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}},\"className\":\"stack-on-tablet-landscape\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-landscape\" style=\"padding-bottom:2rem\"><!-- wp:column {\"width\":\"60%\",\"style\":{\"spacing\":{\"blockGap\":\"5%\"}}} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4,\"fontSize\":\"tiny\"} -->\r\n<h4 class=\"wp-block-heading has-tiny-font-size\">Location</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"},\"margin\":{\"top\":\"0.5rem\"}}}} -->\r\n<p style=\"margin-top:0.5rem;padding-bottom:1rem\">Arena Boulevard 1; <br>Zuidoost; Amsterdam; Netherlands</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"verticalAlignment\":\"bottom\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Get directions</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Accommodation</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>Convenient accommodation options are available near the Quantum Horizons Conference Center. Choose from a range of nearby hotels offering comfortable rooms and modern amenities.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#0000001f\"},\"spacing\":{\"margin\":{\"top\":\"2rem\",\"bottom\":\"2rem\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:2rem;margin-bottom:2rem;background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Facilities</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>The Quantum Horizons Conference Center provides state-of-the-art facilities. Experience advanced audiovisual equipment, spacious conference halls, and comfortable seating. Stay connected with reliable internet access.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"2rem\"}}},\"layout\":{\"type\":\"default\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-top:2rem\"><!-- wp:wpmapblock/wp-map-block {\"map_id\":\"wpmapblock_716c181d\",\"map_marker_list\":[{\"lat\":\"52.31740227600116\",\"lng\":\"4.940784211518692\",\"title\":\"Bangladesh\",\"content\":\"Arena Boulevard 1; Zuidoost; Amsterdam; Netherlands\",\"iconType\":\"default\",\"customIconUrl\":\"\",\"customIconWidth\":25,\"customIconHeight\":40}],\"map_zoom\":11,\"map_height\":600} /--></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
		)
		);


		register_block_pattern(
		'tc/location-2',
		array(
			'title'       => __( 'Two columns with map on the left and location on the right', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-location' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\"><!-- wp:columns {\"align\":\"full\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\",\"left\":\"0\"},\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}},\"color\":{\"background\":\"#6635f4\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignfull stack-on-tablet-portrait has-background-color has-text-color has-background has-link-color\" style=\"background-color:#6635f4;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:wpmapblock/wp-map-block {\"map_id\":\"wpmapblock_c551ab26\",\"map_marker_list\":[{\"lat\":\"52.31740227600116\",\"lng\":\"4.940784211518692\",\"title\":\"Arena Boulevard 1\",\"content\":\"Arena Boulevard 1; Zuidoost; Amsterdam; Netherlands\",\"iconType\":\"default\",\"customIconUrl\":\"\",\"customIconWidth\":25,\"customIconHeight\":40}],\"map_zoom\":11,\"map_height\":810} /--></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\",\"left\":\"var:preset|spacing|60\",\"right\":\"var:preset|spacing|60\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--70);padding-right:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--70);padding-left:var(--wp--preset--spacing--60)\"><!-- wp:heading {\"level\":3,\"textColor\":\"background\",\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-background-color has-text-color has-small-font-size\">Venue</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}},\"typography\":{\"lineHeight\":\"1\"}},\"fontSize\":\"hugee\"} -->\r\n<h3 class=\"wp-block-heading has-hugee-font-size\" style=\"padding-bottom:1rem;line-height:1\">Celestial Pavilion</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"75%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:75%\"><!-- wp:paragraph -->\r\n<p>The main hall is equipped with the latest audio and visual technology, providing a seamless experience for both presenters and attendees.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:spacer {\"height\":\"6vh\"} -->\r\n<div style=\"height:6vh\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:heading {\"level\":4,\"fontSize\":\"tiny\"} -->\r\n<h4 class=\"wp-block-heading has-tiny-font-size\">Location</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"},\"margin\":{\"top\":\"0.5rem\"}}}} -->\r\n<p style=\"margin-top:0.5rem;padding-bottom:1rem\">Arena Boulevard 1; <br>Zuidoost; Amsterdam; Netherlands</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">Get directions</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/location-3',
		array(
			'title'       => __( 'Three columns with fullwidth map under it', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-location' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"0\"},\"margin\":{\"bottom\":\"6rem\"}},\"color\":{\"background\":\"#1c1c24\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-background-color has-text-color has-background has-link-color\" style=\"background-color:#1c1c24;margin-bottom:6rem;padding-top:6rem;padding-bottom:0\"><!-- wp:heading {\"level\":3,\"align\":\"wide\",\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-text-color has-small-font-size\" style=\"color:#6635f4\">Green Summit 2027</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\"}}},\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-big-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--50)\">Over 100+ Sessions</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}},\"className\":\"stack-on-tablet-landscape\"} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center stack-on-tablet-landscape\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.6%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-bottom:2rem;flex-basis:66.6%\"><!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}}} -->\r\n<div class=\"wp-block-columns\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h4 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--20)\">Where</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"},\"margin\":{\"top\":\"0.5rem\"}}}} -->\r\n<p style=\"margin-top:0.5rem;padding-bottom:1rem\">Quantum Horizons Conference,<br>Address: 123 Quantum Avenue, Futuria City, Metropolis</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h4 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--20)\">When</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"},\"margin\":{\"top\":\"0.5rem\"}}}} -->\r\n<p style=\"margin-top:0.5rem;padding-bottom:1rem\">September 28-30, 2023<br>Early bird registration opens on June 1, 2023</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-bottom:2rem;flex-basis:20%\"><!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">Get directions</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"3rem\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"margin\":{\"bottom\":\"0rem\"}}}} -->\r\n<div class=\"wp-block-columns alignfull\" style=\"margin-bottom:0rem;padding-top:3rem;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:wpmapblock/wp-map-block {\"map_id\":\"wpmapblock_3f7bf1a7\",\"map_marker_list\":[{\"lat\":\"52.31740227600116\",\"lng\":\"4.940784211518692\",\"title\":\"Bangladesh\",\"content\":\"Arena Boulevard 1; Zuidoost; Amsterdam; Netherlands\",\"iconType\":\"default\",\"customIconUrl\":\"\",\"customIconWidth\":25,\"customIconHeight\":40}],\"map_zoom\":14,\"map_height\":600} /--></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/location-4',
		array(
			'title'       => __( 'Venue info with image and button for map', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-location' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\",\"verticalAlignment\":\"bottom\"}} -->\r\n<div class=\"wp-block-group alignwide\"><!-- wp:heading {\"level\":3,\"align\":\"wide\",\"fontSize\":\"gigantic\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-gigantic-font-size\">Venue</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#00000036\"}},\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-text-color has-large-font-size\" style=\"color:#00000036\">2026 EC</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#0000001f\"},\"spacing\":{\"margin\":{\"top\":\"3rem\",\"bottom\":\"3rem\"}}},\"className\":\"is-style-wide\"} -->\r\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"margin-top:3rem;margin-bottom:3rem;background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|70\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"38%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:2rem;flex-basis:38%\"><!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h4 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--20)\">Location</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"},\"margin\":{\"top\":\"0.5rem\"}}}} -->\r\n<p style=\"margin-top:0.5rem;padding-bottom:1rem\">Arena Boulevard 1; <br>Zuidoost; Amsterdam; Netherlands</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Get directions</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"\"} -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\r\n<h3 class=\"wp-block-heading has-large-font-size\">The Venue for EventiCon is a modern and spacious building located in the heart of Cityville.</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:gallery {\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<figure class=\"wp-block-gallery alignwide has-nested-images columns-default is-cropped\" style=\"padding-top:var(--wp--preset--spacing--40)\"><!-- wp:image {\"id\":3293,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/venue-one.jpg\" alt=\"\" class=\"wp-image-3293\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3294,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/venue-tw.jpg\" alt=\"\" class=\"wp-image-3294\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3295,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/venue-tr.jpg\" alt=\"\" class=\"wp-image-3295\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image --></figure>\r\n<!-- /wp:gallery --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/location-5',
		array(
			'title'       => __( 'Two columns with venue info on the left and gallery on the right', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-location' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#eaeaea\"},\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-background\" style=\"background-color:#eaeaea;padding-top:6rem;padding-bottom:6rem\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"level\":3,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-text-color has-small-font-size\" style=\"color:#6635f4\">VENUE</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}},\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-big-font-size\" style=\"padding-bottom:2rem\">Get Direction to the Event Hall</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>With its sleek and elegant design, the venue boasts state-of-the-art facilities that are perfect for hosting any type of event.<br><br>The main hall is equipped with the latest audio and visual technology, providing a seamless experience for both presenters and attendees.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#0000001f\"},\"spacing\":{\"margin\":{\"top\":\"2rem\",\"bottom\":\"2rem\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:2rem;margin-bottom:2rem;background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}},\"className\":\"stack-on-tablet-landscape\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-landscape\" style=\"padding-bottom:2rem\"><!-- wp:column {\"width\":\"60%\",\"style\":{\"spacing\":{\"blockGap\":\"5%\"}}} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"level\":4,\"fontSize\":\"tiny\"} -->\r\n<h4 class=\"wp-block-heading has-tiny-font-size\">Location</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"},\"margin\":{\"top\":\"0.5rem\"}}}} -->\r\n<p style=\"margin-top:0.5rem;padding-bottom:1rem\">Arena Boulevard 1; <br>Zuidoost; Amsterdam; Netherlands</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"verticalAlignment\":\"bottom\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Get directions</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:gallery {\"columns\":2,\"linkTo\":\"none\",\"sizeSlug\":\"full\"} -->\r\n<figure class=\"wp-block-gallery has-nested-images columns-2 is-cropped\"><!-- wp:image {\"id\":3295,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/venue-tr.jpg\" alt=\"\" class=\"wp-image-3295\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3294,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/venue-tw.jpg\" alt=\"\" class=\"wp-image-3294\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3297,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"6px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Mask-group-2023-11-14T204642.244.jpg\" alt=\"\" class=\"wp-image-3297\" style=\"border-radius:6px\"/></figure>\r\n<!-- /wp:image --></figure>\r\n<!-- /wp:gallery --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/location-6',
		array(
			'title'       => __( 'Large title with two column text and image background', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-location' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/08/location-bg.jpg\",\"id\":1267,\"hasParallax\":true,\"dimRatio\":60,\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"8rem\",\"bottom\":\"10rem\"}}}} -->\r\n<div class=\"wp-block-cover alignfull has-parallax\" style=\"padding-top:8rem;padding-bottom:10rem\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-60 has-background-dim\"></span><div role=\"img\" class=\"wp-block-cover__image-background wp-image-1267 has-parallax\" style=\"background-position:50% 50%;background-image:url(https://themetick.com/wp-content/uploads/2023/08/location-bg.jpg)\"></div><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"textColor\":\"background\",\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-center has-background-color has-text-color has-small-font-size\">Time &amp; Location</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"typography\":{\"lineHeight\":\"1\"},\"spacing\":{\"padding\":{\"bottom\":\"4rem\"}}},\"textColor\":\"background\",\"fontSize\":\"hugee\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-center has-background-color has-text-color has-hugee-font-size\" style=\"padding-bottom:4rem;line-height:1\">Ocean Vibes<br>Festival</h2>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"className\":\"stack-on-tablet-portrait \"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"3rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:3rem\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"textColor\":\"background\",\"fontSize\":\"medium\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-center has-background-color has-text-color has-medium-font-size\">Where</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\",\"textColor\":\"background\",\"fontSize\":\"small\"} -->\r\n<p class=\"has-text-align-center has-background-color has-text-color has-small-font-size\">Join us for the ultimate jazz experience.<br>Address: 456 Tasty Street, Austin, TX 78701</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">Get direction</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"textColor\":\"background\",\"fontSize\":\"medium\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-center has-background-color has-text-color has-medium-font-size\">When</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\",\"textColor\":\"background\",\"fontSize\":\"small\"} -->\r\n<p class=\"has-text-align-center has-background-color has-text-color has-small-font-size\">June 25-27, 2025<br>Early bird registration opens on June 1, 2025</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">Book ticket</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:group -->",
		)
		);


		register_block_pattern(
		'tc/testimonial-1',
		array(
			'title'       => __( 'Text on the left with testimonials on the right side', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-testimonial' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:heading {\"level\":3,\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4rem\"}}},\"fontSize\":\"gigantic\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-gigantic-font-size\" style=\"padding-bottom:4rem\">Testimonials</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"33.33%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"3rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:3rem;flex-basis:33.33%\"><!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\" style=\"padding-bottom:1rem\">What Members<br>Are Saying</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph -->\r\n<p>Join us at our upcoming events and experience the same level of inspiration and empowerment that our attendees rave about. Don't miss out on this opportunity to be a part of something extraordinary.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-buttons has-custom-font-size has-tiny-font-size\"><!-- wp:button {\"className\":\"is-style-outline\"} -->\r\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Buy ticket now</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"66.66%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:columns {\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"20%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:20%\"><!-- wp:image {\"align\":\"left\",\"id\":3307,\"width\":\"64px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100px\"}}} -->\r\n<figure class=\"wp-block-image alignleft size-full is-resized has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Ellipse-51-1.png\" alt=\"\" class=\"wp-image-3307\" style=\"border-radius:100px;width:64px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\",\"margin\":{\"bottom\":\"0\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-group\" style=\"margin-bottom:0\"><!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|10\",\"top\":\"var:preset|spacing|10\"},\"margin\":{\"top\":\"var:preset|spacing|10\"}},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\"} -->\r\n<h4 class=\"wp-block-heading has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--10);padding-top:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);font-style:normal;font-weight:600\">The event was absolutely amazing! Speakers were top-notch, and I left feeling inspired and motivated. It was a fantastic experience!</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":5,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0\"}}},\"fontSize\":\"small\"} -->\r\n<h5 class=\"wp-block-heading has-small-font-size\" style=\"margin-bottom:0\">John Smith</h5>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|10\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--10)\">Managing Director</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#0000001f\"},\"spacing\":{\"margin\":{\"top\":\"3rem\",\"bottom\":\"3rem\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:3rem;margin-bottom:3rem;background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:columns {\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"20%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:20%\"><!-- wp:image {\"align\":\"left\",\"id\":3309,\"width\":\"64px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100px\"}}} -->\r\n<figure class=\"wp-block-image alignleft size-full is-resized has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Mask-group-36.png\" alt=\"\" class=\"wp-image-3309\" style=\"border-radius:100px;width:64px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|10\"},\"margin\":{\"top\":\"var:preset|spacing|10\"}},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\"} -->\r\n<h4 class=\"wp-block-heading has-medium-font-size\" style=\"margin-top:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);font-style:normal;font-weight:600\">I loved every moment of the event! The speakers were incredible and I gained valuable insights. It was a truly empowering experience!</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":5,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0\"}}},\"fontSize\":\"small\"} -->\r\n<h5 class=\"wp-block-heading has-small-font-size\" style=\"margin-bottom:0\">Karen Lee</h5>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|10\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--10)\">Tech Innovator and Entrepreneur</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);
		register_block_pattern(
		'tc/testimonial-2',
		array(
			'title'       => __( 'Large title with a 2 columns of testimonials', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-testimonial' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#1c1c24\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"textColor\":\"background\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-background-color has-text-color has-background\" style=\"background-color:#1c1c24;padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:heading {\"level\":3,\"align\":\"wide\",\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-text-color has-small-font-size\" style=\"color:#6635f4\">What People Are Saying</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\"}}},\"fontSize\":\"hugee\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-hugee-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--50)\">Testimonials</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#ffffff1f\"}}} -->\r\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#ffffff1f;color:#ffffff1f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"},\"padding\":{\"top\":\"2rem\"}}}} -->\r\n<div class=\"wp-block-columns alignwide\" style=\"padding-top:2rem\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:2rem\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:1rem\"><!-- wp:image {\"id\":3307,\"width\":\"64px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100%\"}}} -->\r\n<figure class=\"wp-block-image size-full is-resized has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Ellipse-51-1.png\" alt=\"\" class=\"wp-image-3307\" style=\"border-radius:100%;width:64px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0.2rem\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">John Smith</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Managing Director</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"level\":5,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\"} -->\r\n<h5 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:600\">The event was absolutely amazing! The speakers were top-notch, and I left feeling inspired and motivated. It was a fantastic experience!</h5>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:1rem\"><!-- wp:image {\"id\":3309,\"width\":\"64px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100%\"}}} -->\r\n<figure class=\"wp-block-image size-full is-resized has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Mask-group-36.png\" alt=\"\" class=\"wp-image-3309\" style=\"border-radius:100%;width:64px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0.2rem\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Sarah Johnson</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Creative Director</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"level\":5,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"medium\"} -->\r\n<h5 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:600\">I loved every moment of the event! The speakers were incredible and I gained valuable insights. It was a truly empowering experience!</h5>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/testimonial-3',
		array(
			'title'       => __( 'Large title with button and 3 columns of testimonials', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-testimonial' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:columns {\"verticalAlignment\":\"bottom\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"10%\"},\"padding\":{\"bottom\":\"4rem\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-bottom stack-on-tablet-portrait\" style=\"padding-bottom:4rem\"><!-- wp:column {\"verticalAlignment\":\"bottom\",\"width\":\"66.6%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-bottom\" style=\"flex-basis:66.6%\"><!-- wp:heading {\"level\":4,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-color has-small-font-size\" style=\"color:#6635f4\">Testimonials</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"fontSize\":\"hugee\"} -->\r\n<h3 class=\"wp-block-heading has-hugee-font-size\">What Members<br>Are Saying</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"bottom\",\"width\":\"33.3%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-bottom\" style=\"flex-basis:33.3%\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}}} -->\r\n<p style=\"padding-bottom:1rem\">Don't miss out on this opportunity to be a part of something extraordinary.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy ticket now</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"align\":\"wide\",\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait\"><!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"border\":{\"radius\":\"6px\",\"color\":\"#0000001f\",\"width\":\"1px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-border-color\" style=\"border-color:#0000001f;border-width:1px;border-radius:6px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:1rem\"><!-- wp:image {\"id\":3307,\"width\":\"64px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100%\"}}} -->\r\n<figure class=\"wp-block-image size-full is-resized has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Ellipse-51-1.png\" alt=\"\" class=\"wp-image-3307\" style=\"border-radius:100%;width:64px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0.2rem\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">John Smith</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Managing Director</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"level\":5,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"small\"} -->\r\n<h5 class=\"wp-block-heading has-small-font-size\" style=\"font-style:normal;font-weight:600\">\"The event was absolutely amazing! The speakers were top-notch, and I left feeling inspired and motivated. It was a fantastic experience!\"</h5>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"border\":{\"radius\":\"6px\",\"color\":\"#0000001f\",\"width\":\"1px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-border-color\" style=\"border-color:#0000001f;border-width:1px;border-radius:6px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:1rem\"><!-- wp:image {\"id\":3308,\"width\":\"64px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100%\"}}} -->\r\n<figure class=\"wp-block-image size-full is-resized has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Mask-Group-35.png\" alt=\"\" class=\"wp-image-3308\" style=\"border-radius:100%;width:64px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0.2rem\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Sarah Johnson</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Creative Director</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"level\":5,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"small\"} -->\r\n<h5 class=\"wp-block-heading has-small-font-size\" style=\"font-style:normal;font-weight:600\">\"I loved every moment of the event! The speakers were incredible and I gained valuable insights. It was a truly empowering experience!\"</h5>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column -->\r\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"border\":{\"radius\":\"6px\",\"color\":\"#0000001f\",\"width\":\"1px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group has-border-color\" style=\"border-color:#0000001f;border-width:1px;border-radius:6px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"1rem\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:1rem\"><!-- wp:image {\"id\":3309,\"width\":\"64px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100%\"}}} -->\r\n<figure class=\"wp-block-image size-full is-resized has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Mask-group-36.png\" alt=\"\" class=\"wp-image-3309\" style=\"border-radius:100%;width:64px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0.2rem\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-small-font-size\">Karen Lee</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Tech Innovator</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"style\":{\"color\":{}}} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1085,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_half_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1085\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"level\":5,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}},\"fontSize\":\"small\"} -->\r\n<h5 class=\"wp-block-heading has-small-font-size\" style=\"font-style:normal;font-weight:600\">I loved every moment of the event! The lineup of speakers, especially Karen Lee, was incredible. I gained valuable insights and felt truly empowered.</h5>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/testimonial-4',
		array(
			'title'       => __( 'Large image on the left and a testimonial on the right', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-testimonial' ),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:media-text {\"align\":\"full\",\"mediaId\":1070,\"mediaLink\":\"https://themetick.com/patterns/testimonials/testimonials-single/\",\"mediaType\":\"image\",\"mediaWidth\":45,\"mediaSizeSlug\":\"full\",\"imageFill\":true,\"style\":{\"color\":{\"background\":\"#6635f4\"}},\"textColor\":\"background\"} -->\r\n<div class=\"wp-block-media-text alignfull is-stacked-on-mobile is-image-fill has-background-color has-text-color has-background\" style=\"background-color:#6635f4;grid-template-columns:45% auto\"><figure class=\"wp-block-media-text__media\" style=\"background-image:url(https://themetick.com/wp-content/uploads/2023/08/testimonials-single.jpg);background-position:50% 50%\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/testimonials-single.jpg\" alt=\"\" class=\"wp-image-1070 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\",\"right\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|50\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--50)\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:var(--wp--preset--spacing--50)\"><!-- wp:heading {\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-large-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--20)\">Sarah Johnson</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0.2rem\"}}}} -->\r\n<p style=\"margin-top:0.2rem\">Tech Innovator</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\" style=\"margin-bottom:0\"><!-- wp:image {\"id\":1061,\"width\":\"69px\",\"height\":\"69px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":{\"duotone\":[\"rgb(254, 254, 254)\",\"#CCC\"]}}} -->\r\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/format_quote_FILL1_wght400_GRAD0_opsz48.svg\" alt=\"\" class=\"wp-image-1061\" style=\"width:69px;height:69px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|70\",\"top\":\"0\"},\"margin\":{\"top\":\"0\"}}}} -->\r\n<div class=\"wp-block-columns\" style=\"margin-top:0;padding-top:0;padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":\"1.5\"}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"line-height:1.5\">Attending this electronic music event was an absolute blast! The energy on the dance floor was electric, and the DJs delivered an unforgettable experience.<br><br>I danced the night away and connected with like-minded music enthusiasts. It was an immersive and thrilling event that I can't wait to relive again!\"</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#ffffff1f\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#ffffff1f;color:#ffffff1f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\">Don't miss out on this opportunity<br>to be a part of something extraordinary.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Buy ticket now</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group --></div></div>\r\n<!-- /wp:media-text --></div>\r\n<!-- /wp:group -->",
		)
		);

		register_block_pattern(
		'tc/testimonial-5',
		array(
			'title'       => __( 'Large centered single testimonial', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-testimonial' ),
			'content'     => "<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:separator {\"style\":{\"color\":{\"background\":\"#0000001f\"},\"spacing\":{\"margin\":{\"top\":\"3rem\",\"bottom\":\"3rem\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:3rem;margin-bottom:3rem;background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"200px\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":1082,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/08/star_FILL1_wght100_GRAD0_opsz24.svg\" alt=\"\" class=\"wp-image-1082\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"style\":{\"spacing\":{\"padding\":{\"right\":\"5%\",\"left\":\"5%\"}}},\"fontSize\":\"large\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-center has-large-font-size\" style=\"padding-right:5%;padding-left:5%\">\"The event was absolutely amazing! The speakers were top-notch, and I left feeling inspired and motivated. It was a fantastic experience!\"</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":3307,\"width\":\"64px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100px\"}}} -->\r\n<figure class=\"wp-block-image size-full is-resized has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Ellipse-51-1.png\" alt=\"\" class=\"wp-image-3307\" style=\"border-radius:100px;width:64px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:paragraph -->\r\n<p><strong>John Smith </strong>- Managing Director</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
		)
		);

			register_block_pattern(
				'tc/call-to-action-1',
				array(
					'title'       => __( 'Tickets call to action middle aligned', 'harmonix' ),
					'viewportWidth' => 1680,
					'categories' => array( 'tc-call-to-action' ),
					'content'     => "<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"1000px\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}}} -->\r\n<h3 class=\"wp-block-heading has-text-align-center\" style=\"padding-bottom:var(--wp--preset--spacing--30)\">Early Bird Tickets Available!</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"380px\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:separator {\"backgroundColor\":\"secondary\"} -->\r\n<hr class=\"wp-block-separator has-text-color has-secondary-color has-alpha-channel-opacity has-secondary-background-color has-background\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}}} -->\r\n<p class=\"has-text-align-center\" style=\"padding-bottom:var(--wp--preset--spacing--30)\">A creative gathering that centers around community and unforgettable experiences.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"radius\":\"100px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"}}},\"fontSize\":\"small-m\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-small-m-font-size\"><a class=\"wp-block-button__link wp-element-button\" style=\"border-radius:100px;padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30)\">Get Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"center\",\"fontSize\":\"small\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-center has-small-font-size\"><a href=\"#\">View Con. Agenda</a></h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
				)
			);

		register_block_pattern(
			'tc/call-to-action-2',
			array(
				'title'       => __( 'Tickets call to action middle aligned with background', 'harmonix' ),
				'viewportWidth' => 1680,
				'categories' => array( 'tc-call-to-action' ),
				'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/08/cta-bg-big.jpg\",\"id\":1635,\"dimRatio\":50,\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-cover alignfull\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-1635\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/08/cta-bg-big.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"1000px\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|10\"}}},\"fontSize\":\"small\"} -->\r\n<h4 class=\"wp-block-heading has-text-align-center has-small-font-size\" style=\"margin-bottom:var(--wp--preset--spacing--10)\">TECH CON 2025</h4>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"},\"margin\":{\"top\":\"var:preset|spacing|20\"}}}} -->\r\n<h3 class=\"wp-block-heading has-text-align-center\" style=\"margin-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--30)\">Book your Seat</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"380px\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:separator {\"style\":{\"color\":{\"background\":\"#ffffff57\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#ffffff57;color:#ffffff57\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}}} -->\r\n<p class=\"has-text-align-center\" style=\"padding-bottom:var(--wp--preset--spacing--30)\">A creative gathering that centers around community and unforgettable experiences.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"style\":{\"border\":{\"radius\":\"100px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"}}},\"fontSize\":\"small-m\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-small-m-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\" style=\"border-radius:100px;padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30)\">Get Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"},\":hover\":{\"color\":{\"text\":\"#6635f4\"}}}}},\"textColor\":\"background\",\"fontSize\":\"small\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-center has-background-color has-text-color has-link-color has-small-font-size\"><a href=\"#\">View Con. Agenda</a></h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:group -->",
			)
			);

		register_block_pattern(
			'tc/call-to-action-3',
			array(
			'title'       => __( 'Tickets call to action with text on the left', 'harmonix' ),
			'viewportWidth' => 1680,
			'categories' => array( 'tc-call-to-action' ),
			'content'     => "<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-top:0;padding-bottom:0\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}},\"border\":{\"top\":{\"color\":\"#0000001c\",\"width\":\"1px\"},\"right\":{},\"bottom\":{\"color\":\"#0000001c\",\"width\":\"1px\"},\"left\":{}}}} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\" style=\"border-top-color:#0000001c;border-top-width:1px;border-bottom-color:#0000001c;border-bottom-width:1px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);flex-basis:66.66%\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}}} -->\r\n<h3 class=\"wp-block-heading\" style=\"padding-bottom:var(--wp--preset--spacing--30)\">Reserve Your Place at the Event</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"60%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:paragraph -->\r\n<p>A creative gathering that centers around community and unforgettable experiences.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"33.33%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|50\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);flex-basis:33.33%\"><!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"radius\":\"100px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"}}},\"fontSize\":\"small-m\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-small-m-font-size\"><a class=\"wp-block-button__link wp-element-button\" style=\"border-radius:100px;padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30)\">Get Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"center\",\"fontSize\":\"small\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-center has-small-font-size\"><a href=\"#\">View Con. Agenda</a></h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
			)
		);

		register_block_pattern(
			'tc/call-to-action-4',
			array(
				'title'       => __( 'Tickets call to action with text on the left with background', 'harmonix' ),
				'viewportWidth' => 1680,
				'categories' => array( 'tc-call-to-action' ),
				'content'     => "<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/08/cta-bg-1-scaled.jpg\",\"id\":1622,\"dimRatio\":50,\"align\":\"wide\",\"className\":\"has-rounded-edges\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-cover alignwide has-rounded-edges\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-1622\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/08/cta-bg-1-scaled.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center stack-on-tablet-portrait\" style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\",\"top\":\"var:preset|spacing|50\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);flex-basis:66.66%\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"90%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:90%\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}}} -->\r\n<h3 class=\"wp-block-heading\" style=\"padding-bottom:var(--wp--preset--spacing--30)\">Grab Your Early Bird Tickets Now!</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"50%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:paragraph -->\r\n<p>A creative gathering that centers around community and unforgettable experiences.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"33.33%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\",\"top\":\"var:preset|spacing|50\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);flex-basis:33.33%\"><!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"style\":{\"border\":{\"radius\":\"100px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"}}},\"fontSize\":\"small-m\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-small-m-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\" style=\"border-radius:100px;padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30)\">Get Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"},\":hover\":{\"color\":{\"text\":\"#6635f4\"}}}}},\"fontSize\":\"small\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-center has-link-color has-small-font-size\"><a href=\"#\">View Con. Agenda</a></h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:group -->",
			)
			);


			register_block_pattern(
			'tc/call-to-action-5',
			array(
				'title'       => __( 'Tickets call to action with purple background', 'harmonix' ),
				'viewportWidth' => 1680,
				'categories' => array( 'tc-call-to-action' ),
				'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\"}},\"color\":{\"background\":\"#6635f4\"}},\"textColor\":\"background\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-background-color has-text-color has-background\" style=\"background-color:#6635f4;padding-top:0;padding-bottom:0\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}}}} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\" style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\",\"top\":\"var:preset|spacing|50\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);flex-basis:66.66%\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"100%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:100%\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}},\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-big-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--30)\">Secure Your Spot Today</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"60%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:paragraph -->\r\n<p>A creative gathering that centers around community and unforgettable experiences.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"},\":hover\":{\"color\":{\"text\":\"var:preset|color|foreground\"}}}}},\"textColor\":\"background\",\"fontSize\":\"small\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-left has-background-color has-text-color has-link-color has-small-font-size\"><a href=\"#\">View Con. Agenda</a></h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"33.33%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\",\"top\":\"var:preset|spacing|50\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);flex-basis:33.33%\"><!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"style\":{\"border\":{\"radius\":\"100px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"}}},\"fontSize\":\"small-m\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-small-m-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\" style=\"border-radius:100px;padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30)\">Get Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
			)
			);


			register_block_pattern(
			'tc/call-to-action-6',
			array(
				'title'       => __( 'Tickets call to action with a text on the left', 'harmonix' ),
				'viewportWidth' => 1680,
				'categories' => array( 'tc-call-to-action' ),
				'content'     => "<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}},\"border\":{\"top\":{\"color\":\"#0000001c\",\"width\":\"1px\"},\"right\":{},\"bottom\":{\"style\":\"none\",\"width\":\"0px\"},\"left\":{}}}} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\" style=\"border-top-color:#0000001c;border-top-width:1px;border-bottom-style:none;border-bottom-width:0px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-bottom:var(--wp--preset--spacing--50);flex-basis:66.66%\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"100%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:100%\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}}} -->\r\n<h3 class=\"wp-block-heading\" style=\"padding-bottom:var(--wp--preset--spacing--30)\">Early Bird Tickets Available!</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"60%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:paragraph -->\r\n<p>A creative gathering that centers around community and unforgettable experiences.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"left\",\"fontSize\":\"small\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-left has-small-font-size\"><a href=\"#\">View Con. Agenda</a></h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"33.33%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-bottom:var(--wp--preset--spacing--50);flex-basis:33.33%\"><!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"radius\":\"100px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"}}},\"fontSize\":\"small-m\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-small-m-font-size\"><a class=\"wp-block-button__link wp-element-button\" style=\"border-radius:100px;padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30)\">Get Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
			)
			);

		register_block_pattern(
			'tc/call-to-action-7',
			array(
				'title'       => __( 'Left aligned call to action with large background', 'harmonix' ),
				'viewportWidth' => 1680,
				'categories' => array( 'tc-call-to-action' ),
				'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:0;padding-bottom:0\"><!-- wp:cover {\"url\":\"https://themetick.com/wp-content/uploads/2023/08/cta-bg-big-col.jpg\",\"id\":1638,\"dimRatio\":50,\"minHeight\":100,\"minHeightUnit\":\"vh\",\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-cover alignfull\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70);min-height:100vh\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-1638\" alt=\"\" src=\"https://themetick.com/wp-content/uploads/2023/08/cta-bg-big-col.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|50\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center stack-on-tablet-portrait\" style=\"padding-top:var(--wp--preset--spacing--50)\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"100%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:100%\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"65%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:65%\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}},\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-big-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--30)\">Secure Your Spot Today and Be Part of the Experience</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"40%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|60\"}}}} -->\r\n<div class=\"wp-block-column\" style=\"padding-bottom:var(--wp--preset--spacing--60);flex-basis:40%\"><!-- wp:paragraph -->\r\n<p>A creative gathering that centers around community and unforgettable experiences.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"style\":{\"border\":{\"radius\":\"100px\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"}}},\"fontSize\":\"small-m\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-small-m-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\" style=\"border-radius:100px;padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30)\">Get Tickets</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"},\":hover\":{\"color\":{\"text\":\"#6635f4\"}}}}},\"fontSize\":\"small\"} -->\r\n<h2 class=\"wp-block-heading has-text-align-left has-link-color has-small-font-size\"><a href=\"#\">View Con. Agenda</a></h2>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group --></div></div>\r\n<!-- /wp:cover --></div>\r\n<!-- /wp:group -->",
			)
			);

	register_block_pattern(
	'tc/tc-sponsors-1',
	array(
		'title'       => __( 'Call to action with list of sponsors', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-sponsors' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|70\"},\"padding\":{\"bottom\":\"0\"}}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top stack-on-tablet-portrait\" style=\"padding-bottom:0\"><!-- wp:column {\"verticalAlignment\":\"top\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\"><!-- wp:heading {\"level\":4,\"fontSize\":\"gigantic\"} -->\r\n<h4 class=\"wp-block-heading has-gigantic-font-size\">Partners</h4>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"top\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:80%\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}}} -->\r\n<p style=\"padding-bottom:var(--wp--preset--spacing--20)\">We're proud to partner with some of the best companies in the industry to bring you an unforgettable festival experience. Our partners share our commitment to excellence and help us provide top-quality services and amenities to our attendees.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-outline\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-outline has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Become an Official Partner</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:heading {\"level\":5,\"align\":\"wide\",\"fontSize\":\"small\"} -->\r\n<h5 class=\"wp-block-heading alignwide has-small-font-size\">Gold Partner</h5>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#0000001f\"},\"spacing\":{\"margin\":{\"bottom\":\"2rem\"}}}} -->\r\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background\" style=\"margin-bottom:2rem;background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"4em\",\"padding\":{\"bottom\":\"4rem\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"verticalAlignment\":\"center\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-bottom:4rem\"><!-- wp:image {\"id\":3348,\"width\":\"263px\",\"height\":\"65px\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/themetick.svg\" alt=\"\" class=\"wp-image-3348\" style=\"width:263px;height:65px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3349,\"width\":\"206px\",\"height\":\"35px\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/tickera.svg\" alt=\"\" class=\"wp-image-3349\" style=\"width:206px;height:35px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:heading {\"level\":5,\"align\":\"wide\",\"fontSize\":\"small\"} -->\r\n<h5 class=\"wp-block-heading alignwide has-small-font-size\">Silver Partner</h5>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#0000001f\"},\"spacing\":{\"margin\":{\"bottom\":\"2rem\"}}}} -->\r\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background\" style=\"margin-bottom:2rem;background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"4rem\",\"padding\":{\"bottom\":\"1rem\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-bottom:1rem\"><!-- wp:image {\"id\":3350,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Coastal.svg\" alt=\"\" class=\"wp-image-3350\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3351,\"width\":\"104px\",\"height\":\"auto\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/oo.svg\" alt=\"\" class=\"wp-image-3351\" style=\"width:104px;height:auto\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3352,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Urban.svg\" alt=\"\" class=\"wp-image-3352\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3353,\"width\":\"264px\",\"height\":\"auto\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/zenith.svg\" alt=\"\" class=\"wp-image-3353\" style=\"width:264px;height:auto\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3354,\"width\":\"124px\",\"height\":\"auto\",\"aspectRatio\":\"1.8043478260869565\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Omni.svg\" alt=\"\" class=\"wp-image-3354\" style=\"aspect-ratio:1.8043478260869565;width:124px;height:auto\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3358,\"width\":\"192px\",\"height\":\"auto\",\"aspectRatio\":\"1.8043478260869565\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/crystal.svg\" alt=\"\" class=\"wp-image-3358\" style=\"aspect-ratio:1.8043478260869565;width:192px;height:auto\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
	)
);

	register_block_pattern(
	'tc/tc-sponsors-2',
	array(
		'title'       => __( 'Call to action with list of sponsors on the right side', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-sponsors' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#1c1c24\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-background\" style=\"background-color:#1c1c24;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":{\"top\":\"0\",\"left\":\"var:preset|spacing|70\"}},\"color\":{\"background\":\"#1c1c24\"}},\"className\":\"stack-on-tablet-portrait\"} -->\r\n<div class=\"wp-block-columns alignwide stack-on-tablet-portrait has-background\" style=\"background-color:#1c1c24;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column {\"width\":\"45%\",\"textColor\":\"background\"} -->\r\n<div class=\"wp-block-column has-background-color has-text-color\" style=\"flex-basis:45%\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:heading {\"textColor\":\"background\",\"fontSize\":\"small\"} -->\r\n<h2 class=\"wp-block-heading has-background-color has-text-color has-small-font-size\">Event 2026</h2>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"fontSize\":\"hugee\"} -->\r\n<h3 class=\"wp-block-heading has-hugee-font-size\">Partners</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"2rem\"}}}} -->\r\n<p style=\"padding-bottom:2rem\">We're proud to partner with some of the best companies in the industry to bring you an unforgettable festival experience.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"className\":\"is-style-fill\",\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size is-style-fill has-tiny-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\">Become an Official Partner</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"60%\",\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-bottom:var(--wp--preset--spacing--40);flex-basis:60%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8%\",\"padding\":{\"right\":\"2rem\",\"left\":\"2rem\",\"bottom\":\"0.5rem\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-right:2rem;padding-bottom:0.5rem;padding-left:2rem\"><!-- wp:image {\"id\":3348,\"width\":\"224px\",\"height\":\"55px\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"style\":{\"color\":{\"duotone\":[\"rgb(255, 255, 255)\",\"rgb(0, 0, 0)\"]}}} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/themetick.svg\" alt=\"\" class=\"wp-image-3348\" style=\"width:224px;height:55px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3351,\"width\":\"151px\",\"height\":\"auto\",\"aspectRatio\":\"3.3125\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"style\":{\"color\":{\"duotone\":[\"rgb(255, 255, 255)\",\"#CCC\"]}}} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/oo.svg\" alt=\"\" class=\"wp-image-3351\" style=\"aspect-ratio:3.3125;width:151px;height:auto\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3352,\"width\":\"126px\",\"height\":\"auto\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"style\":{\"color\":{\"duotone\":[\"rgb(255, 255, 255)\",\"rgb(255, 255, 255)\"]}}} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Urban.svg\" alt=\"\" class=\"wp-image-3352\" style=\"width:126px;height:auto\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8%\",\"padding\":{\"right\":\"2rem\",\"left\":\"2rem\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-right:2rem;padding-left:2rem\"><!-- wp:image {\"id\":3354,\"width\":\"127px\",\"height\":\"auto\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"style\":{\"color\":{\"duotone\":[\"rgb(255, 255, 255)\",\"#CCC\"]}}} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Omni.svg\" alt=\"\" class=\"wp-image-3354\" style=\"width:127px;height:auto\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3355,\"width\":\"221px\",\"height\":\"auto\",\"aspectRatio\":\"6.090909090909091\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"style\":{\"color\":{\"duotone\":[\"rgb(255, 255, 255)\",\"#CCC\"]}}} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/mediaco.svg\" alt=\"\" class=\"wp-image-3355\" style=\"aspect-ratio:6.090909090909091;width:221px;height:auto\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3350,\"width\":\"158px\",\"height\":\"auto\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"style\":{\"color\":{\"duotone\":[\"rgb(255, 255, 255)\",\"#CCC\"]}}} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Coastal.svg\" alt=\"\" class=\"wp-image-3350\" style=\"width:158px;height:auto\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
	)
	);

register_block_pattern(
'tc/tc-sponsors-3',
array(
	'title'       => __( 'Centered sponsors', 'harmonix' ),
	'viewportWidth' => 1680,
	'categories' => array( 'tc-sponsors' ),
	'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull\" style=\"padding-top:6rem;padding-bottom:6rem\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-center has-text-color has-small-font-size\" style=\"color:#6635f4\">Event Sponsoris</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"400px\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\"} -->\r\n<p class=\"has-text-align-center\">A heartfelt thank you to all our sponsors for their invaluable support.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"3rem\",\"padding\":{\"bottom\":\"1rem\",\"top\":\"3rem\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-top:3rem;padding-bottom:1rem\"><!-- wp:image {\"id\":3348,\"width\":\"188px\",\"height\":\"47px\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/themetick.svg\" alt=\"\" class=\"wp-image-3348\" style=\"width:188px;height:47px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3358,\"width\":\"215px\",\"height\":\"auto\",\"aspectRatio\":\"6.162162162162162\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/crystal.svg\" alt=\"\" class=\"wp-image-3358\" style=\"aspect-ratio:6.162162162162162;width:215px;height:auto\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3355,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/mediaco.svg\" alt=\"\" class=\"wp-image-3355\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3359,\"width\":\"157px\",\"height\":\"auto\",\"aspectRatio\":\"5.147058823529412\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Terra.svg\" alt=\"\" class=\"wp-image-3359\" style=\"aspect-ratio:5.147058823529412;width:157px;height:auto\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3360,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/nn.svg\" alt=\"\" class=\"wp-image-3360\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3349,\"width\":\"158px\",\"height\":\"auto\",\"aspectRatio\":\"1.8043478260869565\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/tickera.svg\" alt=\"\" class=\"wp-image-3349\" style=\"aspect-ratio:1.8043478260869565;width:158px;height:auto\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
)
	);

register_block_pattern(
	'tc/tc-sponsors-4',
	array(
	'title'       => __( 'Centered sponsors with large title', 'harmonix' ),
	'viewportWidth' => 1680,
	'categories' => array( 'tc-sponsors' ),
	'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"6rem\",\"bottom\":\"6rem\"}},\"color\":{\"background\":\"#eaeaea\"}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-background\" style=\"background-color:#eaeaea;padding-top:6rem;padding-bottom:6rem\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"color\":{\"text\":\"#6635f4\"}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-center has-text-color has-small-font-size\" style=\"color:#6635f4\">Event 2026</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading has-text-align-center has-big-font-size\">Our Event Sponsors</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"3rem\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"500px\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:3rem\"><!-- wp:paragraph {\"align\":\"center\"} -->\r\n<p class=\"has-text-align-center\">We're proud to partner with some of the best companies in the industry to bring you an unforgettable festival experience.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#0000001f\"},\"spacing\":{\"margin\":{\"top\":\"3rem\",\"bottom\":\"3rem\"}}}} -->\r\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:3rem;margin-bottom:3rem;background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"1.5em\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-group alignwide\"><!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"2.9rem\",\"padding\":{\"bottom\":\"1rem\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-bottom:1rem\"><!-- wp:image {\"id\":3348,\"width\":\"208px\",\"height\":\"52px\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/themetick.svg\" alt=\"\" class=\"wp-image-3348\" style=\"width:208px;height:52px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3355,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/mediaco.svg\" alt=\"\" class=\"wp-image-3355\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3358,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/crystal.svg\" alt=\"\" class=\"wp-image-3358\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3359,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Terra.svg\" alt=\"\" class=\"wp-image-3359\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3360,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/nn.svg\" alt=\"\" class=\"wp-image-3360\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3350,\"width\":\"147px\",\"height\":\"auto\",\"aspectRatio\":\"1.8043478260869565\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Coastal.svg\" alt=\"\" class=\"wp-image-3350\" style=\"aspect-ratio:1.8043478260869565;width:147px;height:auto\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"3rem\",\"padding\":{\"top\":\"0\",\"bottom\":\"0\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"margin-top:0;margin-bottom:0;padding-top:0;padding-bottom:0\"><!-- wp:image {\"id\":3351,\"width\":\"171px\",\"height\":\"39px\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/oo.svg\" alt=\"\" class=\"wp-image-3351\" style=\"width:171px;height:39px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3352,\"width\":\"129px\",\"height\":\"39px\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Urban.svg\" alt=\"\" class=\"wp-image-3352\" style=\"width:129px;height:39px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3353,\"width\":\"228px\",\"height\":\"37px\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/zenith.svg\" alt=\"\" class=\"wp-image-3353\" style=\"width:228px;height:37px\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3354,\"width\":\"147px\",\"height\":\"auto\",\"aspectRatio\":\"4.466666666666667\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Omni.svg\" alt=\"\" class=\"wp-image-3354\" style=\"aspect-ratio:4.466666666666667;width:147px;height:auto\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:image {\"id\":3349,\"width\":\"185px\",\"height\":\"auto\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-large is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/tickera.svg\" alt=\"\" class=\"wp-image-3349\" style=\"width:185px;height:auto\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#0000001f\"},\"spacing\":{\"margin\":{\"top\":\"4rem\",\"bottom\":\"3rem\"}}}} -->\r\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:4rem;margin-bottom:3rem;background-color:#0000001f;color:#0000001f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"},\"style\":{\"spacing\":{\"margin\":{\"top\":\"4rem\"}}}} -->\r\n<div class=\"wp-block-buttons\" style=\"margin-top:4rem\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Become a sponsor</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"500px\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-text-align-center has-tiny-font-size\">Join our network of esteemed sponsors and help us create an unforgettable festival experience.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
	)
);

register_block_pattern(
'tc/tc-schedule-1',
array(
	'title'       => __( 'Itinerary with images on the left and text on the right', 'harmonix' ),
	'viewportWidth' => 1680,
	'categories' => array( 'tc-schedule' ),
	'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"textColor\":\"foreground\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-foreground-color has-text-color\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\r\n<div class=\"wp-block-group alignwide\" style=\"padding-right:0;padding-left:0\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.2em\",\"textTransform\":\"uppercase\"},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" id=\"Agenda\" style=\"padding-bottom:var(--wp--preset--spacing--20);font-style:normal;font-weight:600;letter-spacing:0.2em;text-transform:uppercase\">Agenda</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"className\":\"stack-on-tablet-portrait \"} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center stack-on-tablet-portrait\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"45%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:45%\"><!-- wp:heading {\"level\":3,\"align\":\"wide\",\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-big-font-size\" style=\"font-style:normal;font-weight:700;text-transform:none\">Program and <br>Itinerary</h3>\r\n<!-- /wp:heading --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|40\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\",\"contentSize\":\"400px\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\">Discover the Event's Extensive Program and Detailed Agenda to Plan Your Experience</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"typography\":{\"textTransform\":\"none\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"}},\"border\":{\"radius\":\"100px\"}},\"className\":\"is-style-fill\"} -->\r\n<div class=\"wp-block-button is-style-fill\" style=\"text-transform:none\"><a class=\"wp-block-button__link wp-element-button\" style=\"border-radius:100px;padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30)\">Download Schedule</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:spacer {\"height\":\"40px\"} -->\r\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"default\"}} -->\r\n<div class=\"wp-block-group alignwide\"><!-- wp:separator {\"style\":{\"color\":{\"background\":\"#0000000f\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#0000000f;color:#0000000f\"/>\r\n<!-- /wp:separator -->\r\n\r\n<!-- wp:lightweight-accordion/lightweight-accordion {\"title\":\"17.April.2026 - Day 1\",\"title_text_color\":null,\"title_background_color\":null,\"accordion_open\":true} -->\r\n<!-- wp:spacer {\"height\":\"60px\"} -->\r\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|70\"}}},\"className\":\"stack-on-tablet-portrait \"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"33.33%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:image {\"id\":3382,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"4px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/agenda-p.jpg\" alt=\"\" class=\"wp-image-3382\" style=\"border-radius:4px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"66.66%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--20);font-style:normal;font-weight:600;letter-spacing:0.1em\">9:00 AM - 10:00 AM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700;text-transform:none\">Sustainable Innovation: Redefining Industry Standards</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"line-height:1.6\">Join us for this dynamic lecture by sustainability trailblazer, Dr. Elena Green. She will introduce you to the latest innovations in sustainable business practices, exploring how companies can transform their operations with innovative approaches. </p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"line-height:1.6\">Dr. Green's expertise will provide inspirational real-world examples and practical guidelines for implementing sustainable innovations across various sectors, contributing to the preservation of our planet.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:columns {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"54%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:54%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":3308,\"width\":\"64px\",\"height\":\"undefinedpx\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Mask-Group-35.png\" alt=\"\" class=\"wp-image-3308\" style=\"width:64px;height:undefinedpx\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0\"}}}} -->\r\n<p style=\"margin-bottom:0\">Dr. Elena Green</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:0\">Speaker - Entrepreneur</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Read bio</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|70\"},\"margin\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"className\":\"stack-on-tablet-portrait \"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\" style=\"margin-top:var(--wp--preset--spacing--70);margin-bottom:var(--wp--preset--spacing--70)\"><!-- wp:column {\"width\":\"33.33%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:image {\"id\":3383,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"4px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/agenda-y.jpg\" alt=\"\" class=\"wp-image-3383\" style=\"border-radius:4px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"66.66%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--20);font-style:normal;font-weight:600;letter-spacing:0.1em\">12:00 AM - 14:00 AM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700;text-transform:none\">Circular Economy: A Blueprint for Environmental Harmony</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"line-height:1.6\">n this pivotal lecture, Richard Green, a pioneer in the field of the circular economy, will guide you through the transformative journey from a linear to a circular model. Richard, an industry veteran, will share successful case studies and insights into how reusing, recycling, and reducing waste can create more sustainable business practices. </p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"line-height:1.6\">Join us to learn from Richard's wealth of experience and discover how your organization can become a leader in sustainable business practices.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:columns {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"54%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:54%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":255,\"width\":\"64px\",\"height\":\"undefinedpx\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://themetick.com/dimenix/wp-content/uploads/sites/17/2023/10/image-160.png\" alt=\"\" class=\"wp-image-255\" style=\"width:64px;height:undefinedpx\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0\"}}}} -->\r\n<p style=\"margin-bottom:0\">Richard Green</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:0\">Speaker - Entrepreneur</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Read bio</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n<!-- /wp:lightweight-accordion/lightweight-accordion -->\r\n\r\n<!-- wp:lightweight-accordion/lightweight-accordion {\"title\":\"18.April.2026 - Day 2\",\"title_text_color\":null,\"title_background_color\":null} -->\r\n<!-- wp:spacer {\"height\":\"60px\"} -->\r\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|70\"}}},\"className\":\"stack-on-tablet-portrait \"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\"><!-- wp:column {\"width\":\"33.33%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:image {\"id\":3384,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"4px\"}}} -->\r\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/agenda-g.jpg\" alt=\"\" class=\"wp-image-3384\" style=\"border-radius:4px\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"66.66%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--20);font-style:normal;font-weight:600;letter-spacing:0.1em\">9:00 AM - 10:00 AM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700;text-transform:none\">Eco-Entrepreneurship: Nurturing Green Business Growth</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"line-height:1.6\">mbark on a journey of eco-entrepreneurship with our distinguished speaker, Emma Reed. In this engaging lecture, Emma will delve into the principles and practices of building environmentally conscious businesses. Drawing from her extensive experience as a successful eco-entrepreneur, Emma will share strategies for fostering green business growth, emphasizing the importance of aligning profit with a positive impact on the planet. </p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"line-height:1.6\">Don't miss this opportunity to gain insights from Emma's entrepreneurial wisdom and contribute to the green business revolution.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:columns {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"54%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:54%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":259,\"width\":\"64px\",\"height\":\"undefinedpx\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://themetick.com/dimenix/wp-content/uploads/sites/17/2023/10/Mask-group-30.png\" alt=\"\" class=\"wp-image-259\" style=\"width:64px;height:undefinedpx\"/></figure>\r\n<!-- /wp:image -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0\"}}}} -->\r\n<p style=\"margin-bottom:0\">Emma Reed</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:0\">Speaker - Entrepreneur</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"fontSize\":\"tiny\"} -->\r\n<div class=\"wp-block-button has-custom-font-size has-tiny-font-size\"><a class=\"wp-block-button__link wp-element-button\">Read bio</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|70\"},\"margin\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"}}},\"className\":\"stack-on-tablet-portrait \"} -->\r\n<div class=\"wp-block-columns stack-on-tablet-portrait\" style=\"margin-top:var(--wp--preset--spacing--70);margin-bottom:var(--wp--preset--spacing--70)\"><!-- wp:column {\"width\":\"33.33%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"width\":\"66.66%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--20);font-style:normal;font-weight:600;letter-spacing:0.1em\">12:00 AM - 14:00 AM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\r\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700;text-transform:none\">Closing Remarks and Networking Session</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:columns -->\r\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\r\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-link-color has-small-font-size\" style=\"line-height:1.6\">Join us for the closing session of the conference, where we\u2019ll reflect on the valuable insights gained throughout the event. This is an excellent opportunity to connect with fellow attendees, speakers, and industry professionals. </p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"line-height:1.6\">Share your thoughts, exchange contact information, and continue building meaningful connections beyond the conference.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n<!-- /wp:lightweight-accordion/lightweight-accordion --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group -->",
)
	);


	register_block_pattern(
	'tc/tc-schedule-2',
	array(
		'title'       => __( 'Title and description on the left and schedule on the right', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-schedule' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}},\"color\":{\"background\":\"#f2f2f2\"}},\"textColor\":\"foreground\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-foreground-color has-text-color has-background\" style=\"background-color:#f2f2f2;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|60\"}}},\"className\":\"stack-on-tablet-portrait \"} -->\r\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top stack-on-tablet-portrait\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"40%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:40%\"><!-- wp:heading {\"level\":3,\"align\":\"wide\",\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|30\"}}},\"fontSize\":\"big\"} -->\r\n<h3 class=\"wp-block-heading alignwide has-big-font-size\" style=\"padding-bottom:var(--wp--preset--spacing--30);font-style:normal;font-weight:700;text-transform:none\">Schedule and Agenda</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|40\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\",\"contentSize\":\"400px\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\">Discover the Event's Extensive Program and Detailed Agenda to Plan Your Experience</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:buttons -->\r\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"typography\":{\"textTransform\":\"none\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"}},\"border\":{\"radius\":\"100px\"}},\"className\":\"is-style-fill\"} -->\r\n<div class=\"wp-block-button is-style-fill\" style=\"text-transform:none\"><a class=\"wp-block-button__link wp-element-button\" style=\"border-radius:100px;padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30)\">Download Schedule</a></div>\r\n<!-- /wp:button --></div>\r\n<!-- /wp:buttons --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-top\"><!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"default\"}} -->\r\n<div class=\"wp-block-group alignwide\"><!-- wp:lightweight-accordion/lightweight-accordion {\"title\":\"17.April.2026 - Day 1\",\"title_text_color\":null,\"title_background_color\":null,\"accordion_open\":true} -->\r\n<!-- wp:spacer {\"height\":\"20px\"} -->\r\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"0\"},\"margin\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--20);padding-bottom:0;font-style:normal;font-weight:600;letter-spacing:0.1em\">12:00 AM - 14:00 AM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small-l\"} -->\r\n<h3 class=\"wp-block-heading has-small-l-font-size\" style=\"margin-top:0;margin-bottom:0;font-style:normal;font-weight:700;text-transform:none\">Registration &amp; Coffee</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"line-height:1.6\">Please register your personal information at our customer service desk and enjoy a complimentary cup of coffee before entering the event room.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000014\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#00000014;color:#00000014\"/>\r\n<!-- /wp:separator --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--40)\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"0\"},\"margin\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--20);padding-bottom:0;font-style:normal;font-weight:600;letter-spacing:0.1em\">10:00 AM - 11:30 AM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small-l\"} -->\r\n<h3 class=\"wp-block-heading has-small-l-font-size\" style=\"margin-top:0;margin-bottom:0;font-style:normal;font-weight:700;text-transform:none\">Navigating the Digital Landscape: Strategies for Online Success</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"line-height:1.6\">Explore the dynamic digital landscape with Emily Turner. Gain practical strategies to navigate the complexities of online marketing, ensuring success in the ever-evolving digital realm.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"font-style:normal;font-weight:500\">Speaker: Emily Turner</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000014\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#00000014;color:#00000014\"/>\r\n<!-- /wp:separator --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"0\"},\"margin\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--20);padding-bottom:0;font-style:normal;font-weight:600;letter-spacing:0.1em\">11:30 AM - 12:00 PM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small-l\"} -->\r\n<h3 class=\"wp-block-heading has-small-l-font-size\" style=\"margin-top:0;margin-bottom:0;font-style:normal;font-weight:700;text-transform:none\">Q&amp;A Session</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000014\"},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:var(--wp--preset--spacing--40);background-color:#00000014;color:#00000014\"/>\r\n<!-- /wp:separator --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"0\"},\"margin\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--20);padding-bottom:0;font-style:normal;font-weight:600;letter-spacing:0.1em\">12:00 PM - 1:30 PM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small-l\"} -->\r\n<h3 class=\"wp-block-heading has-small-l-font-size\" style=\"margin-top:0;margin-bottom:0;font-style:normal;font-weight:700;text-transform:none\">Lunch Break and Networking</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000014\"},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:var(--wp--preset--spacing--40);background-color:#00000014;color:#00000014\"/>\r\n<!-- /wp:separator --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--40)\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"0\"},\"margin\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--20);padding-bottom:0;font-style:normal;font-weight:600;letter-spacing:0.1em\">1:30 PM - 3:00 PM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small-l\"} -->\r\n<h3 class=\"wp-block-heading has-small-l-font-size\" style=\"margin-top:0;margin-bottom:0;font-style:normal;font-weight:700;text-transform:none\">Content is King: Crafting Compelling Narratives in the Digital Age</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"line-height:1.6\">Join Dr. Marcus Harper on a fascinating journey into the psychology of storytelling in the digital age. Learn the art of crafting narratives that resonate, creating a lasting impact on your audience.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"font-style:normal;font-weight:500\">Speaker: Dr. Marcus Harper, PhD</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000014\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#00000014;color:#00000014\"/>\r\n<!-- /wp:separator --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"0\"},\"margin\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--20);padding-bottom:0;font-style:normal;font-weight:600;letter-spacing:0.1em\">11:30 AM - 12:00 PM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small-l\"} -->\r\n<h3 class=\"wp-block-heading has-small-l-font-size\" style=\"margin-top:0;margin-bottom:0;font-style:normal;font-weight:700;text-transform:none\">Q&amp;A Session</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:spacer {\"height\":\"50px\"} -->\r\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer --></div>\r\n<!-- /wp:group -->\r\n<!-- /wp:lightweight-accordion/lightweight-accordion -->\r\n\r\n<!-- wp:lightweight-accordion/lightweight-accordion {\"title\":\"18.April.2026 - Day 2\",\"title_text_color\":null,\"title_background_color\":null} -->\r\n<!-- wp:spacer {\"height\":\"60px\"} -->\r\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"0\"},\"margin\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--20);padding-bottom:0;font-style:normal;font-weight:600;letter-spacing:0.1em\"><strong>9:30 AM - 10:00 AM</strong></h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small-l\"} -->\r\n<h3 class=\"wp-block-heading has-small-l-font-size\" style=\"margin-top:0;margin-bottom:0;font-style:normal;font-weight:700;text-transform:none\">Registration and Networking</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000014\"},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:var(--wp--preset--spacing--40);background-color:#00000014;color:#00000014\"/>\r\n<!-- /wp:separator --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--40)\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"0\"},\"margin\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--20);padding-bottom:0;font-style:normal;font-weight:600;letter-spacing:0.1em\">10:00 AM - 11:30 AM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small-l\"} -->\r\n<h3 class=\"wp-block-heading has-small-l-font-size\" style=\"margin-top:0;margin-bottom:0;font-style:normal;font-weight:700;text-transform:none\">Immersive Experiences: The Future of Marketing Events</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"line-height:1.6\">Unlock the secrets of creating immersive brand experiences with Alex Rodriguez. Explore the future of marketing events and discover how to captivate your audience through memorable and unique experiences.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"font-style:normal;font-weight:500\">Speaker: Alex Rodriguez</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000014\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#00000014;color:#00000014\"/>\r\n<!-- /wp:separator --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"0\"},\"margin\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--20);padding-bottom:0;font-style:normal;font-weight:600;letter-spacing:0.1em\">11:30 AM - 12:00 PM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small-l\"} -->\r\n<h3 class=\"wp-block-heading has-small-l-font-size\" style=\"margin-top:0;margin-bottom:0;font-style:normal;font-weight:700;text-transform:none\">Q&amp;A Session</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000014\"},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:var(--wp--preset--spacing--40);background-color:#00000014;color:#00000014\"/>\r\n<!-- /wp:separator --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"0\"},\"margin\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--20);padding-bottom:0;font-style:normal;font-weight:600;letter-spacing:0.1em\">12:00 PM - 1:30 PM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small-l\"} -->\r\n<h3 class=\"wp-block-heading has-small-l-font-size\" style=\"margin-top:0;margin-bottom:0;font-style:normal;font-weight:700;text-transform:none\">Lunch Break and Networking</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000014\"},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:var(--wp--preset--spacing--40);background-color:#00000014;color:#00000014\"/>\r\n<!-- /wp:separator --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|40\"}}},\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--40)\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"0\"},\"margin\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--20);padding-bottom:0;font-style:normal;font-weight:600;letter-spacing:0.1em\"><strong>1:30 PM - 3:00 PM</strong></h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small-l\"} -->\r\n<h3 class=\"wp-block-heading has-small-l-font-size\" style=\"margin-top:0;margin-bottom:0;font-style:normal;font-weight:700;text-transform:none\">Influencer Marketing Unveiled: Strategies for Authentic Partnerships</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6}},\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\" style=\"line-height:1.6\">Dive into the world of influencer marketing with Sarah Chang. Learn the art of building authentic partnerships with influencers and discover strategies to seamlessly integrate influencer collaborations into your marketing mix.</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\"}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"font-style:normal;font-weight:500\">Speaker: Sarah Chang</p>\r\n<!-- /wp:paragraph -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000014\"}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"background-color:#00000014;color:#00000014\"/>\r\n<!-- /wp:separator --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"letterSpacing\":\"0.1em\"},\"spacing\":{\"padding\":{\"bottom\":\"0\"},\"margin\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"tiny\"} -->\r\n<h3 class=\"wp-block-heading has-tiny-font-size\" style=\"margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--20);padding-bottom:0;font-style:normal;font-weight:600;letter-spacing:0.1em\">11:30 AM - 12:00 PM</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"textTransform\":\"none\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"small-l\"} -->\r\n<h3 class=\"wp-block-heading has-small-l-font-size\" style=\"margin-top:0;margin-bottom:0;font-style:normal;font-weight:700;text-transform:none\">Q&amp;A Session</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000014\"},\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background\" style=\"margin-top:var(--wp--preset--spacing--40);background-color:#00000014;color:#00000014\"/>\r\n<!-- /wp:separator --></div>\r\n<!-- /wp:group -->\r\n<!-- /wp:lightweight-accordion/lightweight-accordion --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:group -->",
	)
);

	register_block_pattern(
	'tc/tc-schedule-3',
	array(
		'title'       => __( 'Lineup list', 'harmonix' ),
		'viewportWidth' => 1680,
		'categories' => array( 'tc-schedule' ),
		'content'     => "<!-- wp:group {\"align\":\"full\",\"style\":{\"background\":{\"backgroundImage\":{\"url\":\"https://themetick.com/wp-content/uploads/2023/11/agenda-hd-scaled.jpg\",\"id\":3391,\"source\":\"file\",\"title\":\"agenda-hd\"}},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"layout\":{\"type\":\"constrained\"}} -->\r\n<div class=\"wp-block-group alignfull has-background-color has-text-color has-link-color\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|50\"}}}} -->\r\n<h2 class=\"wp-block-heading has-text-align-center\" style=\"margin-bottom:var(--wp--preset--spacing--50)\">Lineup</h2>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|50\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"450px\"}} -->\r\n<div class=\"wp-block-group\" style=\"padding-bottom:var(--wp--preset--spacing--50)\"><!-- wp:paragraph {\"align\":\"center\"} -->\r\n<p class=\"has-text-align-center\">Get ready for an unforgettable night filled with pulsating rhythms, epic guitar solos, and a whole lot of rock energy.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:group -->\r\n\r\n<!-- wp:lightweight-accordion/lightweight-accordion {\"title\":\"17.April.2026 - Day 1\",\"title_text_color\":\"#fff\",\"title_background_color\":null,\"accordion_open\":true} -->\r\n<!-- wp:spacer {\"height\":\"40px\"} -->\r\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"border\":{\"bottom\":{\"color\":\"#ffffff2e\",\"width\":\"1px\"}},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center\" style=\"border-bottom-color:#ffffff2e;border-bottom-width:1px;padding-top:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}},\"className\":\"stack-on-tablet-portrait \"} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center stack-on-tablet-portrait\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":3392,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Mask-group-37.png\" alt=\"\" class=\"wp-image-3392\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:0;margin-bottom:var(--wp--preset--spacing--20)\">The Sonic Explorers</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:0;margin-bottom:0\">Friday August 5th - 9:00 PM<br>Main Stage</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\">Led by the innovative compositions of their frontman, Alex Harmony, The Sonic Explorers create an immersive experience that transports audiences to uncharted musical realms.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"border\":{\"bottom\":{\"color\":\"#ffffff2e\",\"width\":\"1px\"}},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center\" style=\"border-bottom-color:#ffffff2e;border-bottom-width:1px;padding-top:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}},\"className\":\"stack-on-tablet-portrait \"} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center stack-on-tablet-portrait\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":3397,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Mask-group-38.png\" alt=\"\" class=\"wp-image-3397\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:0;margin-bottom:var(--wp--preset--spacing--20)\">Electric Horizon</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:0;margin-bottom:0\">Saturday August 6th - 8:30 PM <br>Rock Stage</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\">Experience the pulsating beats and electrifying vibes of Electric Horizon! This powerhouse band, led by the charismatic guitarist Jess Sparks, delivers an explosive fusion of rock and electronic soundscapes.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"border\":{\"bottom\":{\"color\":\"#ffffff2e\",\"width\":\"1px\"}},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center\" style=\"border-bottom-color:#ffffff2e;border-bottom-width:1px;padding-top:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}},\"className\":\"stack-on-tablet-portrait \"} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center stack-on-tablet-portrait\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":3402,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Mask-group-39.png\" alt=\"\" class=\"wp-image-3402\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:0;margin-bottom:var(--wp--preset--spacing--20)\">Midnight Mirage</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:0;margin-bottom:0\">Sunday August 7th - 10:00 PM<br>Alternative Stage</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\">Let the music of Midnight Mirage transport you to a world of mystique and magic. Join us for an enchanting evening with Midnight Mirage at our upcoming event!</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n<!-- /wp:lightweight-accordion/lightweight-accordion -->\r\n\r\n<!-- wp:lightweight-accordion/lightweight-accordion {\"title\":\"18.April.2026 - Day 2\",\"title_text_color\":\"#fff\",\"title_background_color\":null} -->\r\n<!-- wp:spacer {\"height\":\"40px\"} -->\r\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\r\n<!-- /wp:spacer -->\r\n\r\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"border\":{\"bottom\":{\"color\":\"#ffffff2e\",\"width\":\"1px\"}},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center\" style=\"border-bottom-color:#ffffff2e;border-bottom-width:1px;padding-top:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}},\"className\":\"stack-on-tablet-portrait \"} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center stack-on-tablet-portrait\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":3403,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Mask-group-40.png\" alt=\"\" class=\"wp-image-3403\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:0;margin-bottom:var(--wp--preset--spacing--20)\">Sonic Uprising</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:0;margin-bottom:0\">Friday August 5th - 9:00 PM<br>Main Stage</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\">Feel the sonic revolution with Sonic Uprising! Led by frontman Max Riff, this band delivers a high-energy fusion of rock and electronic beats.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n\r\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"border\":{\"bottom\":{\"color\":\"#ffffff2e\",\"width\":\"1px\"}},\"spacing\":{\"padding\":{\"bottom\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|40\"}}}} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center\" style=\"border-bottom-color:#ffffff2e;border-bottom-width:1px;padding-top:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40)\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}},\"className\":\"stack-on-tablet-portrait \"} -->\r\n<div class=\"wp-block-columns are-vertically-aligned-center stack-on-tablet-portrait\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\r\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":3404,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\r\n<figure class=\"wp-block-image size-full\"><img src=\"https://themetick.com/wp-content/uploads/2023/11/Mask-group-41.png\" alt=\"\" class=\"wp-image-3404\"/></figure>\r\n<!-- /wp:image --></div>\r\n<!-- /wp:group --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|20\"}}},\"fontSize\":\"small\"} -->\r\n<h3 class=\"wp-block-heading has-small-font-size\" style=\"margin-top:0;margin-bottom:var(--wp--preset--spacing--20)\">Harmony Acoustics</h3>\r\n<!-- /wp:heading -->\r\n\r\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"tiny\"} -->\r\n<p class=\"has-tiny-font-size\" style=\"margin-top:0;margin-bottom:0\">Saturday August 6th - 8:30 PM <br>Rock Stage</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns --></div>\r\n<!-- /wp:column -->\r\n\r\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\r\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\r\n<p class=\"has-small-font-size\">Immerse yourself in the harmonious melodies of Harmony Acoustics. Led by the soulful vocals of Emily Harmony, this acoustic ensemble creates an intimate and captivating musical experience.</p>\r\n<!-- /wp:paragraph --></div>\r\n<!-- /wp:column --></div>\r\n<!-- /wp:columns -->\r\n<!-- /wp:lightweight-accordion/lightweight-accordion --></div>\r\n<!-- /wp:group -->",
	)
);

}
