(function($) { 'use strict';

	// Switching to mobile: https://developer.mozilla.org/en-US/docs/Web/API/MediaQueryList/onchange
	const isMobile = window.matchMedia( '(max-width: ' + getComputedStyle( document.body ).getPropertyValue( '--custom--media-max-width--sm' ) + ')' );

	const navigationResponsiveContainer = document.querySelector( '.site-header .wp-block-navigation__responsive-container' );

	isMobile.onchange = ( e ) => {
		if ( e.matches ) {
			// <= Mobile
		} else {
			// > Mobile
			// Autoclose header nav container if modal is open and browser window gets resized.
			if ( document.body.contains( navigationResponsiveContainer ) && navigationResponsiveContainer.classList.contains( 'is-menu-open' ) ) {
				document.querySelector( '.site-header .wp-block-navigation__responsive-container-close' ).click();
			}
		}
	};

	// Style password protected post form.
	const passwordButton = document.querySelector( '.post-password-form [type="submit"]' );

	if ( document.body.contains( passwordButton ) ) {
		const passwordButtonWrapper = document.createElement( 'div' );
		passwordButtonWrapper.classList.add( 'wp-block-button' );
		passwordButton.parentNode.insertBefore( passwordButtonWrapper, passwordButton );
		passwordButtonWrapper.appendChild( passwordButton );

		passwordButton.classList.add( 'wp-block-button__link' );
	}

	document.querySelectorAll('a[href^="#"]').forEach(anchor => {
		anchor.addEventListener('click', function (e) {
			e.preventDefault();

			document.querySelector(this.getAttribute('href')).scrollIntoView({
				behavior: 'smooth'
			});
		});
	});

	// Calculate clients viewport
	const w = window,
	d = document,
	e = d.documentElement,
	g = d.getElementsByTagName('body')[0];

	let x = w.innerWidth || e.clientWidth || g.clientWidth, // Viewport Width
	y = w.innerHeight || e.clientHeight || g.clientHeight; // Viewport Height

	// Global vars
	const body = document.body;

	// Custom input number field
	function customNumInput(){

		const inputNum = $('input.input-text.qty');

		if(inputNum.length){
			inputNum.each(function(){
				const thisInput = $(this);
				const thisInputVal = parseInt(thisInput.val());
				let minVal = parseInt(thisInput.attr('min'));
				let maxVal = parseInt(thisInput.attr('max'));
				let value = isNaN(thisInputVal) ? 0 : parseInt(thisInputVal);

				thisInput.addClass('custom-num-input');

				if (isNaN(minVal)){
					minVal = 0;
				}

				if (isNaN(maxVal)){
					maxVal = Number.MAX_VALUE;
				}

				if(!thisInput.siblings('.up').length){
					thisInput.parent('.quantity').prepend('<button class="down">－</button>').append('<button class="up">＋</button>');
				}
				var adjustVal = thisInput.siblings('button');

				adjustVal.on('click', function(e){
					e.preventDefault();
					var $this = $(this);


					if ($this.is('.down') && (value > minVal)){
						value--;
					}
					else if ($this.is('.up') && (value < maxVal)){
						value++;
					}
					thisInput.val(value);

					$(this).parents('form').find('input[name=update_cart], button[name=update_cart]').prop("disabled", false);
				});
			});
		}
	}

	$(document.body).on('updated_cart_totals', function() {
		customNumInput();
	});

	customNumInput();

	// Add toggle button to product-filters blocks
	const { __, _x, _n, _nx } = wp.i18n;

	function FiltersButton() {
		const hideOnTouchDevices = document.querySelectorAll('.product-filters');
		hideOnTouchDevices.forEach(element => {
			const button = document.createElement('button');
			button.classList.add('wp-block-button__link', 'product-filters__button');
			button.textContent = __('Filters', 'harmonix');
			button.addEventListener('click', () => {
				element.toggleAttribute('open');
			});
			element.prepend(button);

			// Get all children of an element except the button
			const childElements = element => [].slice.call(element.children).filter((child) => !child.classList.contains('product-filters__button'));

			// Create a wrapper for the children
			const wrapper = document.createElement('div');
			wrapper.classList.add('product-filters__blocks');

			// Move childElements to wrapper
			childElements(element).forEach(child => wrapper.append(child));
			element.append(wrapper);
		});
	}

	FiltersButton();

	$(function(){

		// On scroll
		const fnOnScroll = function(){

			const animateBlock = $('.h-animate-from-top, .h-animate-from-left, .h-animate-from-right, .h-animate-from-bottom, .js-reveal-from-top, .js-reveal-from-bottom, .h-reveal-images-from-bottom, .wp-block-separator, .products > .product, .wc-block-grid__products .wc-block-grid__product');
			animateBlock.removeClass('is-loading');

			if (animateBlock.length) {
				animateBlock.each(function(){
					const $this = $(this);
					const animateBlockOffsetTop = $this.offset().top;
					let activationOffset;

					// Determinate distance to initiate animation relative to viewport height - add date-offset attribute to animating element. Default is date-offset="1.2"
					if($this.data('offset'))
						activationOffset = $this.data('offset');
					else if($this.hasClass('h-reveal-images-from-bottom'))
						activationOffset = 1.2;
					else if($this.hasClass('product'))
						activationOffset = 1.05;
					else
						activationOffset = 0.8;

					if((window.scrollY > animateBlockOffsetTop - y / activationOffset)){
						$this.addClass('scrolled-to');
					}
				});
			}
		};

		fnOnScroll();

		window.onscroll = function() {
			fnOnScroll();
		};

		// Shop featured category responsive height
		const featuredCatBlock = document.querySelectorAll('.wc-block-featured-category, .wc-block-featured-product');

		if(featuredCatBlock && x > 600){
			Array.prototype.forEach.call(featuredCatBlock, function(el){
				let featuredCatBlockHeight = el.clientHeight;
				let featuredCatRespBlockHeight = (featuredCatBlockHeight / 19.2).toFixed(2);
				if(featuredCatBlockHeight > 500){
					el.style.minHeight = featuredCatRespBlockHeight + 'vw';
				}
				else if(featuredCatBlockHeight == 500 && x < 991){
					el.style.minHeight = '40vw';
				}
			});
		}

		// Add class .active-nav-item for navigation block current page item
		document.body.querySelectorAll( '.wp-block-navigation' ).forEach( function( navBlock ) {
			navBlock.querySelectorAll( '[href="' + window.location.href + '"]' ).forEach( function( navActiveLink ) {
				navActiveLink.parentNode.classList.add( 'active-nav-item' );
			});
		});

		// Move injected product gallery image in product block
		const productGridLink = document.body.querySelectorAll( '.wc-block-grid__product-link' );

		productGridLink.forEach( function( productImgWrap ) {
			const additionalProductImg = productImgWrap.querySelector( '.wc-block-grid__product-image ~ img' );
			if(additionalProductImg)
				productImgWrap.querySelector('.wc-block-grid__product-image').append(additionalProductImg);
		});

		// Woocommerce product filters
		const tcProductFilters = $('div.tc-product-filters');

		if(tcProductFilters.length){
			const tcProductFiltersTrig = document.querySelector('.tc-product-filters-trigger');
			const tcProductFiltersTrigParent = tcProductFiltersTrig.closest('.wp-block-buttons');
			const wooOrderingFilter = document.querySelector('.woocommerce-ordering');
			const wooOrderingFilterParent = wooOrderingFilter.parentElement;

			wooOrderingFilterParent.insertBefore(tcProductFiltersTrigParent, wooOrderingFilter);
			body.classList.add('has-tc-product-filter');
			tcProductFilters.closest('.wp-block-columns').addClass('tc-product-filters-wrap');
			tcProductFiltersTrig.closest('.wp-block-buttons').classList.add('tc-product-filters-trigger-wrap');

			tcProductFiltersTrig.addEventListener('click', function(e) {
				e.preventDefault();

				if(tcProductFilters.hasClass('open')){
					tcProductFilters.slideUp().removeClass('open').addClass('closed');
				}
				else {
					tcProductFilters.slideDown().addClass('open').removeClass('closed');
				}

				return false;
			});
		}

		// Add Show class to body
		body.classList.add('show');

	}); // End Document Ready

	document.addEventListener('DOMContentLoaded', function(){

		// Calculate clients viewport

		x=w.innerWidth||e.clientWidth||g.clientWidth; // Viewport Width
		y=w.innerHeight||e.clientHeight||g.clientHeight; // Viewport Height

		// Scroll to element with target ID, if it doesn't exist go to root URL with added hash from href attribute of clicked link
		$(document).on('click', '.site-header a[href^="#"]', function(e){
			e.preventDefault();
			let urlHash = e.target.closest('a').getAttribute('href');
			let urlHashRemoveHashSign = urlHash.replace('#', '');
			let targetEl = document.getElementById(urlHashRemoveHashSign);

			if(!body.classList.contains( 'show' )){
				body.classList.add('show');
			}

			if(targetEl){
				$('html, body').animate({
					scrollTop: $($.attr(this, 'href')).offset().top - y / 6
				}, 500);
				return false;
			}
			else{
				window.location = '/' + urlHash;
			}
		});

	}, false);

})(jQuery);
