<?php
namespace ReyCore\Modules\ProductBadges;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class AcfFields {

	const FIELDS_GROUP_KEY = 'group_5d4ff536a2684';

	public function __construct(){

		if( ! function_exists('acf_add_local_field') ){
			return;
		}

		foreach ($this->fields() as $key => $field) {
			acf_add_local_field($field);
		}

	}

	public function fields(){
		return [
			[
				'key' => 'field_5e541a33cdb3d',
				'label' => esc_html_x('Badge', 'Backend setting label', 'rey-core'),
				'name' => '',
				'type' => 'tab',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => [
					'width' => '',
					'class' => '',
					'id' => '',
				],
				'placement' => 'top',
				'endpoint' => 0,
				'parent' => self::FIELDS_GROUP_KEY,
			],
			[
				'key' => 'field_5efdd6127b753',
				'label' => esc_html_x('Add badges', 'Backend setting label', 'rey-core'),
				'name' => 'badges',
				'type' => 'repeater',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => [
					'width' => '',
					'class' => '--acf-repeater-row',
					'id' => '',
				],
				'collapsed' => '',
				'min' => 0,
				'max' => 0,
				'layout' => 'row',
				'button_label' => 'Add new badge',
				'parent' => self::FIELDS_GROUP_KEY,
				'sub_fields' => [
					[
						'key' => 'field_5efdd6317b754',
						'label' => esc_html_x('Type', 'Backend setting label', 'rey-core'),
						'name' => 'type',
						'type' => 'select',
						'instructions' => esc_html_x('Select the product badge type', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => [
							'width' => '',
							'class' => '--size-3',
							'id' => '',
						],
						'choices' => [
							'text' => esc_html_x('Custom Text', 'Backend setting label', 'rey-core'),
							'image' => esc_html_x('Custom Image', 'Backend setting label', 'rey-core'),
							// 'new' => 'New',
						],
						'default_value' => false,
						'allow_null' => 0,
						'multiple' => 0,
						'ui' => 0,
						'return_format' => 'value',
						'ajax' => 0,
						'placeholder' => '',
					],
					[
						'key' => 'field_5efdd67c7b755',
						'label' => esc_html_x('Text', 'Backend setting label', 'rey-core'),
						'name' => 'text',
						'type' => 'text',
						'instructions' => esc_html_x('Add the text inside the badge.', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5efdd6317b754',
									'operator' => '==',
									'value' => 'text',
								],
							],
						],
						'wrapper' => [
							'width' => '',
							'class' => '',
							'id' => '',
						],
						'default_value' => '',
						'placeholder' => 'eg: HOT',
						'prepend' => '',
						'append' => '',
						'maxlength' => '',
					],
					[
						'key' => 'field_5efdd6ab7b756',
						'label' => esc_html_x('Text Color', 'Backend setting label', 'rey-core'),
						'name' => 'text_color',
						'type' => 'color_picker',
						'instructions' => esc_html_x('Select the text color', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5efdd6317b754',
									'operator' => '==',
									'value' => 'text',
								],
							],
						],
						'wrapper' => [
							'width' => '',
							'class' => '',
							'id' => '',
						],
						'default_value' => '',
						'enable_opacity' => 1,
					],
					[
						'key' => 'field_5efdd6cf7b757',
						'label' => esc_html_x('Background Color', 'Backend setting label', 'rey-core'),
						'name' => 'text_bg_color',
						'type' => 'color_picker',
						'instructions' => esc_html_x('Select the background color', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5efdd6317b754',
									'operator' => '==',
									'value' => 'text',
								],
							],
						],
						'wrapper' => [
							'width' => '',
							'class' => '',
							'id' => '',
						],
						'default_value' => '',
						'enable_opacity' => 1,
					],
					[
						'key' => 'field_5efdd6ef7b758',
						'label' => esc_html_x('Text Size', 'Backend setting label', 'rey-core'),
						'name' => 'text_size',
						'type' => 'number',
						'instructions' => esc_html_x('Select the text size.', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5efdd6317b754',
									'operator' => '==',
									'value' => 'text',
								],
							],
						],
						'wrapper' => [
							'width' => '20',
							'class' => '--size-1 rey-acf-responsive --desktop',
							'id' => '',
						],
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => 'px',
						'min' => 8,
						'max' => 60,
						'step' => 1,
					],
					[
						'key' => 'field_5efdd7337b759',
						'label' => esc_html_x('Text Size (Tablet]', 'Backend setting label', 'rey-core'),
						'name' => 'text_size_tablet',
						'type' => 'number',
						'instructions' => esc_html_x('Select the text size on tablet.', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5efdd6317b754',
									'operator' => '==',
									'value' => 'text',
								],
							],
						],
						'wrapper' => [
							'width' => '20',
							'class' => '--size-1 rey-acf-responsive --tablet',
							'id' => '',
						],
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => 'px',
						'min' => 8,
						'max' => 60,
						'step' => 1,
					],
					[
						'key' => 'field_5efdd7667b75a',
						'label' => esc_html_x('Text Size (Mobile]', 'Backend setting label', 'rey-core'),
						'name' => 'text_size_mobile',
						'type' => 'number',
						'instructions' => esc_html_x('Select the text size on tablet.', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5efdd6317b754',
									'operator' => '==',
									'value' => 'text',
								],
							],
						],
						'wrapper' => [
							'width' => '20',
							'class' => '--size-1 rey-acf-responsive --mobile',
							'id' => '',
						],
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => 'px',
						'min' => 8,
						'max' => 60,
						'step' => 1,
					],
					[
						'key' => 'field_5efdd77e7b75b',
						'label' => esc_html_x('Badge Image (s]', 'Backend setting label', 'rey-core'),
						'name' => 'images',
						'type' => 'repeater',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5efdd6317b754',
									'operator' => '==',
									'value' => 'image',
								],
							],
						],
						'wrapper' => [
							'width' => '',
							'class' => '',
							'id' => '',
						],
						'collapsed' => '',
						'min' => 0,
						'max' => 0,
						'layout' => 'block',
						'button_label' => 'Add new image',
						'sub_fields' => [
							[
								'key' => 'field_5efdd7a37b75c',
								'label' => esc_html_x('Select image', 'Backend setting label', 'rey-core'),
								'name' => 'select_image',
								'type' => 'image',
								'instructions' => '',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => [
									'width' => '',
									'class' => '',
									'id' => '',
								],
								'return_format' => 'id',
								'preview_size' => 'thumbnail',
								'library' => 'all',
								'min_width' => '',
								'min_height' => '',
								'min_size' => '',
								'max_width' => '',
								'max_height' => '',
								'max_size' => '',
								'mime_types' => '',
							],
							[
								'key' => 'field_5e7b7fdd7a35c',
								'label' => esc_html_x('Tooltip text', 'Backend setting label', 'rey-core'),
								'name' => 'tooltip',
								'type' => 'text',
								'instructions' => esc_html_x('Include a tooltip text.', 'Backend setting description', 'rey-core'),
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => [
									'width' => '',
									'class' => '',
									'id' => '',
								],
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
							],
						],
					],
					[
						'key' => 'field_5efdd7d97b75d',
						'label' => esc_html_x('Image size', 'Backend setting label', 'rey-core'),
						'name' => 'image_size',
						'type' => 'number',
						'instructions' => esc_html_x('Select the badge maximum width.', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5efdd6317b754',
									'operator' => '==',
									'value' => 'image',
								],
							],
						],
						'wrapper' => [
							'width' => '',
							'class' => '--size-1 rey-acf-responsive --desktop',
							'id' => '',
						],
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => 'px',
						'min' => 5,
						'max' => 200,
						'step' => 1,
					],
					[
						'key' => 'field_5efdd8127b75e',
						'label' => esc_html_x('Image size (tablet]', 'Backend setting label', 'rey-core'),
						'name' => 'image_size_tablet',
						'type' => 'number',
						'instructions' => esc_html_x('Select the badge maximum width for tablets.', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5efdd6317b754',
									'operator' => '==',
									'value' => 'image',
								],
							],
						],
						'wrapper' => [
							'width' => '',
							'class' => '--size-1 rey-acf-responsive --tablet',
							'id' => '',
						],
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => 'px',
						'min' => 5,
						'max' => 200,
						'step' => 1,
					],
					[
						'key' => 'field_5efdd82d7b75f',
						'label' => esc_html_x('Image size (mobile]', 'Backend setting label', 'rey-core'),
						'name' => 'image_size_mobile',
						'type' => 'number',
						'instructions' => esc_html_x('Select the badge maximum width for mobiles.', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5efdd6317b754',
									'operator' => '==',
									'value' => 'image',
								],
							],
						],
						'wrapper' => [
							'width' => '',
							'class' => '--size-1 rey-acf-responsive --mobile',
							'id' => '',
						],
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => 'px',
						'min' => 5,
						'max' => 200,
						'step' => 1,
					],
					[
						'key' => 'field_5efd755d67c7b',
						'label' => esc_html_x('Custom Link', 'Backend setting label', 'rey-core'),
						'name' => 'link',
						'type' => 'text',
						'instructions' => esc_html_x('Add a link on the badge. Supports shortcodes.', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => [
							'width' => '',
							'class' => '',
							'id' => '',
						],
						'default_value' => '',
						'placeholder' => 'eg: https://website.com/',
						'prepend' => '',
						'append' => '',
						'maxlength' => '',
					],
					[
						'key' => 'field_5faebdb8d1573',
						'label' => esc_html_x('Add on catalog page', 'Backend setting label', 'rey-core'),
						'name' => 'catalog_page',
						'type' => 'true_false',
						'instructions' => esc_html_x('Select if you want to display on product catalog page.', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => [
							'width' => '',
							'class' => '',
							'id' => '',
						],
						'message' => '',
						'default_value' => 1,
						'ui' => 1,
						'ui_on_text' => '',
						'ui_off_text' => '',
					],
					[
						'key' => 'field_5efdd84a7b760',
						'label' => esc_html_x('Show badge on mobile', 'Backend setting label', 'rey-core'),
						'name' => 'show_on_mobile',
						'type' => 'true_false',
						'instructions' => esc_html_x('Select if you want to show or hide the badge on mobiles.', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5faebdb8d1573',
									'operator' => '==',
									'value' => '1',
								],
							],
						],
						'wrapper' => [
							'width' => '',
							'class' => '',
							'id' => '',
						],
						'message' => '',
						'default_value' => 1,
						'ui' => 1,
						'ui_on_text' => '',
						'ui_off_text' => '',
					],
					[
						'key' => 'field_5efdd88d7b761',
						'label' => esc_html_x('Badge Position', 'Backend setting label', 'rey-core'),
						'name' => 'position',
						'type' => 'select',
						'instructions' => esc_html_x('Choose position in product item in catalog page.', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5faebdb8d1573',
									'operator' => '==',
									'value' => '1',
								],
							],
						],
						'wrapper' => [
							'width' => '',
							'class' => '--size-2',
							'id' => '',
						],
						'choices' => [
							'top_left' => esc_html_x('Top Left', 'Backend setting label', 'rey-core'),
							'top_right' => esc_html_x('Top Right', 'Backend setting label', 'rey-core'),
							'bottom_left' => esc_html_x('Bottom Left', 'Backend setting label', 'rey-core'),
							'bottom_right' => esc_html_x('Bottom Right', 'Backend setting label', 'rey-core'),
							'before_title' => esc_html_x('Before Title', 'Backend setting label', 'rey-core'),
							'after_content' => esc_html_x('After content', 'Backend setting label', 'rey-core'),
						],
						'default_value' => 'top_left',
						'allow_null' => 0,
						'multiple' => 0,
						'ui' => 0,
						'return_format' => 'value',
						'ajax' => 0,
						'placeholder' => '',
					],
					[
						'key' => 'field_5efe3426f25ae',
						'label' => esc_html_x('Add on product page', 'Backend setting label', 'rey-core'),
						'name' => 'product_page',
						'type' => 'true_false',
						'instructions' => esc_html_x('Select if you want to display on product page too.', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => [
							'width' => '',
							'class' => '',
							'id' => '',
						],
						'message' => '',
						'default_value' => 0,
						'ui' => 1,
						'ui_on_text' => '',
						'ui_off_text' => '',
					],
					[
						'key' => 'field_5efe344bf25af',
						'label' => esc_html_x('Product page Position', 'Backend setting label', 'rey-core'),
						'name' => 'product_page_position',
						'type' => 'select',
						'instructions' => esc_html_x('Select the position where you want to display the badge in the product page', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5efe3426f25ae',
									'operator' => '==',
									'value' => '1',
								],
							],
						],
						'wrapper' => [
							'width' => '',
							'class' => '--size-3',
							'id' => '',
						],
						'choices' => [
							'before_title' => esc_html_x('Before Title', 'Backend setting label', 'rey-core'),
							'before_meta' => esc_html_x('Before Meta', 'Backend setting label', 'rey-core'),
							'after_meta' => esc_html_x('After Meta', 'Backend setting label', 'rey-core'),
						],
						'default_value' => 'before_title',
						'allow_null' => 0,
						'multiple' => 0,
						'ui' => 0,
						'return_format' => 'value',
						'ajax' => 0,
						'placeholder' => '',
					],
					[
						'key' => 'field_5efe6f23425ae',
						'label' => esc_html_x('Show as block', 'Backend setting label', 'rey-core'),
						'name' => 'product_page_as_block',
						'type' => 'true_false',
						'instructions' => esc_html_x('Select if you want to display the badge as a block.', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => [
							[
								[
									'field' => 'field_5efe3426f25ae',
									'operator' => '==',
									'value' => '1',
								],
							],
						],
						'wrapper' => [
							'width' => '',
							'class' => '',
							'id' => '',
						],
						'message' => '',
						'default_value' => 0,
						'ui' => 1,
						'ui_on_text' => '',
						'ui_off_text' => '',
					],
					[
						'key' => 'field_567b75c7efdd5',
						'label' => esc_html_x('Custom CSS Styles', 'Backend setting label', 'rey-core'),
						'name' => 'custom_css_styles',
						'type' => 'text',
						'instructions' => esc_html_x('Add custom CSS styles on this badge. Separate properties with ;', 'Backend setting description', 'rey-core'),
						'default_value' => '',
						'placeholder' => 'eg: padding: 0.5em;',
						'prepend' => '',
						'append' => '',
						'maxlength' => '',
					],
				],
			],
		];
	}
}
