<?php
if (!defined('ABSPATH')) exit; // Exit if accessed directly

if( function_exists('acf_add_local_field_group') ):

	acf_add_local_field_group(array(
		'key' => 'group_5eca340657edd',
		'title' => 'Template Location',
		'fields' => array(
			array(
				'key' => 'field_5ece7a2687e16',
				'label' => esc_html_x('TYPE & LOCATION', 'Backend setting label', 'rey-core'),
				'name' => '',
				'type' => 'tab',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'placement' => 'top',
				'endpoint' => 0,
			),
			array(
				'key' => 'field_5eca340a16793',
				'label' => esc_html_x('Type', 'Backend setting label', 'rey-core'),
				'name' => 'template_type',
				'type' => 'button_group',
				'instructions' => esc_html_x('Select target locations.', 'Backend setting description', 'rey-core'),
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'page' => esc_html_x('Page', 'Backend setting label', 'rey-core'),
					'single' => esc_html_x('Single', 'Backend setting label', 'rey-core'),
					'archive' => esc_html_x('Archive', 'Backend setting label', 'rey-core'),
					'product' => esc_html_x('Product page', 'Backend setting label', 'rey-core'),
					'product-archive' => esc_html_x('Product Archive', 'Backend setting label', 'rey-core'),
				),
				'allow_null' => 1,
				'default_value' => '',
				'layout' => 'horizontal',
				'return_format' => 'value',
			),
			array(
				'key' => 'field_5eca76648cf2d',
				'label' => esc_html_x('Single Conditions', 'Backend setting label', 'rey-core'),
				'name' => 'general_conditions',
				'type' => 'repeater',
				'instructions' => esc_html_x('Create as many conditions as you want to target the specific site areas want.', 'Backend setting description', 'rey-core'),
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_5eca340a16793',
							'operator' => '==',
							'value' => 'single',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => 'rey-acf-conditions',
					'id' => '',
				),
				'collapsed' => '',
				'min' => 0,
				'max' => 0,
				'layout' => 'row',
				'button_label' => 'Add condition',
				'sub_fields' => array(
					array(
						'key' => 'field_5ecd817164c3d',
						'label' => esc_html_x('Post Type', 'Backend setting label', 'rey-core'),
						'name' => 'post_type',
						'type' => 'select',
						'instructions' => esc_html_x('Choose the post type', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '--size-3',
							'id' => '',
						),
						'choices' => array(
							'post' => esc_html_x('Posts (Blog)', 'Backend setting label', 'rey-core'),
						),
						'default_value' => 'post',
						'allow_null' => 0,
						'multiple' => 0,
						'ui' => 0,
						'return_format' => 'value',
						'ajax' => 0,
						'placeholder' => '',
					),
					array(
						'key' => 'field_5eca76648cf2e',
						'label' => esc_html_x('Operator', 'Backend setting label', 'rey-core'),
						'name' => 'operator',
						'type' => 'button_group',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'choices' => array(
							'include' => esc_html_x('Include', 'Backend setting label', 'rey-core'),
							'exclude' => esc_html_x('Exclude', 'Backend setting label', 'rey-core'),
						),
						'allow_null' => 0,
						'default_value' => '',
						'layout' => 'horizontal',
						'return_format' => 'value',
					),
					array(
						'key' => 'field_5eca76648cf2f',
						'label' => esc_html_x('Location', 'Backend setting label', 'rey-core'),
						'name' => 'location',
						'type' => 'select',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5ecd817164c3d',
									'operator' => '==',
									'value' => 'post',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'choices' => array(
							'categories' => esc_html_x('Categories (post)', 'Backend setting label', 'rey-core'),
							'tags' => esc_html_x('Tags (post)', 'Backend setting label', 'rey-core'),
							'posts' => esc_html_x('Post', 'Backend setting label', 'rey-core'),
						),
						'default_value' => false,
						'allow_null' => 1,
						'multiple' => 0,
						'ui' => 0,
						'return_format' => 'value',
						'ajax' => 0,
						'placeholder' => '',
					),
					array(
						'key' => 'field_5eca76648cf30',
						'label' => esc_html_x('Categories', 'Backend setting label', 'rey-core'),
						'name' => 'categories',
						'type' => 'taxonomy',
						'instructions' => esc_html_x('Select categories', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5eca76648cf2f',
									'operator' => '==',
									'value' => 'categories',
								),
								array(
									'field' => 'field_5ecd817164c3d',
									'operator' => '==',
									'value' => 'post',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'taxonomy' => 'category',
						'field_type' => 'checkbox',
						'add_term' => 0,
						'save_terms' => 0,
						'load_terms' => 0,
						'return_format' => 'id',
						'multiple' => 0,
						'allow_null' => 0,
					),
					array(
						'key' => 'field_5eca76648cf31',
						'label' => esc_html_x('Include sub-categories', 'Backend setting label', 'rey-core'),
						'name' => 'include_sub',
						'type' => 'true_false',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5eca76648cf2f',
									'operator' => '==',
									'value' => 'categories',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'message' => '',
						'default_value' => 1,
						'ui' => 1,
						'ui_on_text' => '',
						'ui_off_text' => '',
					),
					array(
						'key' => 'field_5eca76648cf32',
						'label' => esc_html_x('Tags', 'Backend setting label', 'rey-core'),
						'name' => 'tags',
						'type' => 'taxonomy',
						'instructions' => esc_html_x('Select tags', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5eca76648cf2f',
									'operator' => '==',
									'value' => 'tags',
								),
								array(
									'field' => 'field_5ecd817164c3d',
									'operator' => '==',
									'value' => 'post',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'taxonomy' => 'post_tag',
						'field_type' => 'checkbox',
						'add_term' => 0,
						'save_terms' => 0,
						'load_terms' => 0,
						'return_format' => 'id',
						'multiple' => 0,
						'allow_null' => 0,
					),
					array(
						'key' => 'field_5eca778df3957',
						'label' => esc_html_x('Posts', 'Backend setting label', 'rey-core'),
						'name' => 'posts',
						'type' => 'relationship',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5eca76648cf2f',
									'operator' => '==',
									'value' => 'posts',
								),
								array(
									'field' => 'field_5eca340a16793',
									'operator' => '==',
									'value' => 'single',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'post_type' => '',
						'taxonomy' => '',
						'filters' => array(
							0 => 'search',
							1 => 'post_type',
							2 => 'taxonomy',
						),
						'elements' => '',
						'min' => '',
						'max' => '',
						'return_format' => 'id',
					),
				),
			),
			array(
				'key' => 'field_5f2c3195e038a',
				'label' => esc_html_x('Archive Conditions', 'Backend setting label', 'rey-core'),
				'name' => 'archive_conditions',
				'type' => 'repeater',
				'instructions' => esc_html_x('Create as many conditions as you want to target the specific site areas want.', 'Backend setting description', 'rey-core'),
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_5eca340a16793',
							'operator' => '==',
							'value' => 'archive',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => 'rey-acf-conditions',
					'id' => '',
				),
				'collapsed' => '',
				'min' => 0,
				'max' => 0,
				'layout' => 'row',
				'button_label' => esc_html_x('Add condition', 'Backend setting label', 'rey-core'),
				'sub_fields' => array(
					array(
						'key' => 'field_5f2c3195e038c',
						'label' => esc_html_x('Operator', 'Backend setting label', 'rey-core'),
						'name' => 'operator',
						'type' => 'button_group',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'choices' => array(
							'include' => esc_html_x('Include', 'Backend setting label', 'rey-core'),
							'exclude' => esc_html_x('Exclude', 'Backend setting label', 'rey-core'),
						),
						'allow_null' => 0,
						'default_value' => '',
						'layout' => 'horizontal',
						'return_format' => 'value',
					),
					array(
						'key' => 'field_5f2c3195e038d',
						'label' => esc_html_x('Location', 'Backend setting label', 'rey-core'),
						'name' => 'location',
						'type' => 'select',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'choices' => array(
							'categories' => esc_html_x('Categories (post)', 'Backend setting label', 'rey-core'),
							'tags' => esc_html_x('Tags (post)', 'Backend setting label', 'rey-core'),
						),
						'default_value' => false,
						'allow_null' => 1,
						'multiple' => 0,
						'ui' => 0,
						'return_format' => 'value',
						'ajax' => 0,
						'placeholder' => '',
					),
					array(
						'key' => 'field_5f2c3195e038e',
						'label' => esc_html_x('Categories', 'Backend setting label', 'rey-core'),
						'name' => 'categories',
						'type' => 'taxonomy',
						'instructions' => esc_html_x('Select categories', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5f2c3195e038d',
									'operator' => '==',
									'value' => 'categories',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'taxonomy' => 'category',
						'field_type' => 'checkbox',
						'add_term' => 0,
						'save_terms' => 0,
						'load_terms' => 0,
						'return_format' => 'id',
						'multiple' => 0,
						'allow_null' => 0,
					),
					array(
						'key' => 'field_5f2c3195e038f',
						'label' => esc_html_x('Include sub-categories', 'Backend setting label', 'rey-core'),
						'name' => 'include_sub',
						'type' => 'true_false',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5f2c3195e038d',
									'operator' => '==',
									'value' => 'categories',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'message' => '',
						'default_value' => 1,
						'ui' => 1,
						'ui_on_text' => '',
						'ui_off_text' => '',
					),
					array(
						'key' => 'field_5f2c3195e0390',
						'label' => esc_html_x('Tags', 'Backend setting label', 'rey-core'),
						'name' => 'tags',
						'type' => 'taxonomy',
						'instructions' => esc_html_x('Select tags', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5f2c3195e038d',
									'operator' => '==',
									'value' => 'tags',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'taxonomy' => 'post_tag',
						'field_type' => 'checkbox',
						'add_term' => 0,
						'save_terms' => 0,
						'load_terms' => 0,
						'return_format' => 'id',
						'multiple' => 0,
						'allow_null' => 0,
					),
				),
			),
			array(
				'key' => 'field_5eca355016794',
				'label' => esc_html_x('Product Conditions', 'Backend setting label', 'rey-core'),
				'name' => 'product_conditions',
				'type' => 'repeater',
				'instructions' => esc_html_x('Create as many conditions as you want to target the specific site areas want.', 'Backend setting description', 'rey-core'),
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_5eca340a16793',
							'operator' => '==',
							'value' => 'product',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => 'rey-acf-conditions',
					'id' => '',
				),
				'collapsed' => '',
				'min' => 0,
				'max' => 0,
				'layout' => 'row',
				'button_label' => 'Add condition',
				'sub_fields' => array(
					array(
						'key' => 'field_5eca357e16795',
						'label' => esc_html_x('Operator', 'Backend setting label', 'rey-core'),
						'name' => 'operator',
						'type' => 'button_group',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'choices' => array(
							'include' => esc_html_x('Include', 'Backend setting label', 'rey-core'),
							'exclude' => esc_html_x('Exclude', 'Backend setting label', 'rey-core'),
						),
						'allow_null' => 0,
						'default_value' => '',
						'layout' => 'horizontal',
						'return_format' => 'value',
					),
					array(
						'key' => 'field_5eca3b1116797',
						'label' => esc_html_x('Location', 'Backend setting label', 'rey-core'),
						'name' => 'location',
						'type' => 'select',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'choices' => array(
							'categories' => esc_html_x('Categories', 'Backend setting label', 'rey-core'),
							'tags' => esc_html_x('Tags', 'Backend setting label', 'rey-core'),
							'attributes' => esc_html_x('Attributes', 'Backend setting label', 'rey-core'),
							'products' => esc_html_x('Products', 'Backend setting label', 'rey-core'),
						),
						'default_value' => false,
						'allow_null' => 1,
						'multiple' => 0,
						'ui' => 0,
						'return_format' => 'value',
						'ajax' => 0,
						'placeholder' => '',
					),
					array(
						'key' => 'field_5eca35c516796',
						'label' => esc_html_x('Categories', 'Backend setting label', 'rey-core'),
						'name' => 'categories',
						'type' => 'taxonomy',
						'instructions' => esc_html_x('Select categories', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5eca3b1116797',
									'operator' => '==',
									'value' => 'categories',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'taxonomy' => 'product_cat',
						'field_type' => 'checkbox',
						'add_term' => 0,
						'save_terms' => 0,
						'load_terms' => 0,
						'return_format' => 'id',
						'multiple' => 0,
						'allow_null' => 0,
					),
					array(
						'key' => 'field_5eca3d6a4daae',
						'label' => esc_html_x('Include sub-categories', 'Backend setting label', 'rey-core'),
						'name' => 'include_sub',
						'type' => 'true_false',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5eca3b1116797',
									'operator' => '==',
									'value' => 'categories',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'message' => '',
						'default_value' => 1,
						'ui' => 1,
						'ui_on_text' => '',
						'ui_off_text' => '',
					),
					array(
						'key' => 'field_5eca3c9e4daaa',
						'label' => esc_html_x('Tags', 'Backend setting label', 'rey-core'),
						'name' => 'tags',
						'type' => 'taxonomy',
						'instructions' => esc_html_x('Select tags', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5eca3b1116797',
									'operator' => '==',
									'value' => 'tags',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'taxonomy' => 'product_tag',
						'field_type' => 'checkbox',
						'add_term' => 0,
						'save_terms' => 0,
						'load_terms' => 0,
						'return_format' => 'id',
						'multiple' => 0,
						'allow_null' => 0,
					),
					array(
						'key' => 'field_5eca52213daa7',
						'label' => esc_html_x('Attributes', 'Backend setting label', 'rey-core'),
						'name' => 'attributes',
						'type' => 'select',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5eca3b1116797',
									'operator' => '==',
									'value' => 'attributes',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'choices' => array(
						),
						'default_value' => array(
						),
						'allow_null' => 0,
						'multiple' => 1,
						'ui' => 1,
						'ajax' => 0,
						'return_format' => 'value',
						'placeholder' => '',
					),
					array(
						'key' => 'field_5eca8337d382f',
						'label' => esc_html_x('Products', 'Backend setting label', 'rey-core'),
						'name' => 'products',
						'type' => 'relationship',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5eca3b1116797',
									'operator' => '==',
									'value' => 'products',
								),
								array(
									'field' => 'field_5eca340a16793',
									'operator' => '==',
									'value' => 'product',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'post_type' => array(
							0 => 'product',
						),
						'taxonomy' => '',
						'filters' => array(
							0 => 'search',
						),
						'elements' => '',
						'min' => '',
						'max' => '',
						'return_format' => 'id',
					),
				),
			),
			array(
				'key' => 'field_5eca925bbfd0d',
				'label' => esc_html_x('Product Archive Conditions', 'Backend setting label', 'rey-core'),
				'name' => 'product_archive_conditions',
				'type' => 'repeater',
				'instructions' => esc_html_x('Create as many conditions as you want to target the specific archive areas want.', 'Backend setting description', 'rey-core'),
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_5eca340a16793',
							'operator' => '==',
							'value' => 'product-archive',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => 'rey-acf-conditions',
					'id' => '',
				),
				'collapsed' => '',
				'min' => 0,
				'max' => 0,
				'layout' => 'row',
				'button_label' => esc_html_x('Add condition', 'Backend setting label', 'rey-core'),
				'sub_fields' => array(
					array(
						'key' => 'field_5eca925bbfd0e',
						'label' => esc_html_x('Operator', 'Backend setting label', 'rey-core'),
						'name' => 'operator',
						'type' => 'button_group',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'choices' => array(
							'include' => esc_html_x('Include', 'Backend setting label', 'rey-core'),
							'exclude' => esc_html_x('Exclude', 'Backend setting label', 'rey-core'),
						),
						'allow_null' => 0,
						'default_value' => '',
						'layout' => 'horizontal',
						'return_format' => 'value',
					),
					array(
						'key' => 'field_5eca925bbfd0f',
						'label' => esc_html_x('Location', 'Backend setting label', 'rey-core'),
						'name' => 'location',
						'type' => 'select',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'choices' => array(
							'categories' => esc_html_x('Product Categories', 'Backend setting label', 'rey-core'),
							'tags' => esc_html_x('Product Tags', 'Backend setting label', 'rey-core'),
							'attributes' => esc_html_x('Public Attributes (enabled Archive)', 'Backend setting label', 'rey-core'),
							'shop_page' => esc_html_x('Shop Page', 'Backend setting label', 'rey-core'),
							'search' => esc_html_x('Search page', 'Backend setting label', 'rey-core'),
						),
						'default_value' => false,
						'allow_null' => 1,
						'multiple' => 0,
						'ui' => 0,
						'return_format' => 'value',
						'ajax' => 0,
						'placeholder' => '',
					),
					array(
						'key' => 'field_5eca925bbfd10',
						'label' => esc_html_x('Categories', 'Backend setting label', 'rey-core'),
						'name' => 'categories',
						'type' => 'taxonomy',
						'instructions' => esc_html_x('Select categories', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5eca925bbfd0f',
									'operator' => '==',
									'value' => 'categories',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'taxonomy' => 'product_cat',
						'field_type' => 'checkbox',
						'add_term' => 0,
						'save_terms' => 0,
						'load_terms' => 0,
						'return_format' => 'id',
						'multiple' => 0,
						'allow_null' => 0,
					),
					array(
						'key' => 'field_5eca925bbfd11',
						'label' => esc_html_x('Include sub-categories', 'Backend setting label', 'rey-core'),
						'name' => 'include_sub',
						'type' => 'true_false',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5eca925bbfd0f',
									'operator' => '==',
									'value' => 'categories',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'message' => '',
						'default_value' => 1,
						'ui' => 1,
						'ui_on_text' => '',
						'ui_off_text' => '',
					),
					array(
						'key' => 'field_5eca925bbfd12',
						'label' => esc_html_x('Tags', 'Backend setting label', 'rey-core'),
						'name' => 'tags',
						'type' => 'taxonomy',
						'instructions' => esc_html_x('Select tags', 'Backend setting description', 'rey-core'),
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5eca925bbfd0f',
									'operator' => '==',
									'value' => 'tags',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'taxonomy' => 'product_tag',
						'field_type' => 'checkbox',
						'add_term' => 0,
						'save_terms' => 0,
						'load_terms' => 0,
						'return_format' => 'id',
						'multiple' => 0,
						'allow_null' => 0,
					),
					array(
						'key' => 'field_5eca925bbfd13',
						'label' => esc_html_x('Attributes', 'Backend setting label', 'rey-core'),
						'name' => 'attributes',
						'type' => 'select',
						'instructions' => '',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_5eca925bbfd0f',
									'operator' => '==',
									'value' => 'attributes',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'choices' => array(
						),
						'default_value' => array(
						),
						'allow_null' => 0,
						'multiple' => 1,
						'ui' => 1,
						'ajax' => 0,
						'return_format' => 'value',
						'placeholder' => '',
					),
				),
			),
			array(
				'key' => 'field_611102cca0482',
				'label' => esc_html_x('Page types', 'Backend setting label', 'rey-core'),
				'name' => 'page_types',
				'type' => 'button_group',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_5eca340a16793',
							'operator' => '==',
							'value' => 'page',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'generic' => esc_html_x('Generic', 'Backend setting label', 'rey-core'),
					'p404' => esc_html_x('404 Page', 'Backend setting label', 'rey-core'),
				),
				'allow_null' => 0,
				'default_value' => 'generic',
				'layout' => 'horizontal',
				'return_format' => 'value',
			),
			array(
				'key' => 'field_5ecbe48e4e7d6',
				'label' => esc_html_x('Operator', 'Backend setting label', 'rey-core'),
				'name' => 'pages_operator',
				'type' => 'button_group',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_5eca340a16793',
							'operator' => '==',
							'value' => 'page',
						),
						array(
							'field' => 'field_611102cca0482',
							'operator' => '==',
							'value' => 'generic',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'include' => esc_html_x('Include', 'Backend setting label', 'rey-core'),
					'exclude' => esc_html_x('Exclude', 'Backend setting label', 'rey-core'),
				),
				'allow_null' => 0,
				'default_value' => '',
				'layout' => 'horizontal',
				'return_format' => 'value',
			),
			array(
				'key' => 'field_5ecaa8b5e3f42',
				'label' => esc_html_x('Pages', 'Backend setting label', 'rey-core'),
				'name' => 'pages',
				'type' => 'relationship',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_5eca340a16793',
							'operator' => '==',
							'value' => 'page',
						),
						array(
							'field' => 'field_611102cca0482',
							'operator' => '==',
							'value' => 'generic',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'post_type' => array(
					0 => 'page',
				),
				'taxonomy' => '',
				'filters' => array(
					0 => 'search',
				),
				'elements' => '',
				'min' => '',
				'max' => '',
				'return_format' => 'id',
			),
			array(
				'key' => 'field_5ece7a7587e17',
				'label' => esc_html_x('ADVANCED', 'Backend setting label', 'rey-core'),
				'name' => '',
				'type' => 'tab',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'placement' => 'top',
				'endpoint' => 0,
			),
			array(
				'key' => 'field_5ecbf81eebf4c',
				'label' => esc_html_x('Priority', 'Backend setting label', 'rey-core'),
				'name' => 'template_priority',
				'type' => 'number',
				'instructions' => esc_html_x('Add a priority. Useful when multiple templates apply on the same location. The biggest number will have priority.', 'Backend setting description', 'rey-core'),
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '--size-1',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			array(
				'key' => 'field_5ecd0914db04a',
				'label' => esc_html_x('Override individual settings', 'Backend setting label', 'rey-core'),
				'name' => 'template_override_individual',
				'type' => 'true_false',
				'instructions' => esc_html_x('If a page or a found location has options set individually, you can force this template to override those settings.', 'Backend setting description', 'rey-core'),
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'message' => '',
				'default_value' => 0,
				'ui' => 1,
				'ui_on_text' => '',
				'ui_off_text' => '',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'rey-templates',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'acf_after_title',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
	));

	endif;
