<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace MediaCloud\Vendor\Carbon\Laravel;
use MediaCloud\Vendor\Carbon\Carbon;
use MediaCloud\Vendor\Carbon\CarbonImmutable;
use MediaCloud\Vendor\Carbon\CarbonInterval;
use MediaCloud\Vendor\Carbon\CarbonPeriod;
use MediaCloud\Vendor\Illuminate\Contracts\Events\Dispatcher as DispatcherContract;
use MediaCloud\Vendor\Illuminate\Events\Dispatcher;
use MediaCloud\Vendor\Illuminate\Events\EventDispatcher;
use MediaCloud\Vendor\Illuminate\Support\Carbon as IlluminateCarbon;
use MediaCloud\Vendor\Illuminate\Support\Facades\Date;
use Throwable;

class ServiceProvider extends \MediaCloud\Vendor\Illuminate\Support\ServiceProvider
{
    public function boot()
    {
        $this->updateLocale();

        if (!$this->app->bound('events')) {
            return;
        }

        $service = $this;
        $events = $this->app['events'];

        if ($this->isEventDispatcher($events)) {
            $events->listen(class_exists('Illuminate\Foundation\Events\LocaleUpdated') ? 'Illuminate\Foundation\Events\LocaleUpdated' : 'locale.changed', function () use ($service) {
                $service->updateLocale();
            });
        }
    }

    public function updateLocale()
    {
        $app = $this->app && method_exists($this->app, 'getLocale') ? $this->app : app('translator');
        $locale = $app->getLocale();
        Carbon::setLocale($locale);
        CarbonImmutable::setLocale($locale);
        CarbonPeriod::setLocale($locale);
        CarbonInterval::setLocale($locale);

        if (class_exists(IlluminateCarbon::class)) {
            IlluminateCarbon::setLocale($locale);
        }

        if (class_exists(Date::class)) {
            try {
                $root = Date::getFacadeRoot();
                $root->setLocale($locale);
            } catch (Throwable $e) {
                // Non Carbon class in use in Date facade
            }
        }
    }

    public function register()
    {
        // Needed for Laravel < 5.3 compatibility
    }

    protected function isEventDispatcher($instance)
    {
        return $instance instanceof EventDispatcher
            || $instance instanceof Dispatcher
            || $instance instanceof DispatcherContract;
    }
}
