<?php

/**
 * Mux PHP - Copyright 2019 Mux Inc.
 * NOTE: This file is auto generated. Do not edit this file manually.
 */

namespace MediaCloud\Vendor\MuxPhp\Models;

use \ArrayAccess;
use \MediaCloud\Vendor\MuxPhp\ObjectSerializer;

/**
 * Insight Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 */
class Insight implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'Insight';

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'total_watch_time' => 'int',
        'total_views' => 'int',
        'negative_impact_score' => 'float',
        'metric' => 'double',
        'filter_value' => 'string',
        'filter_column' => 'string'
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $openAPIFormats = [
        'total_watch_time' => 'int64',
        'total_views' => 'int64',
        'negative_impact_score' => 'float',
        'metric' => 'double',
        'filter_value' => null,
        'filter_column' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'total_watch_time' => 'total_watch_time',
        'total_views' => 'total_views',
        'negative_impact_score' => 'negative_impact_score',
        'metric' => 'metric',
        'filter_value' => 'filter_value',
        'filter_column' => 'filter_column'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'total_watch_time' => 'setTotalWatchTime',
        'total_views' => 'setTotalViews',
        'negative_impact_score' => 'setNegativeImpactScore',
        'metric' => 'setMetric',
        'filter_value' => 'setFilterValue',
        'filter_column' => 'setFilterColumn'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'total_watch_time' => 'getTotalWatchTime',
        'total_views' => 'getTotalViews',
        'negative_impact_score' => 'getNegativeImpactScore',
        'metric' => 'getMetric',
        'filter_value' => 'getFilterValue',
        'filter_column' => 'getFilterColumn'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['total_watch_time'] = isset($data['total_watch_time']) ? $data['total_watch_time'] : null;
        $this->container['total_views'] = isset($data['total_views']) ? $data['total_views'] : null;
        $this->container['negative_impact_score'] = isset($data['negative_impact_score']) ? $data['negative_impact_score'] : null;
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['filter_value'] = isset($data['filter_value']) ? $data['filter_value'] : null;
        $this->container['filter_column'] = isset($data['filter_column']) ? $data['filter_column'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets total_watch_time
     *
     * @return int|null
     */
    public function getTotalWatchTime()
    {
        return $this->container['total_watch_time'];
    }

    /**
     * Sets total_watch_time
     *
     * @param int|null $total_watch_time total_watch_time
     *
     * @return $this
     */
    public function setTotalWatchTime($total_watch_time)
    {
        $this->container['total_watch_time'] = $total_watch_time;

        return $this;
    }

    /**
     * Gets total_views
     *
     * @return int|null
     */
    public function getTotalViews()
    {
        return $this->container['total_views'];
    }

    /**
     * Sets total_views
     *
     * @param int|null $total_views total_views
     *
     * @return $this
     */
    public function setTotalViews($total_views)
    {
        $this->container['total_views'] = $total_views;

        return $this;
    }

    /**
     * Gets negative_impact_score
     *
     * @return float|null
     */
    public function getNegativeImpactScore()
    {
        return $this->container['negative_impact_score'];
    }

    /**
     * Sets negative_impact_score
     *
     * @param float|null $negative_impact_score negative_impact_score
     *
     * @return $this
     */
    public function setNegativeImpactScore($negative_impact_score)
    {
        $this->container['negative_impact_score'] = $negative_impact_score;

        return $this;
    }

    /**
     * Gets metric
     *
     * @return double|null
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     *
     * @param double|null $metric metric
     *
     * @return $this
     */
    public function setMetric($metric)
    {
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets filter_value
     *
     * @return string|null
     */
    public function getFilterValue()
    {
        return $this->container['filter_value'];
    }

    /**
     * Sets filter_value
     *
     * @param string|null $filter_value filter_value
     *
     * @return $this
     */
    public function setFilterValue($filter_value)
    {
        $this->container['filter_value'] = $filter_value;

        return $this;
    }

    /**
     * Gets filter_column
     *
     * @return string|null
     */
    public function getFilterColumn()
    {
        return $this->container['filter_column'];
    }

    /**
     * Sets filter_column
     *
     * @param string|null $filter_column filter_column
     *
     * @return $this
     */
    public function setFilterColumn($filter_column)
    {
        $this->container['filter_column'] = $filter_column;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


