<?php

/**
 * Mux PHP - Copyright 2019 Mux Inc.
 * NOTE: This file is auto generated. Do not edit this file manually.
 */

namespace MediaCloud\Vendor\MuxPhp\Models;

use \ArrayAccess;
use \MediaCloud\Vendor\MuxPhp\ObjectSerializer;

/**
 * CreateUploadRequest Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 */
class CreateUploadRequest implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'CreateUploadRequest';

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'timeout' => 'int',
        'cors_origin' => 'string',
        'new_asset_settings' => '\MediaCloud\Vendor\MuxPhp\Models\CreateAssetRequest',
        'test' => 'bool'
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $openAPIFormats = [
        'timeout' => 'int32',
        'cors_origin' => null,
        'new_asset_settings' => null,
        'test' => 'boolean'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'timeout' => 'timeout',
        'cors_origin' => 'cors_origin',
        'new_asset_settings' => 'new_asset_settings',
        'test' => 'test'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'timeout' => 'setTimeout',
        'cors_origin' => 'setCorsOrigin',
        'new_asset_settings' => 'setNewAssetSettings',
        'test' => 'setTest'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'timeout' => 'getTimeout',
        'cors_origin' => 'getCorsOrigin',
        'new_asset_settings' => 'getNewAssetSettings',
        'test' => 'getTest'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['timeout'] = isset($data['timeout']) ? $data['timeout'] : 3600;
        $this->container['cors_origin'] = isset($data['cors_origin']) ? $data['cors_origin'] : null;
        $this->container['new_asset_settings'] = isset($data['new_asset_settings']) ? $data['new_asset_settings'] : null;
        $this->container['test'] = isset($data['test']) ? $data['test'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['timeout']) && ($this->container['timeout'] > 604800)) {
            $invalidProperties[] = "invalid value for 'timeout', must be smaller than or equal to 604800.";
        }

        if (!is_null($this->container['timeout']) && ($this->container['timeout'] < 60)) {
            $invalidProperties[] = "invalid value for 'timeout', must be bigger than or equal to 60.";
        }

        if ($this->container['new_asset_settings'] === null) {
            $invalidProperties[] = "'new_asset_settings' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets timeout
     *
     * @return int|null
     */
    public function getTimeout()
    {
        return $this->container['timeout'];
    }

    /**
     * Sets timeout
     *
     * @param int|null $timeout Max time in seconds for the signed upload URL to be valid. If a successful upload has not occurred before the timeout limit, the direct upload is marked `timed_out`
     *
     * @return $this
     */
    public function setTimeout($timeout)
    {

        if (!is_null($timeout) && ($timeout > 604800)) {
            throw new \InvalidArgumentException('invalid value for $timeout when calling CreateUploadRequest., must be smaller than or equal to 604800.');
        }
        if (!is_null($timeout) && ($timeout < 60)) {
            throw new \InvalidArgumentException('invalid value for $timeout when calling CreateUploadRequest., must be bigger than or equal to 60.');
        }

        $this->container['timeout'] = $timeout;

        return $this;
    }

    /**
     * Gets cors_origin
     *
     * @return string|null
     */
    public function getCorsOrigin()
    {
        return $this->container['cors_origin'];
    }

    /**
     * Sets cors_origin
     *
     * @param string|null $cors_origin If the upload URL will be used in a browser, you must specify the origin in order for the signed URL to have the correct CORS headers.
     *
     * @return $this
     */
    public function setCorsOrigin($cors_origin)
    {
        $this->container['cors_origin'] = $cors_origin;

        return $this;
    }

    /**
     * Gets new_asset_settings
     *
     * @return \MediaCloud\Vendor\MuxPhp\Models\CreateAssetRequest
     */
    public function getNewAssetSettings()
    {
        return $this->container['new_asset_settings'];
    }

    /**
     * Sets new_asset_settings
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateAssetRequest $new_asset_settings new_asset_settings
     *
     * @return $this
     */
    public function setNewAssetSettings($new_asset_settings)
    {
        $this->container['new_asset_settings'] = $new_asset_settings;

        return $this;
    }

    /**
     * Gets test
     *
     * @return bool|null
     */
    public function getTest()
    {
        return $this->container['test'];
    }

    /**
     * Sets test
     *
     * @param bool|null $test test
     *
     * @return $this
     */
    public function setTest($test)
    {
        $this->container['test'] = $test;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


