<?php

namespace MediaCloud\Vendor\Aws\LicenseManager;
use MediaCloud\Vendor\Aws\AwsClient;

/**
 * This client is used to interact with the **AWS License Manager** service.
 * @method \MediaCloud\Vendor\Aws\Result acceptGrant(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise acceptGrantAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result checkInLicense(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise checkInLicenseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result checkoutBorrowLicense(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise checkoutBorrowLicenseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result checkoutLicense(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise checkoutLicenseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createGrant(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createGrantAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createGrantVersion(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createGrantVersionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createLicense(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createLicenseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createLicenseConfiguration(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createLicenseConfigurationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createLicenseConversionTaskForResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createLicenseConversionTaskForResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createLicenseManagerReportGenerator(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createLicenseManagerReportGeneratorAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createLicenseVersion(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createLicenseVersionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createToken(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTokenAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteGrant(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteGrantAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteLicense(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteLicenseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteLicenseConfiguration(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteLicenseConfigurationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteLicenseManagerReportGenerator(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteLicenseManagerReportGeneratorAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteToken(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTokenAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result extendLicenseConsumption(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise extendLicenseConsumptionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getAccessToken(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getAccessTokenAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getGrant(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getGrantAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getLicense(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getLicenseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getLicenseConfiguration(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getLicenseConfigurationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getLicenseConversionTask(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getLicenseConversionTaskAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getLicenseManagerReportGenerator(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getLicenseManagerReportGeneratorAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getLicenseUsage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getLicenseUsageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getServiceSettings(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getServiceSettingsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listAssociationsForLicenseConfiguration(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listAssociationsForLicenseConfigurationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listDistributedGrants(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listDistributedGrantsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listFailuresForLicenseConfigurationOperations(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listFailuresForLicenseConfigurationOperationsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listLicenseConfigurations(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listLicenseConfigurationsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listLicenseConversionTasks(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listLicenseConversionTasksAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listLicenseManagerReportGenerators(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listLicenseManagerReportGeneratorsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listLicenseSpecificationsForResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listLicenseSpecificationsForResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listLicenseVersions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listLicenseVersionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listLicenses(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listLicensesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listReceivedGrants(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listReceivedGrantsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listReceivedLicenses(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listReceivedLicensesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listResourceInventory(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listResourceInventoryAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listTagsForResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listTagsForResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listTokens(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listTokensAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listUsageForLicenseConfiguration(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listUsageForLicenseConfigurationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result rejectGrant(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise rejectGrantAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result tagResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise tagResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result untagResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise untagResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateLicenseConfiguration(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateLicenseConfigurationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateLicenseManagerReportGenerator(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateLicenseManagerReportGeneratorAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateLicenseSpecificationsForResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateLicenseSpecificationsForResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateServiceSettings(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateServiceSettingsAsync(array $args = [])
 */
class LicenseManagerClient extends AwsClient {}
