<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the html for system status.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    Event_Tickets_Manager_For_Woocommerce
 * @subpackage Event_Tickets_Manager_For_Woocommerce/admin/partials
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// Template for showing information about system status.
global $etmfw_wps_etmfw_obj;
$etmfw_default_status = $etmfw_wps_etmfw_obj->wps_etmfw_plug_system_status();
$etmfw_wordpress_details = is_array( $etmfw_default_status['wp'] ) && ! empty( $etmfw_default_status['wp'] ) ? $etmfw_default_status['wp'] : array();
$etmfw_php_details = is_array( $etmfw_default_status['php'] ) && ! empty( $etmfw_default_status['php'] ) ? $etmfw_default_status['php'] : array();
?>
<div class="wps-etmfw-table-wrap">
	<div class="wps-col-wrap">
		<div id="wps-etmfw-table-inner-container" class="table-responsive mdc-data-table">
			<div class="mdc-data-table__table-container">
				<table class="wps-etmfw-table mdc-data-table__table wps-table" id="wps-etmfw-wp">
					<thead>
						<tr>
							<th class="mdc-data-table__header-cell"><?php esc_html_e( 'WP Variables', 'event-tickets-manager-for-woocommerce' ); ?></th>
							<th class="mdc-data-table__header-cell"><?php esc_html_e( 'WP Values', 'event-tickets-manager-for-woocommerce' ); ?></th>
						</tr>
					</thead>
					<tbody class="mdc-data-table__content">
						<?php if ( is_array( $etmfw_wordpress_details ) && ! empty( $etmfw_wordpress_details ) ) { ?>
							<?php foreach ( $etmfw_wordpress_details as $wp_key => $wp_value ) { ?>
								<?php if ( isset( $wp_key ) && 'wp_users' != $wp_key ) { ?>
									<tr class="mdc-data-table__row">
										<td class="mdc-data-table__cell"><?php echo esc_html( $wp_key ); ?></td>
										<td class="mdc-data-table__cell"><?php echo esc_html( $wp_value ); ?></td>
									</tr>
								<?php } ?>
							<?php } ?>
						<?php } ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
	<div class="wps-col-wrap">
		<div id="wps-etmfw-table-inner-container" class="table-responsive mdc-data-table">
			<div class="mdc-data-table__table-container">
				<table class="wps-etmfw-table mdc-data-table__table wps-table" id="wps-etmfw-sys">
					<thead>
						<tr>
							<th class="mdc-data-table__header-cell"><?php esc_html_e( 'System Variables', 'event-tickets-manager-for-woocommerce' ); ?></th>
							<th class="mdc-data-table__header-cell"><?php esc_html_e( 'System Values', 'event-tickets-manager-for-woocommerce' ); ?></th>
						</tr>
					</thead>
					<tbody class="mdc-data-table__content">
						<?php if ( is_array( $etmfw_php_details ) && ! empty( $etmfw_php_details ) ) { ?>
							<?php foreach ( $etmfw_php_details as $php_key => $php_value ) { ?>
								<tr class="mdc-data-table__row">
									<td class="mdc-data-table__cell"><?php echo esc_html( $php_key ); ?></td>
									<td class="mdc-data-table__cell"><?php echo esc_html( $php_value ); ?></td>
								</tr>
							<?php } ?>
						<?php } ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
